// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.transfer;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.transfer.ConnectorArgs;
import com.pulumi.aws.transfer.inputs.ConnectorState;
import com.pulumi.aws.transfer.outputs.ConnectorAs2Config;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a AWS Transfer AS2 Connector resource.
 * 
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Connector;
 * import com.pulumi.aws.transfer.ConnectorArgs;
 * import com.pulumi.aws.transfer.inputs.ConnectorAs2ConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Connector(&#34;example&#34;, ConnectorArgs.builder()        
 *             .accessRole(aws_iam_role.test().arn())
 *             .as2Config(ConnectorAs2ConfigArgs.builder()
 *                 .compression(&#34;DISABLED&#34;)
 *                 .encryptionAlgorithm(&#34;AWS128_CBC&#34;)
 *                 .messageSubject(&#34;For Connector&#34;)
 *                 .localProfileId(aws_transfer_profile.local().profile_id())
 *                 .mdnResponse(&#34;NONE&#34;)
 *                 .mdnSigningAlgorithm(&#34;NONE&#34;)
 *                 .partnerProfileId(aws_transfer_profile.partner().profile_id())
 *                 .signingAlgorithm(&#34;NONE&#34;)
 *                 .build())
 *             .url(&#34;http://www.test.com&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Transfer AS2 Connector using the `connector_id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:transfer/connector:Connector example c-4221a88afd5f4362a
 * ```
 * 
 */
@ResourceType(type="aws:transfer/connector:Connector")
public class Connector extends com.pulumi.resources.CustomResource {
    /**
     * The IAM Role which provides read and write access to the parent directory of the file location mentioned in the StartFileTransfer request.
     * 
     */
    @Export(name="accessRole", refs={String.class}, tree="[0]")
    private Output<String> accessRole;

    /**
     * @return The IAM Role which provides read and write access to the parent directory of the file location mentioned in the StartFileTransfer request.
     * 
     */
    public Output<String> accessRole() {
        return this.accessRole;
    }
    /**
     * The ARN of the connector.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The ARN of the connector.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The parameters to configure for the connector object. Fields documented below.
     * 
     */
    @Export(name="as2Config", refs={ConnectorAs2Config.class}, tree="[0]")
    private Output<ConnectorAs2Config> as2Config;

    /**
     * @return The parameters to configure for the connector object. Fields documented below.
     * 
     */
    public Output<ConnectorAs2Config> as2Config() {
        return this.as2Config;
    }
    /**
     * The unique identifier for the AS2 profile.
     * 
     */
    @Export(name="connectorId", refs={String.class}, tree="[0]")
    private Output<String> connectorId;

    /**
     * @return The unique identifier for the AS2 profile.
     * 
     */
    public Output<String> connectorId() {
        return this.connectorId;
    }
    /**
     * The IAM Role which is required for allowing the connector to turn on CloudWatch logging for Amazon S3 events.
     * 
     */
    @Export(name="loggingRole", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> loggingRole;

    /**
     * @return The IAM Role which is required for allowing the connector to turn on CloudWatch logging for Amazon S3 events.
     * 
     */
    public Output<Optional<String>> loggingRole() {
        return Codegen.optional(this.loggingRole);
    }
    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * The URL of the partners AS2 endpoint.
     * 
     */
    @Export(name="url", refs={String.class}, tree="[0]")
    private Output<String> url;

    /**
     * @return The URL of the partners AS2 endpoint.
     * 
     */
    public Output<String> url() {
        return this.url;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Connector(String name) {
        this(name, ConnectorArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Connector(String name, ConnectorArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Connector(String name, ConnectorArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:transfer/connector:Connector", name, args == null ? ConnectorArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Connector(String name, Output<String> id, @Nullable ConnectorState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:transfer/connector:Connector", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Connector get(String name, Output<String> id, @Nullable ConnectorState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Connector(name, id, state, options);
    }
}
