// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.transfer;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.transfer.AccessArgs;
import com.pulumi.aws.transfer.inputs.AccessState;
import com.pulumi.aws.transfer.outputs.AccessHomeDirectoryMapping;
import com.pulumi.aws.transfer.outputs.AccessPosixProfile;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a AWS Transfer Access resource.
 * 
 * ## Example Usage
 * ### Basic S3
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Access;
 * import com.pulumi.aws.transfer.AccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Access(&#34;example&#34;, AccessArgs.builder()        
 *             .externalId(&#34;S-1-1-12-1234567890-123456789-1234567890-1234&#34;)
 *             .serverId(aws_transfer_server.example().id())
 *             .role(aws_iam_role.example().arn())
 *             .homeDirectory(String.format(&#34;/%s/&#34;, aws_s3_bucket.example().id()))
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Basic EFS
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Access;
 * import com.pulumi.aws.transfer.AccessArgs;
 * import com.pulumi.aws.transfer.inputs.AccessPosixProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new Access(&#34;test&#34;, AccessArgs.builder()        
 *             .externalId(&#34;S-1-1-12-1234567890-123456789-1234567890-1234&#34;)
 *             .serverId(aws_transfer_server.test().id())
 *             .role(aws_iam_role.test().arn())
 *             .homeDirectory(String.format(&#34;/%s/&#34;, aws_efs_file_system.test().id()))
 *             .posixProfile(AccessPosixProfileArgs.builder()
 *                 .gid(1000)
 *                 .uid(1000)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Transfer Accesses using the `server_id` and `external_id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:transfer/access:Access example s-12345678/S-1-1-12-1234567890-123456789-1234567890-1234
 * ```
 * 
 */
@ResourceType(type="aws:transfer/access:Access")
public class Access extends com.pulumi.resources.CustomResource {
    /**
     * The SID of a group in the directory connected to the Transfer Server (e.g., `S-1-1-12-1234567890-123456789-1234567890-1234`)
     * 
     */
    @Export(name="externalId", refs={String.class}, tree="[0]")
    private Output<String> externalId;

    /**
     * @return The SID of a group in the directory connected to the Transfer Server (e.g., `S-1-1-12-1234567890-123456789-1234567890-1234`)
     * 
     */
    public Output<String> externalId() {
        return this.externalId;
    }
    /**
     * The landing directory (folder) for a user when they log in to the server using their SFTP client.  It should begin with a `/`.  The first item in the path is the name of the home bucket (accessible as `${Transfer:HomeBucket}` in the policy) and the rest is the home directory (accessible as `${Transfer:HomeDirectory}` in the policy). For example, `/example-bucket-1234/username` would set the home bucket to `example-bucket-1234` and the home directory to `username`.
     * 
     */
    @Export(name="homeDirectory", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> homeDirectory;

    /**
     * @return The landing directory (folder) for a user when they log in to the server using their SFTP client.  It should begin with a `/`.  The first item in the path is the name of the home bucket (accessible as `${Transfer:HomeBucket}` in the policy) and the rest is the home directory (accessible as `${Transfer:HomeDirectory}` in the policy). For example, `/example-bucket-1234/username` would set the home bucket to `example-bucket-1234` and the home directory to `username`.
     * 
     */
    public Output<Optional<String>> homeDirectory() {
        return Codegen.optional(this.homeDirectory);
    }
    /**
     * Logical directory mappings that specify what S3 paths and keys should be visible to your user and how you want to make them visible. See Home Directory Mappings below.
     * 
     */
    @Export(name="homeDirectoryMappings", refs={List.class,AccessHomeDirectoryMapping.class}, tree="[0,1]")
    private Output</* @Nullable */ List<AccessHomeDirectoryMapping>> homeDirectoryMappings;

    /**
     * @return Logical directory mappings that specify what S3 paths and keys should be visible to your user and how you want to make them visible. See Home Directory Mappings below.
     * 
     */
    public Output<Optional<List<AccessHomeDirectoryMapping>>> homeDirectoryMappings() {
        return Codegen.optional(this.homeDirectoryMappings);
    }
    /**
     * The type of landing directory (folder) you mapped for your users&#39; home directory. Valid values are `PATH` and `LOGICAL`.
     * 
     */
    @Export(name="homeDirectoryType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> homeDirectoryType;

    /**
     * @return The type of landing directory (folder) you mapped for your users&#39; home directory. Valid values are `PATH` and `LOGICAL`.
     * 
     */
    public Output<Optional<String>> homeDirectoryType() {
        return Codegen.optional(this.homeDirectoryType);
    }
    /**
     * An IAM JSON policy document that scopes down user access to portions of their Amazon S3 bucket. IAM variables you can use inside this policy include `${Transfer:UserName}`, `${Transfer:HomeDirectory}`, and `${Transfer:HomeBucket}`. These are evaluated on-the-fly when navigating the bucket.
     * 
     */
    @Export(name="policy", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> policy;

    /**
     * @return An IAM JSON policy document that scopes down user access to portions of their Amazon S3 bucket. IAM variables you can use inside this policy include `${Transfer:UserName}`, `${Transfer:HomeDirectory}`, and `${Transfer:HomeBucket}`. These are evaluated on-the-fly when navigating the bucket.
     * 
     */
    public Output<Optional<String>> policy() {
        return Codegen.optional(this.policy);
    }
    /**
     * Specifies the full POSIX identity, including user ID (Uid), group ID (Gid), and any secondary groups IDs (SecondaryGids), that controls your users&#39; access to your Amazon EFS file systems. See Posix Profile below.
     * 
     */
    @Export(name="posixProfile", refs={AccessPosixProfile.class}, tree="[0]")
    private Output</* @Nullable */ AccessPosixProfile> posixProfile;

    /**
     * @return Specifies the full POSIX identity, including user ID (Uid), group ID (Gid), and any secondary groups IDs (SecondaryGids), that controls your users&#39; access to your Amazon EFS file systems. See Posix Profile below.
     * 
     */
    public Output<Optional<AccessPosixProfile>> posixProfile() {
        return Codegen.optional(this.posixProfile);
    }
    /**
     * Amazon Resource Name (ARN) of an IAM role that allows the service to controls your user’s access to your Amazon S3 bucket.
     * 
     */
    @Export(name="role", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> role;

    /**
     * @return Amazon Resource Name (ARN) of an IAM role that allows the service to controls your user’s access to your Amazon S3 bucket.
     * 
     */
    public Output<Optional<String>> role() {
        return Codegen.optional(this.role);
    }
    /**
     * The Server ID of the Transfer Server (e.g., `s-12345678`)
     * 
     */
    @Export(name="serverId", refs={String.class}, tree="[0]")
    private Output<String> serverId;

    /**
     * @return The Server ID of the Transfer Server (e.g., `s-12345678`)
     * 
     */
    public Output<String> serverId() {
        return this.serverId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Access(String name) {
        this(name, AccessArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Access(String name, AccessArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Access(String name, AccessArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:transfer/access:Access", name, args == null ? AccessArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Access(String name, Output<String> id, @Nullable AccessState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:transfer/access:Access", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Access get(String name, Output<String> id, @Nullable AccessState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Access(name, id, state, options);
    }
}
