// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.transcribe;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class VocabularyArgs extends com.pulumi.resources.ResourceArgs {

    public static final VocabularyArgs Empty = new VocabularyArgs();

    /**
     * The language code you selected for your vocabulary.
     * 
     */
    @Import(name="languageCode", required=true)
    private Output<String> languageCode;

    /**
     * @return The language code you selected for your vocabulary.
     * 
     */
    public Output<String> languageCode() {
        return this.languageCode;
    }

    /**
     * A list of terms to include in the vocabulary. Conflicts with `vocabulary_file_uri`
     * 
     */
    @Import(name="phrases")
    private @Nullable Output<List<String>> phrases;

    /**
     * @return A list of terms to include in the vocabulary. Conflicts with `vocabulary_file_uri`
     * 
     */
    public Optional<Output<List<String>>> phrases() {
        return Optional.ofNullable(this.phrases);
    }

    /**
     * A map of tags to assign to the Vocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the Vocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * The Amazon S3 location (URI) of the text file that contains your custom vocabulary. Conflicts wth `phrases`.
     * 
     */
    @Import(name="vocabularyFileUri")
    private @Nullable Output<String> vocabularyFileUri;

    /**
     * @return The Amazon S3 location (URI) of the text file that contains your custom vocabulary. Conflicts wth `phrases`.
     * 
     */
    public Optional<Output<String>> vocabularyFileUri() {
        return Optional.ofNullable(this.vocabularyFileUri);
    }

    /**
     * The name of the Vocabulary.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="vocabularyName", required=true)
    private Output<String> vocabularyName;

    /**
     * @return The name of the Vocabulary.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> vocabularyName() {
        return this.vocabularyName;
    }

    private VocabularyArgs() {}

    private VocabularyArgs(VocabularyArgs $) {
        this.languageCode = $.languageCode;
        this.phrases = $.phrases;
        this.tags = $.tags;
        this.vocabularyFileUri = $.vocabularyFileUri;
        this.vocabularyName = $.vocabularyName;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(VocabularyArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private VocabularyArgs $;

        public Builder() {
            $ = new VocabularyArgs();
        }

        public Builder(VocabularyArgs defaults) {
            $ = new VocabularyArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param languageCode The language code you selected for your vocabulary.
         * 
         * @return builder
         * 
         */
        public Builder languageCode(Output<String> languageCode) {
            $.languageCode = languageCode;
            return this;
        }

        /**
         * @param languageCode The language code you selected for your vocabulary.
         * 
         * @return builder
         * 
         */
        public Builder languageCode(String languageCode) {
            return languageCode(Output.of(languageCode));
        }

        /**
         * @param phrases A list of terms to include in the vocabulary. Conflicts with `vocabulary_file_uri`
         * 
         * @return builder
         * 
         */
        public Builder phrases(@Nullable Output<List<String>> phrases) {
            $.phrases = phrases;
            return this;
        }

        /**
         * @param phrases A list of terms to include in the vocabulary. Conflicts with `vocabulary_file_uri`
         * 
         * @return builder
         * 
         */
        public Builder phrases(List<String> phrases) {
            return phrases(Output.of(phrases));
        }

        /**
         * @param phrases A list of terms to include in the vocabulary. Conflicts with `vocabulary_file_uri`
         * 
         * @return builder
         * 
         */
        public Builder phrases(String... phrases) {
            return phrases(List.of(phrases));
        }

        /**
         * @param tags A map of tags to assign to the Vocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the Vocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param vocabularyFileUri The Amazon S3 location (URI) of the text file that contains your custom vocabulary. Conflicts wth `phrases`.
         * 
         * @return builder
         * 
         */
        public Builder vocabularyFileUri(@Nullable Output<String> vocabularyFileUri) {
            $.vocabularyFileUri = vocabularyFileUri;
            return this;
        }

        /**
         * @param vocabularyFileUri The Amazon S3 location (URI) of the text file that contains your custom vocabulary. Conflicts wth `phrases`.
         * 
         * @return builder
         * 
         */
        public Builder vocabularyFileUri(String vocabularyFileUri) {
            return vocabularyFileUri(Output.of(vocabularyFileUri));
        }

        /**
         * @param vocabularyName The name of the Vocabulary.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder vocabularyName(Output<String> vocabularyName) {
            $.vocabularyName = vocabularyName;
            return this;
        }

        /**
         * @param vocabularyName The name of the Vocabulary.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder vocabularyName(String vocabularyName) {
            return vocabularyName(Output.of(vocabularyName));
        }

        public VocabularyArgs build() {
            $.languageCode = Objects.requireNonNull($.languageCode, "expected parameter 'languageCode' to be non-null");
            $.vocabularyName = Objects.requireNonNull($.vocabularyName, "expected parameter 'vocabularyName' to be non-null");
            return $;
        }
    }

}
