// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.synthetics.outputs;

import com.pulumi.core.annotations.CustomType;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class CanaryRunConfig {
    /**
     * @return Whether this canary is to use active AWS X-Ray tracing when it runs. You can enable active tracing only for canaries that use version syn-nodejs-2.0 or later for their canary runtime.
     * 
     */
    private @Nullable Boolean activeTracing;
    /**
     * @return Map of environment variables that are accessible from the canary during execution. Please see [AWS Docs](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime) for variables reserved for Lambda.
     * 
     */
    private @Nullable Map<String,String> environmentVariables;
    /**
     * @return Maximum amount of memory available to the canary while it is running, in MB. The value you specify must be a multiple of 64.
     * 
     */
    private @Nullable Integer memoryInMb;
    /**
     * @return Number of seconds the canary is allowed to run before it must stop. If you omit this field, the frequency of the canary is used, up to a maximum of 840 (14 minutes).
     * 
     */
    private @Nullable Integer timeoutInSeconds;

    private CanaryRunConfig() {}
    /**
     * @return Whether this canary is to use active AWS X-Ray tracing when it runs. You can enable active tracing only for canaries that use version syn-nodejs-2.0 or later for their canary runtime.
     * 
     */
    public Optional<Boolean> activeTracing() {
        return Optional.ofNullable(this.activeTracing);
    }
    /**
     * @return Map of environment variables that are accessible from the canary during execution. Please see [AWS Docs](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime) for variables reserved for Lambda.
     * 
     */
    public Map<String,String> environmentVariables() {
        return this.environmentVariables == null ? Map.of() : this.environmentVariables;
    }
    /**
     * @return Maximum amount of memory available to the canary while it is running, in MB. The value you specify must be a multiple of 64.
     * 
     */
    public Optional<Integer> memoryInMb() {
        return Optional.ofNullable(this.memoryInMb);
    }
    /**
     * @return Number of seconds the canary is allowed to run before it must stop. If you omit this field, the frequency of the canary is used, up to a maximum of 840 (14 minutes).
     * 
     */
    public Optional<Integer> timeoutInSeconds() {
        return Optional.ofNullable(this.timeoutInSeconds);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CanaryRunConfig defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable Boolean activeTracing;
        private @Nullable Map<String,String> environmentVariables;
        private @Nullable Integer memoryInMb;
        private @Nullable Integer timeoutInSeconds;
        public Builder() {}
        public Builder(CanaryRunConfig defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.activeTracing = defaults.activeTracing;
    	      this.environmentVariables = defaults.environmentVariables;
    	      this.memoryInMb = defaults.memoryInMb;
    	      this.timeoutInSeconds = defaults.timeoutInSeconds;
        }

        @CustomType.Setter
        public Builder activeTracing(@Nullable Boolean activeTracing) {
            this.activeTracing = activeTracing;
            return this;
        }
        @CustomType.Setter
        public Builder environmentVariables(@Nullable Map<String,String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }
        @CustomType.Setter
        public Builder memoryInMb(@Nullable Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
            return this;
        }
        @CustomType.Setter
        public Builder timeoutInSeconds(@Nullable Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }
        public CanaryRunConfig build() {
            final var o = new CanaryRunConfig();
            o.activeTracing = activeTracing;
            o.environmentVariables = environmentVariables;
            o.memoryInMb = memoryInMb;
            o.timeoutInSeconds = timeoutInSeconds;
            return o;
        }
    }
}
