// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.storagegateway;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.storagegateway.UploadBufferArgs;
import com.pulumi.aws.storagegateway.inputs.UploadBufferState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Manages an AWS Storage Gateway upload buffer.
 * 
 * &gt; **NOTE:** The Storage Gateway API provides no method to remove an upload buffer disk. Destroying this resource does not perform any Storage Gateway actions.
 * 
 * ## Example Usage
 * ### Cached and VTL Gateway Type
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.StoragegatewayFunctions;
 * import com.pulumi.aws.storagegateway.inputs.GetLocalDiskArgs;
 * import com.pulumi.aws.storagegateway.UploadBuffer;
 * import com.pulumi.aws.storagegateway.UploadBufferArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var testLocalDisk = StoragegatewayFunctions.getLocalDisk(GetLocalDiskArgs.builder()
 *             .diskNode(aws_volume_attachment.test().device_name())
 *             .gatewayArn(aws_storagegateway_gateway.test().arn())
 *             .build());
 * 
 *         var testUploadBuffer = new UploadBuffer(&#34;testUploadBuffer&#34;, UploadBufferArgs.builder()        
 *             .diskPath(testLocalDisk.applyValue(getLocalDiskResult -&gt; getLocalDiskResult.diskPath()))
 *             .gatewayArn(aws_storagegateway_gateway.test().arn())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Stored Gateway Type
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.StoragegatewayFunctions;
 * import com.pulumi.aws.storagegateway.inputs.GetLocalDiskArgs;
 * import com.pulumi.aws.storagegateway.UploadBuffer;
 * import com.pulumi.aws.storagegateway.UploadBufferArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var test = StoragegatewayFunctions.getLocalDisk(GetLocalDiskArgs.builder()
 *             .diskNode(aws_volume_attachment.test().device_name())
 *             .gatewayArn(aws_storagegateway_gateway.test().arn())
 *             .build());
 * 
 *         var example = new UploadBuffer(&#34;example&#34;, UploadBufferArgs.builder()        
 *             .diskId(data.aws_storagegateway_local_disk().example().id())
 *             .gatewayArn(aws_storagegateway_gateway.example().arn())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_storagegateway_upload_buffer` using the gateway Amazon Resource Name (ARN) and local disk identifier separated with a colon (`:`). For example:
 * 
 * ```sh
 *  $ pulumi import aws:storagegateway/uploadBuffer:UploadBuffer example arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678:pci-0000:03:00.0-scsi-0:0:0:0
 * ```
 * 
 */
@ResourceType(type="aws:storagegateway/uploadBuffer:UploadBuffer")
public class UploadBuffer extends com.pulumi.resources.CustomResource {
    /**
     * Local disk identifier. For example, `pci-0000:03:00.0-scsi-0:0:0:0`.
     * 
     */
    @Export(name="diskId", refs={String.class}, tree="[0]")
    private Output<String> diskId;

    /**
     * @return Local disk identifier. For example, `pci-0000:03:00.0-scsi-0:0:0:0`.
     * 
     */
    public Output<String> diskId() {
        return this.diskId;
    }
    /**
     * Local disk path. For example, `/dev/nvme1n1`.
     * 
     */
    @Export(name="diskPath", refs={String.class}, tree="[0]")
    private Output<String> diskPath;

    /**
     * @return Local disk path. For example, `/dev/nvme1n1`.
     * 
     */
    public Output<String> diskPath() {
        return this.diskPath;
    }
    /**
     * The Amazon Resource Name (ARN) of the gateway.
     * 
     */
    @Export(name="gatewayArn", refs={String.class}, tree="[0]")
    private Output<String> gatewayArn;

    /**
     * @return The Amazon Resource Name (ARN) of the gateway.
     * 
     */
    public Output<String> gatewayArn() {
        return this.gatewayArn;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public UploadBuffer(String name) {
        this(name, UploadBufferArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public UploadBuffer(String name, UploadBufferArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public UploadBuffer(String name, UploadBufferArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:storagegateway/uploadBuffer:UploadBuffer", name, args == null ? UploadBufferArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private UploadBuffer(String name, Output<String> id, @Nullable UploadBufferState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:storagegateway/uploadBuffer:UploadBuffer", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static UploadBuffer get(String name, Output<String> id, @Nullable UploadBufferState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new UploadBuffer(name, id, state, options);
    }
}
