// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.storagegateway;

import com.pulumi.aws.storagegateway.inputs.SmbFileShareCacheAttributesArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class SmbFileShareArgs extends com.pulumi.resources.ResourceArgs {

    public static final SmbFileShareArgs Empty = new SmbFileShareArgs();

    /**
     * The files and folders on this share will only be visible to users with read access. Default value is `false`.
     * 
     */
    @Import(name="accessBasedEnumeration")
    private @Nullable Output<Boolean> accessBasedEnumeration;

    /**
     * @return The files and folders on this share will only be visible to users with read access. Default value is `false`.
     * 
     */
    public Optional<Output<Boolean>> accessBasedEnumeration() {
        return Optional.ofNullable(this.accessBasedEnumeration);
    }

    /**
     * A list of users in the Active Directory that have admin access to the file share. Only valid if `authentication` is set to `ActiveDirectory`.
     * 
     */
    @Import(name="adminUserLists")
    private @Nullable Output<List<String>> adminUserLists;

    /**
     * @return A list of users in the Active Directory that have admin access to the file share. Only valid if `authentication` is set to `ActiveDirectory`.
     * 
     */
    public Optional<Output<List<String>>> adminUserLists() {
        return Optional.ofNullable(this.adminUserLists);
    }

    /**
     * The Amazon Resource Name (ARN) of the CloudWatch Log Group used for the audit logs.
     * 
     */
    @Import(name="auditDestinationArn")
    private @Nullable Output<String> auditDestinationArn;

    /**
     * @return The Amazon Resource Name (ARN) of the CloudWatch Log Group used for the audit logs.
     * 
     */
    public Optional<Output<String>> auditDestinationArn() {
        return Optional.ofNullable(this.auditDestinationArn);
    }

    /**
     * The authentication method that users use to access the file share. Defaults to `ActiveDirectory`. Valid values: `ActiveDirectory`, `GuestAccess`.
     * 
     */
    @Import(name="authentication")
    private @Nullable Output<String> authentication;

    /**
     * @return The authentication method that users use to access the file share. Defaults to `ActiveDirectory`. Valid values: `ActiveDirectory`, `GuestAccess`.
     * 
     */
    public Optional<Output<String>> authentication() {
        return Optional.ofNullable(this.authentication);
    }

    /**
     * The region of the S3 buck used by the file share. Required when specifying a `vpc_endpoint_dns_name`.
     * 
     */
    @Import(name="bucketRegion")
    private @Nullable Output<String> bucketRegion;

    /**
     * @return The region of the S3 buck used by the file share. Required when specifying a `vpc_endpoint_dns_name`.
     * 
     */
    public Optional<Output<String>> bucketRegion() {
        return Optional.ofNullable(this.bucketRegion);
    }

    /**
     * Refresh cache information. see Cache Attributes for more details.
     * 
     */
    @Import(name="cacheAttributes")
    private @Nullable Output<SmbFileShareCacheAttributesArgs> cacheAttributes;

    /**
     * @return Refresh cache information. see Cache Attributes for more details.
     * 
     */
    public Optional<Output<SmbFileShareCacheAttributesArgs>> cacheAttributes() {
        return Optional.ofNullable(this.cacheAttributes);
    }

    /**
     * The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
     * 
     */
    @Import(name="caseSensitivity")
    private @Nullable Output<String> caseSensitivity;

    /**
     * @return The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
     * 
     */
    public Optional<Output<String>> caseSensitivity() {
        return Optional.ofNullable(this.caseSensitivity);
    }

    /**
     * The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
     * 
     */
    @Import(name="defaultStorageClass")
    private @Nullable Output<String> defaultStorageClass;

    /**
     * @return The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
     * 
     */
    public Optional<Output<String>> defaultStorageClass() {
        return Optional.ofNullable(this.defaultStorageClass);
    }

    /**
     * The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
     * 
     */
    @Import(name="fileShareName")
    private @Nullable Output<String> fileShareName;

    /**
     * @return The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
     * 
     */
    public Optional<Output<String>> fileShareName() {
        return Optional.ofNullable(this.fileShareName);
    }

    /**
     * Amazon Resource Name (ARN) of the file gateway.
     * 
     */
    @Import(name="gatewayArn", required=true)
    private Output<String> gatewayArn;

    /**
     * @return Amazon Resource Name (ARN) of the file gateway.
     * 
     */
    public Output<String> gatewayArn() {
        return this.gatewayArn;
    }

    /**
     * Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
     * 
     */
    @Import(name="guessMimeTypeEnabled")
    private @Nullable Output<Boolean> guessMimeTypeEnabled;

    /**
     * @return Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
     * 
     */
    public Optional<Output<Boolean>> guessMimeTypeEnabled() {
        return Optional.ofNullable(this.guessMimeTypeEnabled);
    }

    /**
     * A list of users in the Active Directory that are not allowed to access the file share. Only valid if `authentication` is set to `ActiveDirectory`.
     * 
     */
    @Import(name="invalidUserLists")
    private @Nullable Output<List<String>> invalidUserLists;

    /**
     * @return A list of users in the Active Directory that are not allowed to access the file share. Only valid if `authentication` is set to `ActiveDirectory`.
     * 
     */
    public Optional<Output<List<String>>> invalidUserLists() {
        return Optional.ofNullable(this.invalidUserLists);
    }

    /**
     * Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
     * 
     */
    @Import(name="kmsEncrypted")
    private @Nullable Output<Boolean> kmsEncrypted;

    /**
     * @return Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
     * 
     */
    public Optional<Output<Boolean>> kmsEncrypted() {
        return Optional.ofNullable(this.kmsEncrypted);
    }

    /**
     * Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
     * 
     */
    @Import(name="kmsKeyArn")
    private @Nullable Output<String> kmsKeyArn;

    /**
     * @return Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
     * 
     */
    public Optional<Output<String>> kmsKeyArn() {
        return Optional.ofNullable(this.kmsKeyArn);
    }

    /**
     * The ARN of the backed storage used for storing file data.
     * 
     */
    @Import(name="locationArn", required=true)
    private Output<String> locationArn;

    /**
     * @return The ARN of the backed storage used for storing file data.
     * 
     */
    public Output<String> locationArn() {
        return this.locationArn;
    }

    /**
     * The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
     * 
     */
    @Import(name="notificationPolicy")
    private @Nullable Output<String> notificationPolicy;

    /**
     * @return The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
     * 
     */
    public Optional<Output<String>> notificationPolicy() {
        return Optional.ofNullable(this.notificationPolicy);
    }

    /**
     * Access Control List permission for S3 objects. Defaults to `private`.
     * 
     */
    @Import(name="objectAcl")
    private @Nullable Output<String> objectAcl;

    /**
     * @return Access Control List permission for S3 objects. Defaults to `private`.
     * 
     */
    public Optional<Output<String>> objectAcl() {
        return Optional.ofNullable(this.objectAcl);
    }

    /**
     * Boolean to indicate Opportunistic lock (oplock) status. Defaults to `true`.
     * 
     */
    @Import(name="oplocksEnabled")
    private @Nullable Output<Boolean> oplocksEnabled;

    /**
     * @return Boolean to indicate Opportunistic lock (oplock) status. Defaults to `true`.
     * 
     */
    public Optional<Output<Boolean>> oplocksEnabled() {
        return Optional.ofNullable(this.oplocksEnabled);
    }

    /**
     * Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
     * 
     */
    @Import(name="readOnly")
    private @Nullable Output<Boolean> readOnly;

    /**
     * @return Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
     * 
     */
    public Optional<Output<Boolean>> readOnly() {
        return Optional.ofNullable(this.readOnly);
    }

    /**
     * Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
     * 
     */
    @Import(name="requesterPays")
    private @Nullable Output<Boolean> requesterPays;

    /**
     * @return Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
     * 
     */
    public Optional<Output<Boolean>> requesterPays() {
        return Optional.ofNullable(this.requesterPays);
    }

    /**
     * The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
     * 
     */
    @Import(name="roleArn", required=true)
    private Output<String> roleArn;

    /**
     * @return The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
     * 
     */
    public Output<String> roleArn() {
        return this.roleArn;
    }

    /**
     * Set this value to `true` to enable ACL (access control list) on the SMB fileshare. Set it to `false` to map file and directory permissions to the POSIX permissions. This setting applies only to `ActiveDirectory` authentication type.
     * 
     */
    @Import(name="smbAclEnabled")
    private @Nullable Output<Boolean> smbAclEnabled;

    /**
     * @return Set this value to `true` to enable ACL (access control list) on the SMB fileshare. Set it to `false` to map file and directory permissions to the POSIX permissions. This setting applies only to `ActiveDirectory` authentication type.
     * 
     */
    public Optional<Output<Boolean>> smbAclEnabled() {
        return Optional.ofNullable(this.smbAclEnabled);
    }

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * A list of users in the Active Directory that are allowed to access the file share. If you need to specify an Active directory group, add &#39;@&#39; before the name of the group. It will be set on Allowed group in AWS console. Only valid if `authentication` is set to `ActiveDirectory`.
     * 
     */
    @Import(name="validUserLists")
    private @Nullable Output<List<String>> validUserLists;

    /**
     * @return A list of users in the Active Directory that are allowed to access the file share. If you need to specify an Active directory group, add &#39;@&#39; before the name of the group. It will be set on Allowed group in AWS console. Only valid if `authentication` is set to `ActiveDirectory`.
     * 
     */
    public Optional<Output<List<String>>> validUserLists() {
        return Optional.ofNullable(this.validUserLists);
    }

    /**
     * The DNS name of the VPC endpoint for S3 private link.
     * 
     */
    @Import(name="vpcEndpointDnsName")
    private @Nullable Output<String> vpcEndpointDnsName;

    /**
     * @return The DNS name of the VPC endpoint for S3 private link.
     * 
     */
    public Optional<Output<String>> vpcEndpointDnsName() {
        return Optional.ofNullable(this.vpcEndpointDnsName);
    }

    private SmbFileShareArgs() {}

    private SmbFileShareArgs(SmbFileShareArgs $) {
        this.accessBasedEnumeration = $.accessBasedEnumeration;
        this.adminUserLists = $.adminUserLists;
        this.auditDestinationArn = $.auditDestinationArn;
        this.authentication = $.authentication;
        this.bucketRegion = $.bucketRegion;
        this.cacheAttributes = $.cacheAttributes;
        this.caseSensitivity = $.caseSensitivity;
        this.defaultStorageClass = $.defaultStorageClass;
        this.fileShareName = $.fileShareName;
        this.gatewayArn = $.gatewayArn;
        this.guessMimeTypeEnabled = $.guessMimeTypeEnabled;
        this.invalidUserLists = $.invalidUserLists;
        this.kmsEncrypted = $.kmsEncrypted;
        this.kmsKeyArn = $.kmsKeyArn;
        this.locationArn = $.locationArn;
        this.notificationPolicy = $.notificationPolicy;
        this.objectAcl = $.objectAcl;
        this.oplocksEnabled = $.oplocksEnabled;
        this.readOnly = $.readOnly;
        this.requesterPays = $.requesterPays;
        this.roleArn = $.roleArn;
        this.smbAclEnabled = $.smbAclEnabled;
        this.tags = $.tags;
        this.validUserLists = $.validUserLists;
        this.vpcEndpointDnsName = $.vpcEndpointDnsName;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(SmbFileShareArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private SmbFileShareArgs $;

        public Builder() {
            $ = new SmbFileShareArgs();
        }

        public Builder(SmbFileShareArgs defaults) {
            $ = new SmbFileShareArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param accessBasedEnumeration The files and folders on this share will only be visible to users with read access. Default value is `false`.
         * 
         * @return builder
         * 
         */
        public Builder accessBasedEnumeration(@Nullable Output<Boolean> accessBasedEnumeration) {
            $.accessBasedEnumeration = accessBasedEnumeration;
            return this;
        }

        /**
         * @param accessBasedEnumeration The files and folders on this share will only be visible to users with read access. Default value is `false`.
         * 
         * @return builder
         * 
         */
        public Builder accessBasedEnumeration(Boolean accessBasedEnumeration) {
            return accessBasedEnumeration(Output.of(accessBasedEnumeration));
        }

        /**
         * @param adminUserLists A list of users in the Active Directory that have admin access to the file share. Only valid if `authentication` is set to `ActiveDirectory`.
         * 
         * @return builder
         * 
         */
        public Builder adminUserLists(@Nullable Output<List<String>> adminUserLists) {
            $.adminUserLists = adminUserLists;
            return this;
        }

        /**
         * @param adminUserLists A list of users in the Active Directory that have admin access to the file share. Only valid if `authentication` is set to `ActiveDirectory`.
         * 
         * @return builder
         * 
         */
        public Builder adminUserLists(List<String> adminUserLists) {
            return adminUserLists(Output.of(adminUserLists));
        }

        /**
         * @param adminUserLists A list of users in the Active Directory that have admin access to the file share. Only valid if `authentication` is set to `ActiveDirectory`.
         * 
         * @return builder
         * 
         */
        public Builder adminUserLists(String... adminUserLists) {
            return adminUserLists(List.of(adminUserLists));
        }

        /**
         * @param auditDestinationArn The Amazon Resource Name (ARN) of the CloudWatch Log Group used for the audit logs.
         * 
         * @return builder
         * 
         */
        public Builder auditDestinationArn(@Nullable Output<String> auditDestinationArn) {
            $.auditDestinationArn = auditDestinationArn;
            return this;
        }

        /**
         * @param auditDestinationArn The Amazon Resource Name (ARN) of the CloudWatch Log Group used for the audit logs.
         * 
         * @return builder
         * 
         */
        public Builder auditDestinationArn(String auditDestinationArn) {
            return auditDestinationArn(Output.of(auditDestinationArn));
        }

        /**
         * @param authentication The authentication method that users use to access the file share. Defaults to `ActiveDirectory`. Valid values: `ActiveDirectory`, `GuestAccess`.
         * 
         * @return builder
         * 
         */
        public Builder authentication(@Nullable Output<String> authentication) {
            $.authentication = authentication;
            return this;
        }

        /**
         * @param authentication The authentication method that users use to access the file share. Defaults to `ActiveDirectory`. Valid values: `ActiveDirectory`, `GuestAccess`.
         * 
         * @return builder
         * 
         */
        public Builder authentication(String authentication) {
            return authentication(Output.of(authentication));
        }

        /**
         * @param bucketRegion The region of the S3 buck used by the file share. Required when specifying a `vpc_endpoint_dns_name`.
         * 
         * @return builder
         * 
         */
        public Builder bucketRegion(@Nullable Output<String> bucketRegion) {
            $.bucketRegion = bucketRegion;
            return this;
        }

        /**
         * @param bucketRegion The region of the S3 buck used by the file share. Required when specifying a `vpc_endpoint_dns_name`.
         * 
         * @return builder
         * 
         */
        public Builder bucketRegion(String bucketRegion) {
            return bucketRegion(Output.of(bucketRegion));
        }

        /**
         * @param cacheAttributes Refresh cache information. see Cache Attributes for more details.
         * 
         * @return builder
         * 
         */
        public Builder cacheAttributes(@Nullable Output<SmbFileShareCacheAttributesArgs> cacheAttributes) {
            $.cacheAttributes = cacheAttributes;
            return this;
        }

        /**
         * @param cacheAttributes Refresh cache information. see Cache Attributes for more details.
         * 
         * @return builder
         * 
         */
        public Builder cacheAttributes(SmbFileShareCacheAttributesArgs cacheAttributes) {
            return cacheAttributes(Output.of(cacheAttributes));
        }

        /**
         * @param caseSensitivity The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
         * 
         * @return builder
         * 
         */
        public Builder caseSensitivity(@Nullable Output<String> caseSensitivity) {
            $.caseSensitivity = caseSensitivity;
            return this;
        }

        /**
         * @param caseSensitivity The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
         * 
         * @return builder
         * 
         */
        public Builder caseSensitivity(String caseSensitivity) {
            return caseSensitivity(Output.of(caseSensitivity));
        }

        /**
         * @param defaultStorageClass The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
         * 
         * @return builder
         * 
         */
        public Builder defaultStorageClass(@Nullable Output<String> defaultStorageClass) {
            $.defaultStorageClass = defaultStorageClass;
            return this;
        }

        /**
         * @param defaultStorageClass The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
         * 
         * @return builder
         * 
         */
        public Builder defaultStorageClass(String defaultStorageClass) {
            return defaultStorageClass(Output.of(defaultStorageClass));
        }

        /**
         * @param fileShareName The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
         * 
         * @return builder
         * 
         */
        public Builder fileShareName(@Nullable Output<String> fileShareName) {
            $.fileShareName = fileShareName;
            return this;
        }

        /**
         * @param fileShareName The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
         * 
         * @return builder
         * 
         */
        public Builder fileShareName(String fileShareName) {
            return fileShareName(Output.of(fileShareName));
        }

        /**
         * @param gatewayArn Amazon Resource Name (ARN) of the file gateway.
         * 
         * @return builder
         * 
         */
        public Builder gatewayArn(Output<String> gatewayArn) {
            $.gatewayArn = gatewayArn;
            return this;
        }

        /**
         * @param gatewayArn Amazon Resource Name (ARN) of the file gateway.
         * 
         * @return builder
         * 
         */
        public Builder gatewayArn(String gatewayArn) {
            return gatewayArn(Output.of(gatewayArn));
        }

        /**
         * @param guessMimeTypeEnabled Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
         * 
         * @return builder
         * 
         */
        public Builder guessMimeTypeEnabled(@Nullable Output<Boolean> guessMimeTypeEnabled) {
            $.guessMimeTypeEnabled = guessMimeTypeEnabled;
            return this;
        }

        /**
         * @param guessMimeTypeEnabled Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
         * 
         * @return builder
         * 
         */
        public Builder guessMimeTypeEnabled(Boolean guessMimeTypeEnabled) {
            return guessMimeTypeEnabled(Output.of(guessMimeTypeEnabled));
        }

        /**
         * @param invalidUserLists A list of users in the Active Directory that are not allowed to access the file share. Only valid if `authentication` is set to `ActiveDirectory`.
         * 
         * @return builder
         * 
         */
        public Builder invalidUserLists(@Nullable Output<List<String>> invalidUserLists) {
            $.invalidUserLists = invalidUserLists;
            return this;
        }

        /**
         * @param invalidUserLists A list of users in the Active Directory that are not allowed to access the file share. Only valid if `authentication` is set to `ActiveDirectory`.
         * 
         * @return builder
         * 
         */
        public Builder invalidUserLists(List<String> invalidUserLists) {
            return invalidUserLists(Output.of(invalidUserLists));
        }

        /**
         * @param invalidUserLists A list of users in the Active Directory that are not allowed to access the file share. Only valid if `authentication` is set to `ActiveDirectory`.
         * 
         * @return builder
         * 
         */
        public Builder invalidUserLists(String... invalidUserLists) {
            return invalidUserLists(List.of(invalidUserLists));
        }

        /**
         * @param kmsEncrypted Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder kmsEncrypted(@Nullable Output<Boolean> kmsEncrypted) {
            $.kmsEncrypted = kmsEncrypted;
            return this;
        }

        /**
         * @param kmsEncrypted Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder kmsEncrypted(Boolean kmsEncrypted) {
            return kmsEncrypted(Output.of(kmsEncrypted));
        }

        /**
         * @param kmsKeyArn Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyArn(@Nullable Output<String> kmsKeyArn) {
            $.kmsKeyArn = kmsKeyArn;
            return this;
        }

        /**
         * @param kmsKeyArn Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyArn(String kmsKeyArn) {
            return kmsKeyArn(Output.of(kmsKeyArn));
        }

        /**
         * @param locationArn The ARN of the backed storage used for storing file data.
         * 
         * @return builder
         * 
         */
        public Builder locationArn(Output<String> locationArn) {
            $.locationArn = locationArn;
            return this;
        }

        /**
         * @param locationArn The ARN of the backed storage used for storing file data.
         * 
         * @return builder
         * 
         */
        public Builder locationArn(String locationArn) {
            return locationArn(Output.of(locationArn));
        }

        /**
         * @param notificationPolicy The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
         * 
         * @return builder
         * 
         */
        public Builder notificationPolicy(@Nullable Output<String> notificationPolicy) {
            $.notificationPolicy = notificationPolicy;
            return this;
        }

        /**
         * @param notificationPolicy The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
         * 
         * @return builder
         * 
         */
        public Builder notificationPolicy(String notificationPolicy) {
            return notificationPolicy(Output.of(notificationPolicy));
        }

        /**
         * @param objectAcl Access Control List permission for S3 objects. Defaults to `private`.
         * 
         * @return builder
         * 
         */
        public Builder objectAcl(@Nullable Output<String> objectAcl) {
            $.objectAcl = objectAcl;
            return this;
        }

        /**
         * @param objectAcl Access Control List permission for S3 objects. Defaults to `private`.
         * 
         * @return builder
         * 
         */
        public Builder objectAcl(String objectAcl) {
            return objectAcl(Output.of(objectAcl));
        }

        /**
         * @param oplocksEnabled Boolean to indicate Opportunistic lock (oplock) status. Defaults to `true`.
         * 
         * @return builder
         * 
         */
        public Builder oplocksEnabled(@Nullable Output<Boolean> oplocksEnabled) {
            $.oplocksEnabled = oplocksEnabled;
            return this;
        }

        /**
         * @param oplocksEnabled Boolean to indicate Opportunistic lock (oplock) status. Defaults to `true`.
         * 
         * @return builder
         * 
         */
        public Builder oplocksEnabled(Boolean oplocksEnabled) {
            return oplocksEnabled(Output.of(oplocksEnabled));
        }

        /**
         * @param readOnly Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder readOnly(@Nullable Output<Boolean> readOnly) {
            $.readOnly = readOnly;
            return this;
        }

        /**
         * @param readOnly Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder readOnly(Boolean readOnly) {
            return readOnly(Output.of(readOnly));
        }

        /**
         * @param requesterPays Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder requesterPays(@Nullable Output<Boolean> requesterPays) {
            $.requesterPays = requesterPays;
            return this;
        }

        /**
         * @param requesterPays Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder requesterPays(Boolean requesterPays) {
            return requesterPays(Output.of(requesterPays));
        }

        /**
         * @param roleArn The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
         * 
         * @return builder
         * 
         */
        public Builder roleArn(Output<String> roleArn) {
            $.roleArn = roleArn;
            return this;
        }

        /**
         * @param roleArn The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
         * 
         * @return builder
         * 
         */
        public Builder roleArn(String roleArn) {
            return roleArn(Output.of(roleArn));
        }

        /**
         * @param smbAclEnabled Set this value to `true` to enable ACL (access control list) on the SMB fileshare. Set it to `false` to map file and directory permissions to the POSIX permissions. This setting applies only to `ActiveDirectory` authentication type.
         * 
         * @return builder
         * 
         */
        public Builder smbAclEnabled(@Nullable Output<Boolean> smbAclEnabled) {
            $.smbAclEnabled = smbAclEnabled;
            return this;
        }

        /**
         * @param smbAclEnabled Set this value to `true` to enable ACL (access control list) on the SMB fileshare. Set it to `false` to map file and directory permissions to the POSIX permissions. This setting applies only to `ActiveDirectory` authentication type.
         * 
         * @return builder
         * 
         */
        public Builder smbAclEnabled(Boolean smbAclEnabled) {
            return smbAclEnabled(Output.of(smbAclEnabled));
        }

        /**
         * @param tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param validUserLists A list of users in the Active Directory that are allowed to access the file share. If you need to specify an Active directory group, add &#39;@&#39; before the name of the group. It will be set on Allowed group in AWS console. Only valid if `authentication` is set to `ActiveDirectory`.
         * 
         * @return builder
         * 
         */
        public Builder validUserLists(@Nullable Output<List<String>> validUserLists) {
            $.validUserLists = validUserLists;
            return this;
        }

        /**
         * @param validUserLists A list of users in the Active Directory that are allowed to access the file share. If you need to specify an Active directory group, add &#39;@&#39; before the name of the group. It will be set on Allowed group in AWS console. Only valid if `authentication` is set to `ActiveDirectory`.
         * 
         * @return builder
         * 
         */
        public Builder validUserLists(List<String> validUserLists) {
            return validUserLists(Output.of(validUserLists));
        }

        /**
         * @param validUserLists A list of users in the Active Directory that are allowed to access the file share. If you need to specify an Active directory group, add &#39;@&#39; before the name of the group. It will be set on Allowed group in AWS console. Only valid if `authentication` is set to `ActiveDirectory`.
         * 
         * @return builder
         * 
         */
        public Builder validUserLists(String... validUserLists) {
            return validUserLists(List.of(validUserLists));
        }

        /**
         * @param vpcEndpointDnsName The DNS name of the VPC endpoint for S3 private link.
         * 
         * @return builder
         * 
         */
        public Builder vpcEndpointDnsName(@Nullable Output<String> vpcEndpointDnsName) {
            $.vpcEndpointDnsName = vpcEndpointDnsName;
            return this;
        }

        /**
         * @param vpcEndpointDnsName The DNS name of the VPC endpoint for S3 private link.
         * 
         * @return builder
         * 
         */
        public Builder vpcEndpointDnsName(String vpcEndpointDnsName) {
            return vpcEndpointDnsName(Output.of(vpcEndpointDnsName));
        }

        public SmbFileShareArgs build() {
            $.gatewayArn = Objects.requireNonNull($.gatewayArn, "expected parameter 'gatewayArn' to be non-null");
            $.locationArn = Objects.requireNonNull($.locationArn, "expected parameter 'locationArn' to be non-null");
            $.roleArn = Objects.requireNonNull($.roleArn, "expected parameter 'roleArn' to be non-null");
            return $;
        }
    }

}
