// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.storagegateway;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.storagegateway.SmbFileShareArgs;
import com.pulumi.aws.storagegateway.inputs.SmbFileShareState;
import com.pulumi.aws.storagegateway.outputs.SmbFileShareCacheAttributes;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages an AWS Storage Gateway SMB File Share.
 * 
 * ## Example Usage
 * ### Active Directory Authentication
 * 
 * &gt; **NOTE:** The gateway must have already joined the Active Directory domain prior to SMB file share creationE.g., via &#34;SMB Settings&#34; in the AWS Storage Gateway console or `smb_active_directory_settings` in the `aws.storagegateway.Gateway` resource.
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.SmbFileShare;
 * import com.pulumi.aws.storagegateway.SmbFileShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new SmbFileShare(&#34;example&#34;, SmbFileShareArgs.builder()        
 *             .authentication(&#34;ActiveDirectory&#34;)
 *             .gatewayArn(aws_storagegateway_gateway.example().arn())
 *             .locationArn(aws_s3_bucket.example().arn())
 *             .roleArn(aws_iam_role.example().arn())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Guest Authentication
 * 
 * &gt; **NOTE:** The gateway must have already had the SMB guest password set prior to SMB file share creationE.g., via &#34;SMB Settings&#34; in the AWS Storage Gateway console or `smb_guest_password` in the `aws.storagegateway.Gateway` resource.
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.SmbFileShare;
 * import com.pulumi.aws.storagegateway.SmbFileShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new SmbFileShare(&#34;example&#34;, SmbFileShareArgs.builder()        
 *             .authentication(&#34;GuestAccess&#34;)
 *             .gatewayArn(aws_storagegateway_gateway.example().arn())
 *             .locationArn(aws_s3_bucket.example().arn())
 *             .roleArn(aws_iam_role.example().arn())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_storagegateway_smb_file_share` using the SMB File Share Amazon Resource Name (ARN). For example:
 * 
 * ```sh
 *  $ pulumi import aws:storagegateway/smbFileShare:SmbFileShare example arn:aws:storagegateway:us-east-1:123456789012:share/share-12345678
 * ```
 * 
 */
@ResourceType(type="aws:storagegateway/smbFileShare:SmbFileShare")
public class SmbFileShare extends com.pulumi.resources.CustomResource {
    /**
     * The files and folders on this share will only be visible to users with read access. Default value is `false`.
     * 
     */
    @Export(name="accessBasedEnumeration", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> accessBasedEnumeration;

    /**
     * @return The files and folders on this share will only be visible to users with read access. Default value is `false`.
     * 
     */
    public Output<Optional<Boolean>> accessBasedEnumeration() {
        return Codegen.optional(this.accessBasedEnumeration);
    }
    /**
     * A list of users in the Active Directory that have admin access to the file share. Only valid if `authentication` is set to `ActiveDirectory`.
     * 
     */
    @Export(name="adminUserLists", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> adminUserLists;

    /**
     * @return A list of users in the Active Directory that have admin access to the file share. Only valid if `authentication` is set to `ActiveDirectory`.
     * 
     */
    public Output<Optional<List<String>>> adminUserLists() {
        return Codegen.optional(this.adminUserLists);
    }
    /**
     * Amazon Resource Name (ARN) of the SMB File Share.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the SMB File Share.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The Amazon Resource Name (ARN) of the CloudWatch Log Group used for the audit logs.
     * 
     */
    @Export(name="auditDestinationArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> auditDestinationArn;

    /**
     * @return The Amazon Resource Name (ARN) of the CloudWatch Log Group used for the audit logs.
     * 
     */
    public Output<Optional<String>> auditDestinationArn() {
        return Codegen.optional(this.auditDestinationArn);
    }
    /**
     * The authentication method that users use to access the file share. Defaults to `ActiveDirectory`. Valid values: `ActiveDirectory`, `GuestAccess`.
     * 
     */
    @Export(name="authentication", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> authentication;

    /**
     * @return The authentication method that users use to access the file share. Defaults to `ActiveDirectory`. Valid values: `ActiveDirectory`, `GuestAccess`.
     * 
     */
    public Output<Optional<String>> authentication() {
        return Codegen.optional(this.authentication);
    }
    /**
     * The region of the S3 buck used by the file share. Required when specifying a `vpc_endpoint_dns_name`.
     * 
     */
    @Export(name="bucketRegion", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> bucketRegion;

    /**
     * @return The region of the S3 buck used by the file share. Required when specifying a `vpc_endpoint_dns_name`.
     * 
     */
    public Output<Optional<String>> bucketRegion() {
        return Codegen.optional(this.bucketRegion);
    }
    /**
     * Refresh cache information. see Cache Attributes for more details.
     * 
     */
    @Export(name="cacheAttributes", refs={SmbFileShareCacheAttributes.class}, tree="[0]")
    private Output</* @Nullable */ SmbFileShareCacheAttributes> cacheAttributes;

    /**
     * @return Refresh cache information. see Cache Attributes for more details.
     * 
     */
    public Output<Optional<SmbFileShareCacheAttributes>> cacheAttributes() {
        return Codegen.optional(this.cacheAttributes);
    }
    /**
     * The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
     * 
     */
    @Export(name="caseSensitivity", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> caseSensitivity;

    /**
     * @return The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
     * 
     */
    public Output<Optional<String>> caseSensitivity() {
        return Codegen.optional(this.caseSensitivity);
    }
    /**
     * The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
     * 
     */
    @Export(name="defaultStorageClass", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> defaultStorageClass;

    /**
     * @return The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
     * 
     */
    public Output<Optional<String>> defaultStorageClass() {
        return Codegen.optional(this.defaultStorageClass);
    }
    /**
     * The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
     * 
     */
    @Export(name="fileShareName", refs={String.class}, tree="[0]")
    private Output<String> fileShareName;

    /**
     * @return The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
     * 
     */
    public Output<String> fileShareName() {
        return this.fileShareName;
    }
    /**
     * ID of the SMB File Share.
     * 
     */
    @Export(name="fileshareId", refs={String.class}, tree="[0]")
    private Output<String> fileshareId;

    /**
     * @return ID of the SMB File Share.
     * 
     */
    public Output<String> fileshareId() {
        return this.fileshareId;
    }
    /**
     * Amazon Resource Name (ARN) of the file gateway.
     * 
     */
    @Export(name="gatewayArn", refs={String.class}, tree="[0]")
    private Output<String> gatewayArn;

    /**
     * @return Amazon Resource Name (ARN) of the file gateway.
     * 
     */
    public Output<String> gatewayArn() {
        return this.gatewayArn;
    }
    /**
     * Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
     * 
     */
    @Export(name="guessMimeTypeEnabled", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> guessMimeTypeEnabled;

    /**
     * @return Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
     * 
     */
    public Output<Optional<Boolean>> guessMimeTypeEnabled() {
        return Codegen.optional(this.guessMimeTypeEnabled);
    }
    /**
     * A list of users in the Active Directory that are not allowed to access the file share. Only valid if `authentication` is set to `ActiveDirectory`.
     * 
     */
    @Export(name="invalidUserLists", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> invalidUserLists;

    /**
     * @return A list of users in the Active Directory that are not allowed to access the file share. Only valid if `authentication` is set to `ActiveDirectory`.
     * 
     */
    public Output<Optional<List<String>>> invalidUserLists() {
        return Codegen.optional(this.invalidUserLists);
    }
    /**
     * Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
     * 
     */
    @Export(name="kmsEncrypted", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> kmsEncrypted;

    /**
     * @return Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
     * 
     */
    public Output<Optional<Boolean>> kmsEncrypted() {
        return Codegen.optional(this.kmsEncrypted);
    }
    /**
     * Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
     * 
     */
    @Export(name="kmsKeyArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> kmsKeyArn;

    /**
     * @return Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
     * 
     */
    public Output<Optional<String>> kmsKeyArn() {
        return Codegen.optional(this.kmsKeyArn);
    }
    /**
     * The ARN of the backed storage used for storing file data.
     * 
     */
    @Export(name="locationArn", refs={String.class}, tree="[0]")
    private Output<String> locationArn;

    /**
     * @return The ARN of the backed storage used for storing file data.
     * 
     */
    public Output<String> locationArn() {
        return this.locationArn;
    }
    /**
     * The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
     * 
     */
    @Export(name="notificationPolicy", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> notificationPolicy;

    /**
     * @return The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
     * 
     */
    public Output<Optional<String>> notificationPolicy() {
        return Codegen.optional(this.notificationPolicy);
    }
    /**
     * Access Control List permission for S3 objects. Defaults to `private`.
     * 
     */
    @Export(name="objectAcl", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> objectAcl;

    /**
     * @return Access Control List permission for S3 objects. Defaults to `private`.
     * 
     */
    public Output<Optional<String>> objectAcl() {
        return Codegen.optional(this.objectAcl);
    }
    /**
     * Boolean to indicate Opportunistic lock (oplock) status. Defaults to `true`.
     * 
     */
    @Export(name="oplocksEnabled", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> oplocksEnabled;

    /**
     * @return Boolean to indicate Opportunistic lock (oplock) status. Defaults to `true`.
     * 
     */
    public Output<Boolean> oplocksEnabled() {
        return this.oplocksEnabled;
    }
    /**
     * File share path used by the NFS client to identify the mount point.
     * 
     */
    @Export(name="path", refs={String.class}, tree="[0]")
    private Output<String> path;

    /**
     * @return File share path used by the NFS client to identify the mount point.
     * 
     */
    public Output<String> path() {
        return this.path;
    }
    /**
     * Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
     * 
     */
    @Export(name="readOnly", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> readOnly;

    /**
     * @return Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
     * 
     */
    public Output<Optional<Boolean>> readOnly() {
        return Codegen.optional(this.readOnly);
    }
    /**
     * Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
     * 
     */
    @Export(name="requesterPays", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> requesterPays;

    /**
     * @return Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
     * 
     */
    public Output<Optional<Boolean>> requesterPays() {
        return Codegen.optional(this.requesterPays);
    }
    /**
     * The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
     * 
     */
    @Export(name="roleArn", refs={String.class}, tree="[0]")
    private Output<String> roleArn;

    /**
     * @return The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
     * 
     */
    public Output<String> roleArn() {
        return this.roleArn;
    }
    /**
     * Set this value to `true` to enable ACL (access control list) on the SMB fileshare. Set it to `false` to map file and directory permissions to the POSIX permissions. This setting applies only to `ActiveDirectory` authentication type.
     * 
     */
    @Export(name="smbAclEnabled", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> smbAclEnabled;

    /**
     * @return Set this value to `true` to enable ACL (access control list) on the SMB fileshare. Set it to `false` to map file and directory permissions to the POSIX permissions. This setting applies only to `ActiveDirectory` authentication type.
     * 
     */
    public Output<Optional<Boolean>> smbAclEnabled() {
        return Codegen.optional(this.smbAclEnabled);
    }
    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * A list of users in the Active Directory that are allowed to access the file share. If you need to specify an Active directory group, add &#39;@&#39; before the name of the group. It will be set on Allowed group in AWS console. Only valid if `authentication` is set to `ActiveDirectory`.
     * 
     */
    @Export(name="validUserLists", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> validUserLists;

    /**
     * @return A list of users in the Active Directory that are allowed to access the file share. If you need to specify an Active directory group, add &#39;@&#39; before the name of the group. It will be set on Allowed group in AWS console. Only valid if `authentication` is set to `ActiveDirectory`.
     * 
     */
    public Output<Optional<List<String>>> validUserLists() {
        return Codegen.optional(this.validUserLists);
    }
    /**
     * The DNS name of the VPC endpoint for S3 private link.
     * 
     */
    @Export(name="vpcEndpointDnsName", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> vpcEndpointDnsName;

    /**
     * @return The DNS name of the VPC endpoint for S3 private link.
     * 
     */
    public Output<Optional<String>> vpcEndpointDnsName() {
        return Codegen.optional(this.vpcEndpointDnsName);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public SmbFileShare(String name) {
        this(name, SmbFileShareArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public SmbFileShare(String name, SmbFileShareArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public SmbFileShare(String name, SmbFileShareArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:storagegateway/smbFileShare:SmbFileShare", name, args == null ? SmbFileShareArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private SmbFileShare(String name, Output<String> id, @Nullable SmbFileShareState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:storagegateway/smbFileShare:SmbFileShare", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static SmbFileShare get(String name, Output<String> id, @Nullable SmbFileShareState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new SmbFileShare(name, id, state, options);
    }
}
