// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.storagegateway;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.storagegateway.GatewayArgs;
import com.pulumi.aws.storagegateway.inputs.GatewayState;
import com.pulumi.aws.storagegateway.outputs.GatewayGatewayNetworkInterface;
import com.pulumi.aws.storagegateway.outputs.GatewayMaintenanceStartTime;
import com.pulumi.aws.storagegateway.outputs.GatewaySmbActiveDirectorySettings;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages an AWS Storage Gateway file, tape, or volume gateway in the provider region.
 * 
 * &gt; **NOTE:** The Storage Gateway API requires the gateway to be connected to properly return information after activation. If you are receiving `The specified gateway is not connected` errors during resource creation (gateway activation), ensure your gateway instance meets the [Storage Gateway requirements](https://docs.aws.amazon.com/storagegateway/latest/userguide/Requirements.html).
 * 
 * ## Example Usage
 * ### Local Cache
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VolumeAttachment;
 * import com.pulumi.aws.ec2.VolumeAttachmentArgs;
 * import com.pulumi.aws.storagegateway.StoragegatewayFunctions;
 * import com.pulumi.aws.storagegateway.inputs.GetLocalDiskArgs;
 * import com.pulumi.aws.storagegateway.Cache;
 * import com.pulumi.aws.storagegateway.CacheArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var testVolumeAttachment = new VolumeAttachment(&#34;testVolumeAttachment&#34;, VolumeAttachmentArgs.builder()        
 *             .deviceName(&#34;/dev/xvdb&#34;)
 *             .volumeId(aws_ebs_volume.test().id())
 *             .instanceId(aws_instance.test().id())
 *             .build());
 * 
 *         final var testLocalDisk = StoragegatewayFunctions.getLocalDisk(GetLocalDiskArgs.builder()
 *             .diskNode(testVolumeAttachment.deviceName())
 *             .gatewayArn(aws_storagegateway_gateway.test().arn())
 *             .build());
 * 
 *         var testCache = new Cache(&#34;testCache&#34;, CacheArgs.builder()        
 *             .diskId(testLocalDisk.applyValue(getLocalDiskResult -&gt; getLocalDiskResult).applyValue(testLocalDisk -&gt; testLocalDisk.applyValue(getLocalDiskResult -&gt; getLocalDiskResult.diskId())))
 *             .gatewayArn(aws_storagegateway_gateway.test().arn())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### FSx File Gateway
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.Gateway;
 * import com.pulumi.aws.storagegateway.GatewayArgs;
 * import com.pulumi.aws.storagegateway.inputs.GatewaySmbActiveDirectorySettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Gateway(&#34;example&#34;, GatewayArgs.builder()        
 *             .gatewayIpAddress(&#34;1.2.3.4&#34;)
 *             .gatewayName(&#34;example&#34;)
 *             .gatewayTimezone(&#34;GMT&#34;)
 *             .gatewayType(&#34;FILE_FSX_SMB&#34;)
 *             .smbActiveDirectorySettings(GatewaySmbActiveDirectorySettingsArgs.builder()
 *                 .domainName(&#34;corp.example.com&#34;)
 *                 .password(&#34;avoid-plaintext-passwords&#34;)
 *                 .username(&#34;Admin&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### S3 File Gateway
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.Gateway;
 * import com.pulumi.aws.storagegateway.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Gateway(&#34;example&#34;, GatewayArgs.builder()        
 *             .gatewayIpAddress(&#34;1.2.3.4&#34;)
 *             .gatewayName(&#34;example&#34;)
 *             .gatewayTimezone(&#34;GMT&#34;)
 *             .gatewayType(&#34;FILE_S3&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Tape Gateway
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.Gateway;
 * import com.pulumi.aws.storagegateway.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Gateway(&#34;example&#34;, GatewayArgs.builder()        
 *             .gatewayIpAddress(&#34;1.2.3.4&#34;)
 *             .gatewayName(&#34;example&#34;)
 *             .gatewayTimezone(&#34;GMT&#34;)
 *             .gatewayType(&#34;VTL&#34;)
 *             .mediumChangerType(&#34;AWS-Gateway-VTL&#34;)
 *             .tapeDriveType(&#34;IBM-ULT3580-TD5&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Volume Gateway (Cached)
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.Gateway;
 * import com.pulumi.aws.storagegateway.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Gateway(&#34;example&#34;, GatewayArgs.builder()        
 *             .gatewayIpAddress(&#34;1.2.3.4&#34;)
 *             .gatewayName(&#34;example&#34;)
 *             .gatewayTimezone(&#34;GMT&#34;)
 *             .gatewayType(&#34;CACHED&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Volume Gateway (Stored)
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.Gateway;
 * import com.pulumi.aws.storagegateway.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Gateway(&#34;example&#34;, GatewayArgs.builder()        
 *             .gatewayIpAddress(&#34;1.2.3.4&#34;)
 *             .gatewayName(&#34;example&#34;)
 *             .gatewayTimezone(&#34;GMT&#34;)
 *             .gatewayType(&#34;STORED&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_storagegateway_gateway` using the gateway Amazon Resource Name (ARN). For example:
 * 
 * ```sh
 *  $ pulumi import aws:storagegateway/gateway:Gateway example arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678
 * ```
 *  Certain resource arguments, like `gateway_ip_address` do not have a Storage Gateway API method for reading the information after creation, either omit the argument from the TODO configuration or use `ignore_changes` to hide the difference. For example:
 * 
 */
@ResourceType(type="aws:storagegateway/gateway:Gateway")
public class Gateway extends com.pulumi.resources.CustomResource {
    /**
     * Gateway activation key during resource creation. Conflicts with `gateway_ip_address`. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
     * 
     */
    @Export(name="activationKey", refs={String.class}, tree="[0]")
    private Output<String> activationKey;

    /**
     * @return Gateway activation key during resource creation. Conflicts with `gateway_ip_address`. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
     * 
     */
    public Output<String> activationKey() {
        return this.activationKey;
    }
    /**
     * Amazon Resource Name (ARN) of the gateway.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the gateway.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The average download bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
     * 
     */
    @Export(name="averageDownloadRateLimitInBitsPerSec", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> averageDownloadRateLimitInBitsPerSec;

    /**
     * @return The average download bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
     * 
     */
    public Output<Optional<Integer>> averageDownloadRateLimitInBitsPerSec() {
        return Codegen.optional(this.averageDownloadRateLimitInBitsPerSec);
    }
    /**
     * The average upload bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
     * 
     */
    @Export(name="averageUploadRateLimitInBitsPerSec", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> averageUploadRateLimitInBitsPerSec;

    /**
     * @return The average upload bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
     * 
     */
    public Output<Optional<Integer>> averageUploadRateLimitInBitsPerSec() {
        return Codegen.optional(this.averageUploadRateLimitInBitsPerSec);
    }
    /**
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group to use to monitor and log events in the gateway.
     * 
     */
    @Export(name="cloudwatchLogGroupArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> cloudwatchLogGroupArn;

    /**
     * @return The Amazon Resource Name (ARN) of the Amazon CloudWatch log group to use to monitor and log events in the gateway.
     * 
     */
    public Output<Optional<String>> cloudwatchLogGroupArn() {
        return Codegen.optional(this.cloudwatchLogGroupArn);
    }
    /**
     * The ID of the Amazon EC2 instance that was used to launch the gateway.
     * 
     */
    @Export(name="ec2InstanceId", refs={String.class}, tree="[0]")
    private Output<String> ec2InstanceId;

    /**
     * @return The ID of the Amazon EC2 instance that was used to launch the gateway.
     * 
     */
    public Output<String> ec2InstanceId() {
        return this.ec2InstanceId;
    }
    /**
     * The type of endpoint for your gateway.
     * 
     */
    @Export(name="endpointType", refs={String.class}, tree="[0]")
    private Output<String> endpointType;

    /**
     * @return The type of endpoint for your gateway.
     * 
     */
    public Output<String> endpointType() {
        return this.endpointType;
    }
    /**
     * Identifier of the gateway.
     * 
     */
    @Export(name="gatewayId", refs={String.class}, tree="[0]")
    private Output<String> gatewayId;

    /**
     * @return Identifier of the gateway.
     * 
     */
    public Output<String> gatewayId() {
        return this.gatewayId;
    }
    /**
     * Gateway IP address to retrieve activation key during resource creation. Conflicts with `activation_key`. Gateway must be accessible on port 80 from where this provider is running. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
     * 
     */
    @Export(name="gatewayIpAddress", refs={String.class}, tree="[0]")
    private Output<String> gatewayIpAddress;

    /**
     * @return Gateway IP address to retrieve activation key during resource creation. Conflicts with `activation_key`. Gateway must be accessible on port 80 from where this provider is running. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
     * 
     */
    public Output<String> gatewayIpAddress() {
        return this.gatewayIpAddress;
    }
    /**
     * Name of the gateway.
     * 
     */
    @Export(name="gatewayName", refs={String.class}, tree="[0]")
    private Output<String> gatewayName;

    /**
     * @return Name of the gateway.
     * 
     */
    public Output<String> gatewayName() {
        return this.gatewayName;
    }
    /**
     * An array that contains descriptions of the gateway network interfaces. See Gateway Network Interface.
     * 
     */
    @Export(name="gatewayNetworkInterfaces", refs={List.class,GatewayGatewayNetworkInterface.class}, tree="[0,1]")
    private Output<List<GatewayGatewayNetworkInterface>> gatewayNetworkInterfaces;

    /**
     * @return An array that contains descriptions of the gateway network interfaces. See Gateway Network Interface.
     * 
     */
    public Output<List<GatewayGatewayNetworkInterface>> gatewayNetworkInterfaces() {
        return this.gatewayNetworkInterfaces;
    }
    /**
     * Time zone for the gateway. The time zone is of the format &#34;GMT&#34;, &#34;GMT-hr:mm&#34;, or &#34;GMT+hr:mm&#34;. For example, `GMT-4:00` indicates the time is 4 hours behind GMT. The time zone is used, for example, for scheduling snapshots and your gateway&#39;s maintenance schedule.
     * 
     */
    @Export(name="gatewayTimezone", refs={String.class}, tree="[0]")
    private Output<String> gatewayTimezone;

    /**
     * @return Time zone for the gateway. The time zone is of the format &#34;GMT&#34;, &#34;GMT-hr:mm&#34;, or &#34;GMT+hr:mm&#34;. For example, `GMT-4:00` indicates the time is 4 hours behind GMT. The time zone is used, for example, for scheduling snapshots and your gateway&#39;s maintenance schedule.
     * 
     */
    public Output<String> gatewayTimezone() {
        return this.gatewayTimezone;
    }
    /**
     * Type of the gateway. The default value is `STORED`. Valid values: `CACHED`, `FILE_FSX_SMB`, `FILE_S3`, `STORED`, `VTL`.
     * 
     */
    @Export(name="gatewayType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> gatewayType;

    /**
     * @return Type of the gateway. The default value is `STORED`. Valid values: `CACHED`, `FILE_FSX_SMB`, `FILE_S3`, `STORED`, `VTL`.
     * 
     */
    public Output<Optional<String>> gatewayType() {
        return Codegen.optional(this.gatewayType);
    }
    /**
     * VPC endpoint address to be used when activating your gateway. This should be used when your instance is in a private subnet. Requires HTTP access from client computer running this provider. More info on what ports are required by your VPC Endpoint Security group in [Activating a Gateway in a Virtual Private Cloud](https://docs.aws.amazon.com/storagegateway/latest/userguide/gateway-private-link.html).
     * 
     */
    @Export(name="gatewayVpcEndpoint", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> gatewayVpcEndpoint;

    /**
     * @return VPC endpoint address to be used when activating your gateway. This should be used when your instance is in a private subnet. Requires HTTP access from client computer running this provider. More info on what ports are required by your VPC Endpoint Security group in [Activating a Gateway in a Virtual Private Cloud](https://docs.aws.amazon.com/storagegateway/latest/userguide/gateway-private-link.html).
     * 
     */
    public Output<Optional<String>> gatewayVpcEndpoint() {
        return Codegen.optional(this.gatewayVpcEndpoint);
    }
    /**
     * The type of hypervisor environment used by the host.
     * 
     */
    @Export(name="hostEnvironment", refs={String.class}, tree="[0]")
    private Output<String> hostEnvironment;

    /**
     * @return The type of hypervisor environment used by the host.
     * 
     */
    public Output<String> hostEnvironment() {
        return this.hostEnvironment;
    }
    /**
     * The gateway&#39;s weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway&#39;s time zone. More details below.
     * 
     */
    @Export(name="maintenanceStartTime", refs={GatewayMaintenanceStartTime.class}, tree="[0]")
    private Output<GatewayMaintenanceStartTime> maintenanceStartTime;

    /**
     * @return The gateway&#39;s weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway&#39;s time zone. More details below.
     * 
     */
    public Output<GatewayMaintenanceStartTime> maintenanceStartTime() {
        return this.maintenanceStartTime;
    }
    /**
     * Type of medium changer to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `STK-L700`, `AWS-Gateway-VTL`, `IBM-03584L32-0402`.
     * 
     */
    @Export(name="mediumChangerType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> mediumChangerType;

    /**
     * @return Type of medium changer to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `STK-L700`, `AWS-Gateway-VTL`, `IBM-03584L32-0402`.
     * 
     */
    public Output<Optional<String>> mediumChangerType() {
        return Codegen.optional(this.mediumChangerType);
    }
    /**
     * Nested argument with Active Directory domain join information for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `ActiveDirectory` authentication SMB file shares. More details below.
     * 
     */
    @Export(name="smbActiveDirectorySettings", refs={GatewaySmbActiveDirectorySettings.class}, tree="[0]")
    private Output</* @Nullable */ GatewaySmbActiveDirectorySettings> smbActiveDirectorySettings;

    /**
     * @return Nested argument with Active Directory domain join information for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `ActiveDirectory` authentication SMB file shares. More details below.
     * 
     */
    public Output<Optional<GatewaySmbActiveDirectorySettings>> smbActiveDirectorySettings() {
        return Codegen.optional(this.smbActiveDirectorySettings);
    }
    /**
     * Specifies whether the shares on this gateway appear when listing shares.
     * 
     */
    @Export(name="smbFileShareVisibility", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> smbFileShareVisibility;

    /**
     * @return Specifies whether the shares on this gateway appear when listing shares.
     * 
     */
    public Output<Optional<Boolean>> smbFileShareVisibility() {
        return Codegen.optional(this.smbFileShareVisibility);
    }
    /**
     * Guest password for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `GuestAccess` authentication SMB file shares. This provider can only detect drift of the existence of a guest password, not its actual value from the gateway. This provider can however update the password with changing the argument.
     * 
     */
    @Export(name="smbGuestPassword", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> smbGuestPassword;

    /**
     * @return Guest password for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `GuestAccess` authentication SMB file shares. This provider can only detect drift of the existence of a guest password, not its actual value from the gateway. This provider can however update the password with changing the argument.
     * 
     */
    public Output<Optional<String>> smbGuestPassword() {
        return Codegen.optional(this.smbGuestPassword);
    }
    /**
     * Specifies the type of security strategy. Valid values are: `ClientSpecified`, `MandatorySigning`, and `MandatoryEncryption`. See [Setting a Security Level for Your Gateway](https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-gateway-file.html#security-strategy) for more information.
     * 
     */
    @Export(name="smbSecurityStrategy", refs={String.class}, tree="[0]")
    private Output<String> smbSecurityStrategy;

    /**
     * @return Specifies the type of security strategy. Valid values are: `ClientSpecified`, `MandatorySigning`, and `MandatoryEncryption`. See [Setting a Security Level for Your Gateway](https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-gateway-file.html#security-strategy) for more information.
     * 
     */
    public Output<String> smbSecurityStrategy() {
        return this.smbSecurityStrategy;
    }
    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * Type of tape drive to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `IBM-ULT3580-TD5`.
     * 
     */
    @Export(name="tapeDriveType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> tapeDriveType;

    /**
     * @return Type of tape drive to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `IBM-ULT3580-TD5`.
     * 
     */
    public Output<Optional<String>> tapeDriveType() {
        return Codegen.optional(this.tapeDriveType);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Gateway(String name) {
        this(name, GatewayArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Gateway(String name, GatewayArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Gateway(String name, GatewayArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:storagegateway/gateway:Gateway", name, args == null ? GatewayArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Gateway(String name, Output<String> id, @Nullable GatewayState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:storagegateway/gateway:Gateway", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .additionalSecretOutputs(List.of(
                "smbGuestPassword"
            ))
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Gateway get(String name, Output<String> id, @Nullable GatewayState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Gateway(name, id, state, options);
    }
}
