// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.storagegateway;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class CachesIscsiVolumeArgs extends com.pulumi.resources.ResourceArgs {

    public static final CachesIscsiVolumeArgs Empty = new CachesIscsiVolumeArgs();

    /**
     * The Amazon Resource Name (ARN) of the gateway.
     * 
     */
    @Import(name="gatewayArn", required=true)
    private Output<String> gatewayArn;

    /**
     * @return The Amazon Resource Name (ARN) of the gateway.
     * 
     */
    public Output<String> gatewayArn() {
        return this.gatewayArn;
    }

    /**
     * Set to `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3.
     * 
     */
    @Import(name="kmsEncrypted")
    private @Nullable Output<Boolean> kmsEncrypted;

    /**
     * @return Set to `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3.
     * 
     */
    public Optional<Output<Boolean>> kmsEncrypted() {
        return Optional.ofNullable(this.kmsEncrypted);
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. Is required when `kms_encrypted` is set.
     * 
     */
    @Import(name="kmsKey")
    private @Nullable Output<String> kmsKey;

    /**
     * @return The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. Is required when `kms_encrypted` is set.
     * 
     */
    public Optional<Output<String>> kmsKey() {
        return Optional.ofNullable(this.kmsKey);
    }

    /**
     * The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
     * 
     */
    @Import(name="networkInterfaceId", required=true)
    private Output<String> networkInterfaceId;

    /**
     * @return The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
     * 
     */
    public Output<String> networkInterfaceId() {
        return this.networkInterfaceId;
    }

    /**
     * The snapshot ID of the snapshot to restore as the new cached volumeE.g., `snap-1122aabb`.
     * 
     */
    @Import(name="snapshotId")
    private @Nullable Output<String> snapshotId;

    /**
     * @return The snapshot ID of the snapshot to restore as the new cached volumeE.g., `snap-1122aabb`.
     * 
     */
    public Optional<Output<String>> snapshotId() {
        return Optional.ofNullable(this.snapshotId);
    }

    /**
     * The ARN for an existing volume. Specifying this ARN makes the new volume into an exact copy of the specified existing volume&#39;s latest recovery point. The `volume_size_in_bytes` value for this new volume must be equal to or larger than the size of the existing volume, in bytes.
     * 
     */
    @Import(name="sourceVolumeArn")
    private @Nullable Output<String> sourceVolumeArn;

    /**
     * @return The ARN for an existing volume. Specifying this ARN makes the new volume into an exact copy of the specified existing volume&#39;s latest recovery point. The `volume_size_in_bytes` value for this new volume must be equal to or larger than the size of the existing volume, in bytes.
     * 
     */
    public Optional<Output<String>> sourceVolumeArn() {
        return Optional.ofNullable(this.sourceVolumeArn);
    }

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * The name of the iSCSI target used by initiators to connect to the target and as a suffix for the target ARN. The target name must be unique across all volumes of a gateway.
     * 
     */
    @Import(name="targetName", required=true)
    private Output<String> targetName;

    /**
     * @return The name of the iSCSI target used by initiators to connect to the target and as a suffix for the target ARN. The target name must be unique across all volumes of a gateway.
     * 
     */
    public Output<String> targetName() {
        return this.targetName;
    }

    /**
     * The size of the volume in bytes.
     * 
     */
    @Import(name="volumeSizeInBytes", required=true)
    private Output<Integer> volumeSizeInBytes;

    /**
     * @return The size of the volume in bytes.
     * 
     */
    public Output<Integer> volumeSizeInBytes() {
        return this.volumeSizeInBytes;
    }

    private CachesIscsiVolumeArgs() {}

    private CachesIscsiVolumeArgs(CachesIscsiVolumeArgs $) {
        this.gatewayArn = $.gatewayArn;
        this.kmsEncrypted = $.kmsEncrypted;
        this.kmsKey = $.kmsKey;
        this.networkInterfaceId = $.networkInterfaceId;
        this.snapshotId = $.snapshotId;
        this.sourceVolumeArn = $.sourceVolumeArn;
        this.tags = $.tags;
        this.targetName = $.targetName;
        this.volumeSizeInBytes = $.volumeSizeInBytes;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(CachesIscsiVolumeArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private CachesIscsiVolumeArgs $;

        public Builder() {
            $ = new CachesIscsiVolumeArgs();
        }

        public Builder(CachesIscsiVolumeArgs defaults) {
            $ = new CachesIscsiVolumeArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param gatewayArn The Amazon Resource Name (ARN) of the gateway.
         * 
         * @return builder
         * 
         */
        public Builder gatewayArn(Output<String> gatewayArn) {
            $.gatewayArn = gatewayArn;
            return this;
        }

        /**
         * @param gatewayArn The Amazon Resource Name (ARN) of the gateway.
         * 
         * @return builder
         * 
         */
        public Builder gatewayArn(String gatewayArn) {
            return gatewayArn(Output.of(gatewayArn));
        }

        /**
         * @param kmsEncrypted Set to `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3.
         * 
         * @return builder
         * 
         */
        public Builder kmsEncrypted(@Nullable Output<Boolean> kmsEncrypted) {
            $.kmsEncrypted = kmsEncrypted;
            return this;
        }

        /**
         * @param kmsEncrypted Set to `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3.
         * 
         * @return builder
         * 
         */
        public Builder kmsEncrypted(Boolean kmsEncrypted) {
            return kmsEncrypted(Output.of(kmsEncrypted));
        }

        /**
         * @param kmsKey The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. Is required when `kms_encrypted` is set.
         * 
         * @return builder
         * 
         */
        public Builder kmsKey(@Nullable Output<String> kmsKey) {
            $.kmsKey = kmsKey;
            return this;
        }

        /**
         * @param kmsKey The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. Is required when `kms_encrypted` is set.
         * 
         * @return builder
         * 
         */
        public Builder kmsKey(String kmsKey) {
            return kmsKey(Output.of(kmsKey));
        }

        /**
         * @param networkInterfaceId The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
         * 
         * @return builder
         * 
         */
        public Builder networkInterfaceId(Output<String> networkInterfaceId) {
            $.networkInterfaceId = networkInterfaceId;
            return this;
        }

        /**
         * @param networkInterfaceId The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
         * 
         * @return builder
         * 
         */
        public Builder networkInterfaceId(String networkInterfaceId) {
            return networkInterfaceId(Output.of(networkInterfaceId));
        }

        /**
         * @param snapshotId The snapshot ID of the snapshot to restore as the new cached volumeE.g., `snap-1122aabb`.
         * 
         * @return builder
         * 
         */
        public Builder snapshotId(@Nullable Output<String> snapshotId) {
            $.snapshotId = snapshotId;
            return this;
        }

        /**
         * @param snapshotId The snapshot ID of the snapshot to restore as the new cached volumeE.g., `snap-1122aabb`.
         * 
         * @return builder
         * 
         */
        public Builder snapshotId(String snapshotId) {
            return snapshotId(Output.of(snapshotId));
        }

        /**
         * @param sourceVolumeArn The ARN for an existing volume. Specifying this ARN makes the new volume into an exact copy of the specified existing volume&#39;s latest recovery point. The `volume_size_in_bytes` value for this new volume must be equal to or larger than the size of the existing volume, in bytes.
         * 
         * @return builder
         * 
         */
        public Builder sourceVolumeArn(@Nullable Output<String> sourceVolumeArn) {
            $.sourceVolumeArn = sourceVolumeArn;
            return this;
        }

        /**
         * @param sourceVolumeArn The ARN for an existing volume. Specifying this ARN makes the new volume into an exact copy of the specified existing volume&#39;s latest recovery point. The `volume_size_in_bytes` value for this new volume must be equal to or larger than the size of the existing volume, in bytes.
         * 
         * @return builder
         * 
         */
        public Builder sourceVolumeArn(String sourceVolumeArn) {
            return sourceVolumeArn(Output.of(sourceVolumeArn));
        }

        /**
         * @param tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param targetName The name of the iSCSI target used by initiators to connect to the target and as a suffix for the target ARN. The target name must be unique across all volumes of a gateway.
         * 
         * @return builder
         * 
         */
        public Builder targetName(Output<String> targetName) {
            $.targetName = targetName;
            return this;
        }

        /**
         * @param targetName The name of the iSCSI target used by initiators to connect to the target and as a suffix for the target ARN. The target name must be unique across all volumes of a gateway.
         * 
         * @return builder
         * 
         */
        public Builder targetName(String targetName) {
            return targetName(Output.of(targetName));
        }

        /**
         * @param volumeSizeInBytes The size of the volume in bytes.
         * 
         * @return builder
         * 
         */
        public Builder volumeSizeInBytes(Output<Integer> volumeSizeInBytes) {
            $.volumeSizeInBytes = volumeSizeInBytes;
            return this;
        }

        /**
         * @param volumeSizeInBytes The size of the volume in bytes.
         * 
         * @return builder
         * 
         */
        public Builder volumeSizeInBytes(Integer volumeSizeInBytes) {
            return volumeSizeInBytes(Output.of(volumeSizeInBytes));
        }

        public CachesIscsiVolumeArgs build() {
            $.gatewayArn = Objects.requireNonNull($.gatewayArn, "expected parameter 'gatewayArn' to be non-null");
            $.networkInterfaceId = Objects.requireNonNull($.networkInterfaceId, "expected parameter 'networkInterfaceId' to be non-null");
            $.targetName = Objects.requireNonNull($.targetName, "expected parameter 'targetName' to be non-null");
            $.volumeSizeInBytes = Objects.requireNonNull($.volumeSizeInBytes, "expected parameter 'volumeSizeInBytes' to be non-null");
            return $;
        }
    }

}
