// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ssoadmin;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class AccountAssignmentArgs extends com.pulumi.resources.ResourceArgs {

    public static final AccountAssignmentArgs Empty = new AccountAssignmentArgs();

    /**
     * The Amazon Resource Name (ARN) of the SSO Instance.
     * 
     */
    @Import(name="instanceArn", required=true)
    private Output<String> instanceArn;

    /**
     * @return The Amazon Resource Name (ARN) of the SSO Instance.
     * 
     */
    public Output<String> instanceArn() {
        return this.instanceArn;
    }

    /**
     * The Amazon Resource Name (ARN) of the Permission Set that the admin wants to grant the principal access to.
     * 
     */
    @Import(name="permissionSetArn", required=true)
    private Output<String> permissionSetArn;

    /**
     * @return The Amazon Resource Name (ARN) of the Permission Set that the admin wants to grant the principal access to.
     * 
     */
    public Output<String> permissionSetArn() {
        return this.permissionSetArn;
    }

    /**
     * An identifier for an object in SSO, such as a user or group. PrincipalIds are GUIDs (For example, `f81d4fae-7dec-11d0-a765-00a0c91e6bf6`).
     * 
     */
    @Import(name="principalId", required=true)
    private Output<String> principalId;

    /**
     * @return An identifier for an object in SSO, such as a user or group. PrincipalIds are GUIDs (For example, `f81d4fae-7dec-11d0-a765-00a0c91e6bf6`).
     * 
     */
    public Output<String> principalId() {
        return this.principalId;
    }

    /**
     * The entity type for which the assignment will be created. Valid values: `USER`, `GROUP`.
     * 
     */
    @Import(name="principalType", required=true)
    private Output<String> principalType;

    /**
     * @return The entity type for which the assignment will be created. Valid values: `USER`, `GROUP`.
     * 
     */
    public Output<String> principalType() {
        return this.principalType;
    }

    /**
     * An AWS account identifier, typically a 10-12 digit string.
     * 
     */
    @Import(name="targetId", required=true)
    private Output<String> targetId;

    /**
     * @return An AWS account identifier, typically a 10-12 digit string.
     * 
     */
    public Output<String> targetId() {
        return this.targetId;
    }

    /**
     * The entity type for which the assignment will be created. Valid values: `AWS_ACCOUNT`.
     * 
     */
    @Import(name="targetType")
    private @Nullable Output<String> targetType;

    /**
     * @return The entity type for which the assignment will be created. Valid values: `AWS_ACCOUNT`.
     * 
     */
    public Optional<Output<String>> targetType() {
        return Optional.ofNullable(this.targetType);
    }

    private AccountAssignmentArgs() {}

    private AccountAssignmentArgs(AccountAssignmentArgs $) {
        this.instanceArn = $.instanceArn;
        this.permissionSetArn = $.permissionSetArn;
        this.principalId = $.principalId;
        this.principalType = $.principalType;
        this.targetId = $.targetId;
        this.targetType = $.targetType;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(AccountAssignmentArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private AccountAssignmentArgs $;

        public Builder() {
            $ = new AccountAssignmentArgs();
        }

        public Builder(AccountAssignmentArgs defaults) {
            $ = new AccountAssignmentArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param instanceArn The Amazon Resource Name (ARN) of the SSO Instance.
         * 
         * @return builder
         * 
         */
        public Builder instanceArn(Output<String> instanceArn) {
            $.instanceArn = instanceArn;
            return this;
        }

        /**
         * @param instanceArn The Amazon Resource Name (ARN) of the SSO Instance.
         * 
         * @return builder
         * 
         */
        public Builder instanceArn(String instanceArn) {
            return instanceArn(Output.of(instanceArn));
        }

        /**
         * @param permissionSetArn The Amazon Resource Name (ARN) of the Permission Set that the admin wants to grant the principal access to.
         * 
         * @return builder
         * 
         */
        public Builder permissionSetArn(Output<String> permissionSetArn) {
            $.permissionSetArn = permissionSetArn;
            return this;
        }

        /**
         * @param permissionSetArn The Amazon Resource Name (ARN) of the Permission Set that the admin wants to grant the principal access to.
         * 
         * @return builder
         * 
         */
        public Builder permissionSetArn(String permissionSetArn) {
            return permissionSetArn(Output.of(permissionSetArn));
        }

        /**
         * @param principalId An identifier for an object in SSO, such as a user or group. PrincipalIds are GUIDs (For example, `f81d4fae-7dec-11d0-a765-00a0c91e6bf6`).
         * 
         * @return builder
         * 
         */
        public Builder principalId(Output<String> principalId) {
            $.principalId = principalId;
            return this;
        }

        /**
         * @param principalId An identifier for an object in SSO, such as a user or group. PrincipalIds are GUIDs (For example, `f81d4fae-7dec-11d0-a765-00a0c91e6bf6`).
         * 
         * @return builder
         * 
         */
        public Builder principalId(String principalId) {
            return principalId(Output.of(principalId));
        }

        /**
         * @param principalType The entity type for which the assignment will be created. Valid values: `USER`, `GROUP`.
         * 
         * @return builder
         * 
         */
        public Builder principalType(Output<String> principalType) {
            $.principalType = principalType;
            return this;
        }

        /**
         * @param principalType The entity type for which the assignment will be created. Valid values: `USER`, `GROUP`.
         * 
         * @return builder
         * 
         */
        public Builder principalType(String principalType) {
            return principalType(Output.of(principalType));
        }

        /**
         * @param targetId An AWS account identifier, typically a 10-12 digit string.
         * 
         * @return builder
         * 
         */
        public Builder targetId(Output<String> targetId) {
            $.targetId = targetId;
            return this;
        }

        /**
         * @param targetId An AWS account identifier, typically a 10-12 digit string.
         * 
         * @return builder
         * 
         */
        public Builder targetId(String targetId) {
            return targetId(Output.of(targetId));
        }

        /**
         * @param targetType The entity type for which the assignment will be created. Valid values: `AWS_ACCOUNT`.
         * 
         * @return builder
         * 
         */
        public Builder targetType(@Nullable Output<String> targetType) {
            $.targetType = targetType;
            return this;
        }

        /**
         * @param targetType The entity type for which the assignment will be created. Valid values: `AWS_ACCOUNT`.
         * 
         * @return builder
         * 
         */
        public Builder targetType(String targetType) {
            return targetType(Output.of(targetType));
        }

        public AccountAssignmentArgs build() {
            $.instanceArn = Objects.requireNonNull($.instanceArn, "expected parameter 'instanceArn' to be non-null");
            $.permissionSetArn = Objects.requireNonNull($.permissionSetArn, "expected parameter 'permissionSetArn' to be non-null");
            $.principalId = Objects.requireNonNull($.principalId, "expected parameter 'principalId' to be non-null");
            $.principalType = Objects.requireNonNull($.principalType, "expected parameter 'principalType' to be non-null");
            $.targetId = Objects.requireNonNull($.targetId, "expected parameter 'targetId' to be non-null");
            return $;
        }
    }

}
