// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ssmcontacts;

import com.pulumi.aws.ssmcontacts.inputs.ContactChannelDeliveryAddressArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ContactChannelArgs extends com.pulumi.resources.ResourceArgs {

    public static final ContactChannelArgs Empty = new ContactChannelArgs();

    /**
     * Amazon Resource Name (ARN) of the AWS SSM Contact that the contact channel belongs to.
     * 
     */
    @Import(name="contactId", required=true)
    private Output<String> contactId;

    /**
     * @return Amazon Resource Name (ARN) of the AWS SSM Contact that the contact channel belongs to.
     * 
     */
    public Output<String> contactId() {
        return this.contactId;
    }

    /**
     * Block that contains contact engagement details. See details below.
     * 
     */
    @Import(name="deliveryAddress", required=true)
    private Output<ContactChannelDeliveryAddressArgs> deliveryAddress;

    /**
     * @return Block that contains contact engagement details. See details below.
     * 
     */
    public Output<ContactChannelDeliveryAddressArgs> deliveryAddress() {
        return this.deliveryAddress;
    }

    /**
     * Name of the contact channel. Must be between 1 and 255 characters, and may contain alphanumerics, underscores (`_`), hyphens (`-`), periods (`.`), and spaces.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Name of the contact channel. Must be between 1 and 255 characters, and may contain alphanumerics, underscores (`_`), hyphens (`-`), periods (`.`), and spaces.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * Type of the contact channel. One of `SMS`, `VOICE` or `EMAIL`.
     * 
     */
    @Import(name="type", required=true)
    private Output<String> type;

    /**
     * @return Type of the contact channel. One of `SMS`, `VOICE` or `EMAIL`.
     * 
     */
    public Output<String> type() {
        return this.type;
    }

    private ContactChannelArgs() {}

    private ContactChannelArgs(ContactChannelArgs $) {
        this.contactId = $.contactId;
        this.deliveryAddress = $.deliveryAddress;
        this.name = $.name;
        this.type = $.type;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ContactChannelArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ContactChannelArgs $;

        public Builder() {
            $ = new ContactChannelArgs();
        }

        public Builder(ContactChannelArgs defaults) {
            $ = new ContactChannelArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param contactId Amazon Resource Name (ARN) of the AWS SSM Contact that the contact channel belongs to.
         * 
         * @return builder
         * 
         */
        public Builder contactId(Output<String> contactId) {
            $.contactId = contactId;
            return this;
        }

        /**
         * @param contactId Amazon Resource Name (ARN) of the AWS SSM Contact that the contact channel belongs to.
         * 
         * @return builder
         * 
         */
        public Builder contactId(String contactId) {
            return contactId(Output.of(contactId));
        }

        /**
         * @param deliveryAddress Block that contains contact engagement details. See details below.
         * 
         * @return builder
         * 
         */
        public Builder deliveryAddress(Output<ContactChannelDeliveryAddressArgs> deliveryAddress) {
            $.deliveryAddress = deliveryAddress;
            return this;
        }

        /**
         * @param deliveryAddress Block that contains contact engagement details. See details below.
         * 
         * @return builder
         * 
         */
        public Builder deliveryAddress(ContactChannelDeliveryAddressArgs deliveryAddress) {
            return deliveryAddress(Output.of(deliveryAddress));
        }

        /**
         * @param name Name of the contact channel. Must be between 1 and 255 characters, and may contain alphanumerics, underscores (`_`), hyphens (`-`), periods (`.`), and spaces.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Name of the contact channel. Must be between 1 and 255 characters, and may contain alphanumerics, underscores (`_`), hyphens (`-`), periods (`.`), and spaces.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param type Type of the contact channel. One of `SMS`, `VOICE` or `EMAIL`.
         * 
         * @return builder
         * 
         */
        public Builder type(Output<String> type) {
            $.type = type;
            return this;
        }

        /**
         * @param type Type of the contact channel. One of `SMS`, `VOICE` or `EMAIL`.
         * 
         * @return builder
         * 
         */
        public Builder type(String type) {
            return type(Output.of(type));
        }

        public ContactChannelArgs build() {
            $.contactId = Objects.requireNonNull($.contactId, "expected parameter 'contactId' to be non-null");
            $.deliveryAddress = Objects.requireNonNull($.deliveryAddress, "expected parameter 'deliveryAddress' to be non-null");
            $.type = Objects.requireNonNull($.type, "expected parameter 'type' to be non-null");
            return $;
        }
    }

}
