// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ssm;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ssm.ServiceSettingArgs;
import com.pulumi.aws.ssm.inputs.ServiceSettingState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * This setting defines how a user interacts with or uses a service or a feature of a service.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.ServiceSetting;
 * import com.pulumi.aws.ssm.ServiceSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var testSetting = new ServiceSetting(&#34;testSetting&#34;, ServiceSettingArgs.builder()        
 *             .settingId(&#34;arn:aws:ssm:us-east-1:123456789012:servicesetting/ssm/parameter-store/high-throughput-enabled&#34;)
 *             .settingValue(&#34;true&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import AWS SSM Service Setting using the `setting_id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ssm/serviceSetting:ServiceSetting example arn:aws:ssm:us-east-1:123456789012:servicesetting/ssm/parameter-store/high-throughput-enabled
 * ```
 * 
 */
@ResourceType(type="aws:ssm/serviceSetting:ServiceSetting")
public class ServiceSetting extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the service setting.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the service setting.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * ID of the service setting.
     * 
     */
    @Export(name="settingId", refs={String.class}, tree="[0]")
    private Output<String> settingId;

    /**
     * @return ID of the service setting.
     * 
     */
    public Output<String> settingId() {
        return this.settingId;
    }
    /**
     * Value of the service setting.
     * 
     */
    @Export(name="settingValue", refs={String.class}, tree="[0]")
    private Output<String> settingValue;

    /**
     * @return Value of the service setting.
     * 
     */
    public Output<String> settingValue() {
        return this.settingValue;
    }
    /**
     * Status of the service setting. Value can be `Default`, `Customized` or `PendingUpdate`.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output<String> status;

    /**
     * @return Status of the service setting. Value can be `Default`, `Customized` or `PendingUpdate`.
     * 
     */
    public Output<String> status() {
        return this.status;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ServiceSetting(String name) {
        this(name, ServiceSettingArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ServiceSetting(String name, ServiceSettingArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ServiceSetting(String name, ServiceSettingArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ssm/serviceSetting:ServiceSetting", name, args == null ? ServiceSettingArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ServiceSetting(String name, Output<String> id, @Nullable ServiceSettingState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ssm/serviceSetting:ServiceSetting", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ServiceSetting get(String name, Output<String> id, @Nullable ServiceSettingState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ServiceSetting(name, id, state, options);
    }
}
