// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ssm;

import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTargetArgs;
import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class MaintenanceWindowTaskArgs extends com.pulumi.resources.ResourceArgs {

    public static final MaintenanceWindowTaskArgs Empty = new MaintenanceWindowTaskArgs();

    /**
     * Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. Valid values are `CONTINUE_TASK` and `CANCEL_TASK`.
     * 
     */
    @Import(name="cutoffBehavior")
    private @Nullable Output<String> cutoffBehavior;

    /**
     * @return Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. Valid values are `CONTINUE_TASK` and `CANCEL_TASK`.
     * 
     */
    public Optional<Output<String>> cutoffBehavior() {
        return Optional.ofNullable(this.cutoffBehavior);
    }

    /**
     * The description of the maintenance window task.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return The description of the maintenance window task.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * The maximum number of targets this task can be run for in parallel.
     * 
     */
    @Import(name="maxConcurrency")
    private @Nullable Output<String> maxConcurrency;

    /**
     * @return The maximum number of targets this task can be run for in parallel.
     * 
     */
    public Optional<Output<String>> maxConcurrency() {
        return Optional.ofNullable(this.maxConcurrency);
    }

    /**
     * The maximum number of errors allowed before this task stops being scheduled.
     * 
     */
    @Import(name="maxErrors")
    private @Nullable Output<String> maxErrors;

    /**
     * @return The maximum number of errors allowed before this task stops being scheduled.
     * 
     */
    public Optional<Output<String>> maxErrors() {
        return Optional.ofNullable(this.maxErrors);
    }

    /**
     * The name of the maintenance window task.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name of the maintenance window task.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The priority of the task in the Maintenance Window, the lower the number the higher the priority. Tasks in a Maintenance Window are scheduled in priority order with tasks that have the same priority scheduled in parallel.
     * 
     */
    @Import(name="priority")
    private @Nullable Output<Integer> priority;

    /**
     * @return The priority of the task in the Maintenance Window, the lower the number the higher the priority. Tasks in a Maintenance Window are scheduled in priority order with tasks that have the same priority scheduled in parallel.
     * 
     */
    public Optional<Output<Integer>> priority() {
        return Optional.ofNullable(this.priority);
    }

    /**
     * The role that should be assumed when executing the task. If a role is not provided, Systems Manager uses your account&#39;s service-linked role. If no service-linked role for Systems Manager exists in your account, it is created for you.
     * 
     */
    @Import(name="serviceRoleArn")
    private @Nullable Output<String> serviceRoleArn;

    /**
     * @return The role that should be assumed when executing the task. If a role is not provided, Systems Manager uses your account&#39;s service-linked role. If no service-linked role for Systems Manager exists in your account, it is created for you.
     * 
     */
    public Optional<Output<String>> serviceRoleArn() {
        return Optional.ofNullable(this.serviceRoleArn);
    }

    /**
     * The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
     * 
     */
    @Import(name="targets")
    private @Nullable Output<List<MaintenanceWindowTaskTargetArgs>> targets;

    /**
     * @return The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
     * 
     */
    public Optional<Output<List<MaintenanceWindowTaskTargetArgs>>> targets() {
        return Optional.ofNullable(this.targets);
    }

    /**
     * The ARN of the task to execute.
     * 
     */
    @Import(name="taskArn", required=true)
    private Output<String> taskArn;

    /**
     * @return The ARN of the task to execute.
     * 
     */
    public Output<String> taskArn() {
        return this.taskArn;
    }

    /**
     * Configuration block with parameters for task execution.
     * 
     */
    @Import(name="taskInvocationParameters")
    private @Nullable Output<MaintenanceWindowTaskTaskInvocationParametersArgs> taskInvocationParameters;

    /**
     * @return Configuration block with parameters for task execution.
     * 
     */
    public Optional<Output<MaintenanceWindowTaskTaskInvocationParametersArgs>> taskInvocationParameters() {
        return Optional.ofNullable(this.taskInvocationParameters);
    }

    /**
     * The type of task being registered. Valid values: `AUTOMATION`, `LAMBDA`, `RUN_COMMAND` or `STEP_FUNCTIONS`.
     * 
     */
    @Import(name="taskType", required=true)
    private Output<String> taskType;

    /**
     * @return The type of task being registered. Valid values: `AUTOMATION`, `LAMBDA`, `RUN_COMMAND` or `STEP_FUNCTIONS`.
     * 
     */
    public Output<String> taskType() {
        return this.taskType;
    }

    /**
     * The Id of the maintenance window to register the task with.
     * 
     */
    @Import(name="windowId", required=true)
    private Output<String> windowId;

    /**
     * @return The Id of the maintenance window to register the task with.
     * 
     */
    public Output<String> windowId() {
        return this.windowId;
    }

    private MaintenanceWindowTaskArgs() {}

    private MaintenanceWindowTaskArgs(MaintenanceWindowTaskArgs $) {
        this.cutoffBehavior = $.cutoffBehavior;
        this.description = $.description;
        this.maxConcurrency = $.maxConcurrency;
        this.maxErrors = $.maxErrors;
        this.name = $.name;
        this.priority = $.priority;
        this.serviceRoleArn = $.serviceRoleArn;
        this.targets = $.targets;
        this.taskArn = $.taskArn;
        this.taskInvocationParameters = $.taskInvocationParameters;
        this.taskType = $.taskType;
        this.windowId = $.windowId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(MaintenanceWindowTaskArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private MaintenanceWindowTaskArgs $;

        public Builder() {
            $ = new MaintenanceWindowTaskArgs();
        }

        public Builder(MaintenanceWindowTaskArgs defaults) {
            $ = new MaintenanceWindowTaskArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param cutoffBehavior Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. Valid values are `CONTINUE_TASK` and `CANCEL_TASK`.
         * 
         * @return builder
         * 
         */
        public Builder cutoffBehavior(@Nullable Output<String> cutoffBehavior) {
            $.cutoffBehavior = cutoffBehavior;
            return this;
        }

        /**
         * @param cutoffBehavior Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. Valid values are `CONTINUE_TASK` and `CANCEL_TASK`.
         * 
         * @return builder
         * 
         */
        public Builder cutoffBehavior(String cutoffBehavior) {
            return cutoffBehavior(Output.of(cutoffBehavior));
        }

        /**
         * @param description The description of the maintenance window task.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description The description of the maintenance window task.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param maxConcurrency The maximum number of targets this task can be run for in parallel.
         * 
         * @return builder
         * 
         */
        public Builder maxConcurrency(@Nullable Output<String> maxConcurrency) {
            $.maxConcurrency = maxConcurrency;
            return this;
        }

        /**
         * @param maxConcurrency The maximum number of targets this task can be run for in parallel.
         * 
         * @return builder
         * 
         */
        public Builder maxConcurrency(String maxConcurrency) {
            return maxConcurrency(Output.of(maxConcurrency));
        }

        /**
         * @param maxErrors The maximum number of errors allowed before this task stops being scheduled.
         * 
         * @return builder
         * 
         */
        public Builder maxErrors(@Nullable Output<String> maxErrors) {
            $.maxErrors = maxErrors;
            return this;
        }

        /**
         * @param maxErrors The maximum number of errors allowed before this task stops being scheduled.
         * 
         * @return builder
         * 
         */
        public Builder maxErrors(String maxErrors) {
            return maxErrors(Output.of(maxErrors));
        }

        /**
         * @param name The name of the maintenance window task.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of the maintenance window task.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param priority The priority of the task in the Maintenance Window, the lower the number the higher the priority. Tasks in a Maintenance Window are scheduled in priority order with tasks that have the same priority scheduled in parallel.
         * 
         * @return builder
         * 
         */
        public Builder priority(@Nullable Output<Integer> priority) {
            $.priority = priority;
            return this;
        }

        /**
         * @param priority The priority of the task in the Maintenance Window, the lower the number the higher the priority. Tasks in a Maintenance Window are scheduled in priority order with tasks that have the same priority scheduled in parallel.
         * 
         * @return builder
         * 
         */
        public Builder priority(Integer priority) {
            return priority(Output.of(priority));
        }

        /**
         * @param serviceRoleArn The role that should be assumed when executing the task. If a role is not provided, Systems Manager uses your account&#39;s service-linked role. If no service-linked role for Systems Manager exists in your account, it is created for you.
         * 
         * @return builder
         * 
         */
        public Builder serviceRoleArn(@Nullable Output<String> serviceRoleArn) {
            $.serviceRoleArn = serviceRoleArn;
            return this;
        }

        /**
         * @param serviceRoleArn The role that should be assumed when executing the task. If a role is not provided, Systems Manager uses your account&#39;s service-linked role. If no service-linked role for Systems Manager exists in your account, it is created for you.
         * 
         * @return builder
         * 
         */
        public Builder serviceRoleArn(String serviceRoleArn) {
            return serviceRoleArn(Output.of(serviceRoleArn));
        }

        /**
         * @param targets The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
         * 
         * @return builder
         * 
         */
        public Builder targets(@Nullable Output<List<MaintenanceWindowTaskTargetArgs>> targets) {
            $.targets = targets;
            return this;
        }

        /**
         * @param targets The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
         * 
         * @return builder
         * 
         */
        public Builder targets(List<MaintenanceWindowTaskTargetArgs> targets) {
            return targets(Output.of(targets));
        }

        /**
         * @param targets The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
         * 
         * @return builder
         * 
         */
        public Builder targets(MaintenanceWindowTaskTargetArgs... targets) {
            return targets(List.of(targets));
        }

        /**
         * @param taskArn The ARN of the task to execute.
         * 
         * @return builder
         * 
         */
        public Builder taskArn(Output<String> taskArn) {
            $.taskArn = taskArn;
            return this;
        }

        /**
         * @param taskArn The ARN of the task to execute.
         * 
         * @return builder
         * 
         */
        public Builder taskArn(String taskArn) {
            return taskArn(Output.of(taskArn));
        }

        /**
         * @param taskInvocationParameters Configuration block with parameters for task execution.
         * 
         * @return builder
         * 
         */
        public Builder taskInvocationParameters(@Nullable Output<MaintenanceWindowTaskTaskInvocationParametersArgs> taskInvocationParameters) {
            $.taskInvocationParameters = taskInvocationParameters;
            return this;
        }

        /**
         * @param taskInvocationParameters Configuration block with parameters for task execution.
         * 
         * @return builder
         * 
         */
        public Builder taskInvocationParameters(MaintenanceWindowTaskTaskInvocationParametersArgs taskInvocationParameters) {
            return taskInvocationParameters(Output.of(taskInvocationParameters));
        }

        /**
         * @param taskType The type of task being registered. Valid values: `AUTOMATION`, `LAMBDA`, `RUN_COMMAND` or `STEP_FUNCTIONS`.
         * 
         * @return builder
         * 
         */
        public Builder taskType(Output<String> taskType) {
            $.taskType = taskType;
            return this;
        }

        /**
         * @param taskType The type of task being registered. Valid values: `AUTOMATION`, `LAMBDA`, `RUN_COMMAND` or `STEP_FUNCTIONS`.
         * 
         * @return builder
         * 
         */
        public Builder taskType(String taskType) {
            return taskType(Output.of(taskType));
        }

        /**
         * @param windowId The Id of the maintenance window to register the task with.
         * 
         * @return builder
         * 
         */
        public Builder windowId(Output<String> windowId) {
            $.windowId = windowId;
            return this;
        }

        /**
         * @param windowId The Id of the maintenance window to register the task with.
         * 
         * @return builder
         * 
         */
        public Builder windowId(String windowId) {
            return windowId(Output.of(windowId));
        }

        public MaintenanceWindowTaskArgs build() {
            $.taskArn = Objects.requireNonNull($.taskArn, "expected parameter 'taskArn' to be non-null");
            $.taskType = Objects.requireNonNull($.taskType, "expected parameter 'taskType' to be non-null");
            $.windowId = Objects.requireNonNull($.windowId, "expected parameter 'windowId' to be non-null");
            return $;
        }
    }

}
