// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.sqs;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.sqs.RedriveAllowPolicyArgs;
import com.pulumi.aws.sqs.inputs.RedriveAllowPolicyState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Provides a SQS Queue Redrive Allow Policy resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.sqs.QueueArgs;
 * import com.pulumi.aws.sqs.RedriveAllowPolicy;
 * import com.pulumi.aws.sqs.RedriveAllowPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleQueue = new Queue(&#34;exampleQueue&#34;);
 * 
 *         var src = new Queue(&#34;src&#34;, QueueArgs.builder()        
 *             .redrivePolicy(exampleQueue.arn().applyValue(arn -&gt; serializeJson(
 *                 jsonObject(
 *                     jsonProperty(&#34;deadLetterTargetArn&#34;, arn),
 *                     jsonProperty(&#34;maxReceiveCount&#34;, 4)
 *                 ))))
 *             .build());
 * 
 *         var exampleRedriveAllowPolicy = new RedriveAllowPolicy(&#34;exampleRedriveAllowPolicy&#34;, RedriveAllowPolicyArgs.builder()        
 *             .queueUrl(exampleQueue.id())
 *             .redriveAllowPolicy(src.arn().applyValue(arn -&gt; serializeJson(
 *                 jsonObject(
 *                     jsonProperty(&#34;redrivePermission&#34;, &#34;byQueue&#34;),
 *                     jsonProperty(&#34;sourceQueueArns&#34;, jsonArray(arn))
 *                 ))))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import SQS Queue Redrive Allow Policies using the queue URL. For example:
 * 
 * ```sh
 *  $ pulumi import aws:sqs/redriveAllowPolicy:RedriveAllowPolicy test https://queue.amazonaws.com/0123456789012/myqueue
 * ```
 * 
 */
@ResourceType(type="aws:sqs/redriveAllowPolicy:RedriveAllowPolicy")
public class RedriveAllowPolicy extends com.pulumi.resources.CustomResource {
    /**
     * The URL of the SQS Queue to which to attach the policy
     * 
     */
    @Export(name="queueUrl", refs={String.class}, tree="[0]")
    private Output<String> queueUrl;

    /**
     * @return The URL of the SQS Queue to which to attach the policy
     * 
     */
    public Output<String> queueUrl() {
        return this.queueUrl;
    }
    /**
     * The JSON redrive allow policy for the SQS queue. Learn more in the [Amazon SQS dead-letter queues documentation](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html).
     * 
     */
    @Export(name="redriveAllowPolicy", refs={String.class}, tree="[0]")
    private Output<String> redriveAllowPolicy;

    /**
     * @return The JSON redrive allow policy for the SQS queue. Learn more in the [Amazon SQS dead-letter queues documentation](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html).
     * 
     */
    public Output<String> redriveAllowPolicy() {
        return this.redriveAllowPolicy;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public RedriveAllowPolicy(String name) {
        this(name, RedriveAllowPolicyArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public RedriveAllowPolicy(String name, RedriveAllowPolicyArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public RedriveAllowPolicy(String name, RedriveAllowPolicyArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sqs/redriveAllowPolicy:RedriveAllowPolicy", name, args == null ? RedriveAllowPolicyArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private RedriveAllowPolicy(String name, Output<String> id, @Nullable RedriveAllowPolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sqs/redriveAllowPolicy:RedriveAllowPolicy", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static RedriveAllowPolicy get(String name, Output<String> id, @Nullable RedriveAllowPolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new RedriveAllowPolicy(name, id, state, options);
    }
}
