// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.sqs;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.sqs.QueuePolicyArgs;
import com.pulumi.aws.sqs.inputs.QueuePolicyState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Allows you to set a policy of an SQS Queue
 * while referencing ARN of the queue within the policy.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sqs.QueuePolicy;
 * import com.pulumi.aws.sqs.QueuePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var queue = new Queue(&#34;queue&#34;);
 * 
 *         final var testPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid(&#34;First&#34;)
 *                 .effect(&#34;Allow&#34;)
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type(&#34;*&#34;)
 *                     .identifiers(&#34;*&#34;)
 *                     .build())
 *                 .actions(&#34;sqs:SendMessage&#34;)
 *                 .resources(queue.arn())
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test(&#34;ArnEquals&#34;)
 *                     .variable(&#34;aws:SourceArn&#34;)
 *                     .values(aws_sns_topic.example().arn())
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *         var testQueuePolicy = new QueuePolicy(&#34;testQueuePolicy&#34;, QueuePolicyArgs.builder()        
 *             .queueUrl(queue.id())
 *             .policy(testPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult).applyValue(testPolicyDocument -&gt; testPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json())))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import SQS Queue Policies using the queue URL. For example:
 * 
 * ```sh
 *  $ pulumi import aws:sqs/queuePolicy:QueuePolicy test https://queue.amazonaws.com/0123456789012/myqueue
 * ```
 * 
 */
@ResourceType(type="aws:sqs/queuePolicy:QueuePolicy")
public class QueuePolicy extends com.pulumi.resources.CustomResource {
    /**
     * The JSON policy for the SQS queue.
     * 
     */
    @Export(name="policy", refs={String.class}, tree="[0]")
    private Output<String> policy;

    /**
     * @return The JSON policy for the SQS queue.
     * 
     */
    public Output<String> policy() {
        return this.policy;
    }
    /**
     * The URL of the SQS Queue to which to attach the policy
     * 
     */
    @Export(name="queueUrl", refs={String.class}, tree="[0]")
    private Output<String> queueUrl;

    /**
     * @return The URL of the SQS Queue to which to attach the policy
     * 
     */
    public Output<String> queueUrl() {
        return this.queueUrl;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public QueuePolicy(String name) {
        this(name, QueuePolicyArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public QueuePolicy(String name, QueuePolicyArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public QueuePolicy(String name, QueuePolicyArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sqs/queuePolicy:QueuePolicy", name, args == null ? QueuePolicyArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private QueuePolicy(String name, Output<String> id, @Nullable QueuePolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sqs/queuePolicy:QueuePolicy", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static QueuePolicy get(String name, Output<String> id, @Nullable QueuePolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new QueuePolicy(name, id, state, options);
    }
}
