// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.sns;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class PlatformApplicationArgs extends com.pulumi.resources.ResourceArgs {

    public static final PlatformApplicationArgs Empty = new PlatformApplicationArgs();

    /**
     * The bundle identifier that&#39;s assigned to your iOS app. May only include alphanumeric characters, hyphens (-), and periods (.).
     * 
     */
    @Import(name="applePlatformBundleId")
    private @Nullable Output<String> applePlatformBundleId;

    /**
     * @return The bundle identifier that&#39;s assigned to your iOS app. May only include alphanumeric characters, hyphens (-), and periods (.).
     * 
     */
    public Optional<Output<String>> applePlatformBundleId() {
        return Optional.ofNullable(this.applePlatformBundleId);
    }

    /**
     * The identifier that&#39;s assigned to your Apple developer account team. Must be 10 alphanumeric characters.
     * 
     */
    @Import(name="applePlatformTeamId")
    private @Nullable Output<String> applePlatformTeamId;

    /**
     * @return The identifier that&#39;s assigned to your Apple developer account team. Must be 10 alphanumeric characters.
     * 
     */
    public Optional<Output<String>> applePlatformTeamId() {
        return Optional.ofNullable(this.applePlatformTeamId);
    }

    /**
     * The ARN of the SNS Topic triggered when a delivery to any of the platform endpoints associated with your platform application encounters a permanent failure.
     * 
     */
    @Import(name="eventDeliveryFailureTopicArn")
    private @Nullable Output<String> eventDeliveryFailureTopicArn;

    /**
     * @return The ARN of the SNS Topic triggered when a delivery to any of the platform endpoints associated with your platform application encounters a permanent failure.
     * 
     */
    public Optional<Output<String>> eventDeliveryFailureTopicArn() {
        return Optional.ofNullable(this.eventDeliveryFailureTopicArn);
    }

    /**
     * The ARN of the SNS Topic triggered when a new platform endpoint is added to your platform application.
     * 
     */
    @Import(name="eventEndpointCreatedTopicArn")
    private @Nullable Output<String> eventEndpointCreatedTopicArn;

    /**
     * @return The ARN of the SNS Topic triggered when a new platform endpoint is added to your platform application.
     * 
     */
    public Optional<Output<String>> eventEndpointCreatedTopicArn() {
        return Optional.ofNullable(this.eventEndpointCreatedTopicArn);
    }

    /**
     * The ARN of the SNS Topic triggered when an existing platform endpoint is deleted from your platform application.
     * 
     */
    @Import(name="eventEndpointDeletedTopicArn")
    private @Nullable Output<String> eventEndpointDeletedTopicArn;

    /**
     * @return The ARN of the SNS Topic triggered when an existing platform endpoint is deleted from your platform application.
     * 
     */
    public Optional<Output<String>> eventEndpointDeletedTopicArn() {
        return Optional.ofNullable(this.eventEndpointDeletedTopicArn);
    }

    /**
     * The ARN of the SNS Topic triggered when an existing platform endpoint is changed from your platform application.
     * 
     */
    @Import(name="eventEndpointUpdatedTopicArn")
    private @Nullable Output<String> eventEndpointUpdatedTopicArn;

    /**
     * @return The ARN of the SNS Topic triggered when an existing platform endpoint is changed from your platform application.
     * 
     */
    public Optional<Output<String>> eventEndpointUpdatedTopicArn() {
        return Optional.ofNullable(this.eventEndpointUpdatedTopicArn);
    }

    /**
     * The IAM role ARN permitted to receive failure feedback for this application and give SNS write access to use CloudWatch logs on your behalf.
     * 
     */
    @Import(name="failureFeedbackRoleArn")
    private @Nullable Output<String> failureFeedbackRoleArn;

    /**
     * @return The IAM role ARN permitted to receive failure feedback for this application and give SNS write access to use CloudWatch logs on your behalf.
     * 
     */
    public Optional<Output<String>> failureFeedbackRoleArn() {
        return Optional.ofNullable(this.failureFeedbackRoleArn);
    }

    /**
     * The friendly name for the SNS platform application
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The friendly name for the SNS platform application
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The platform that the app is registered with. See [Platform](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-register.html) for supported platforms.
     * 
     */
    @Import(name="platform", required=true)
    private Output<String> platform;

    /**
     * @return The platform that the app is registered with. See [Platform](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-register.html) for supported platforms.
     * 
     */
    public Output<String> platform() {
        return this.platform;
    }

    /**
     * Application Platform credential. See [Credential](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-register.html) for type of credential required for platform. The value of this attribute when stored into the state is only a hash of the real value, so therefore it is not practical to use this as an attribute for other resources.
     * 
     */
    @Import(name="platformCredential", required=true)
    private Output<String> platformCredential;

    /**
     * @return Application Platform credential. See [Credential](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-register.html) for type of credential required for platform. The value of this attribute when stored into the state is only a hash of the real value, so therefore it is not practical to use this as an attribute for other resources.
     * 
     */
    public Output<String> platformCredential() {
        return this.platformCredential;
    }

    /**
     * Application Platform principal. See [Principal](http://docs.aws.amazon.com/sns/latest/api/API_CreatePlatformApplication.html) for type of principal required for platform. The value of this attribute when stored into the state is only a hash of the real value, so therefore it is not practical to use this as an attribute for other resources.
     * 
     */
    @Import(name="platformPrincipal")
    private @Nullable Output<String> platformPrincipal;

    /**
     * @return Application Platform principal. See [Principal](http://docs.aws.amazon.com/sns/latest/api/API_CreatePlatformApplication.html) for type of principal required for platform. The value of this attribute when stored into the state is only a hash of the real value, so therefore it is not practical to use this as an attribute for other resources.
     * 
     */
    public Optional<Output<String>> platformPrincipal() {
        return Optional.ofNullable(this.platformPrincipal);
    }

    /**
     * The IAM role ARN permitted to receive success feedback for this application and give SNS write access to use CloudWatch logs on your behalf.
     * 
     */
    @Import(name="successFeedbackRoleArn")
    private @Nullable Output<String> successFeedbackRoleArn;

    /**
     * @return The IAM role ARN permitted to receive success feedback for this application and give SNS write access to use CloudWatch logs on your behalf.
     * 
     */
    public Optional<Output<String>> successFeedbackRoleArn() {
        return Optional.ofNullable(this.successFeedbackRoleArn);
    }

    /**
     * The sample rate percentage (0-100) of successfully delivered messages.
     * 
     * The following attributes are needed only when using APNS token credentials:
     * 
     */
    @Import(name="successFeedbackSampleRate")
    private @Nullable Output<String> successFeedbackSampleRate;

    /**
     * @return The sample rate percentage (0-100) of successfully delivered messages.
     * 
     * The following attributes are needed only when using APNS token credentials:
     * 
     */
    public Optional<Output<String>> successFeedbackSampleRate() {
        return Optional.ofNullable(this.successFeedbackSampleRate);
    }

    private PlatformApplicationArgs() {}

    private PlatformApplicationArgs(PlatformApplicationArgs $) {
        this.applePlatformBundleId = $.applePlatformBundleId;
        this.applePlatformTeamId = $.applePlatformTeamId;
        this.eventDeliveryFailureTopicArn = $.eventDeliveryFailureTopicArn;
        this.eventEndpointCreatedTopicArn = $.eventEndpointCreatedTopicArn;
        this.eventEndpointDeletedTopicArn = $.eventEndpointDeletedTopicArn;
        this.eventEndpointUpdatedTopicArn = $.eventEndpointUpdatedTopicArn;
        this.failureFeedbackRoleArn = $.failureFeedbackRoleArn;
        this.name = $.name;
        this.platform = $.platform;
        this.platformCredential = $.platformCredential;
        this.platformPrincipal = $.platformPrincipal;
        this.successFeedbackRoleArn = $.successFeedbackRoleArn;
        this.successFeedbackSampleRate = $.successFeedbackSampleRate;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(PlatformApplicationArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private PlatformApplicationArgs $;

        public Builder() {
            $ = new PlatformApplicationArgs();
        }

        public Builder(PlatformApplicationArgs defaults) {
            $ = new PlatformApplicationArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param applePlatformBundleId The bundle identifier that&#39;s assigned to your iOS app. May only include alphanumeric characters, hyphens (-), and periods (.).
         * 
         * @return builder
         * 
         */
        public Builder applePlatformBundleId(@Nullable Output<String> applePlatformBundleId) {
            $.applePlatformBundleId = applePlatformBundleId;
            return this;
        }

        /**
         * @param applePlatformBundleId The bundle identifier that&#39;s assigned to your iOS app. May only include alphanumeric characters, hyphens (-), and periods (.).
         * 
         * @return builder
         * 
         */
        public Builder applePlatformBundleId(String applePlatformBundleId) {
            return applePlatformBundleId(Output.of(applePlatformBundleId));
        }

        /**
         * @param applePlatformTeamId The identifier that&#39;s assigned to your Apple developer account team. Must be 10 alphanumeric characters.
         * 
         * @return builder
         * 
         */
        public Builder applePlatformTeamId(@Nullable Output<String> applePlatformTeamId) {
            $.applePlatformTeamId = applePlatformTeamId;
            return this;
        }

        /**
         * @param applePlatformTeamId The identifier that&#39;s assigned to your Apple developer account team. Must be 10 alphanumeric characters.
         * 
         * @return builder
         * 
         */
        public Builder applePlatformTeamId(String applePlatformTeamId) {
            return applePlatformTeamId(Output.of(applePlatformTeamId));
        }

        /**
         * @param eventDeliveryFailureTopicArn The ARN of the SNS Topic triggered when a delivery to any of the platform endpoints associated with your platform application encounters a permanent failure.
         * 
         * @return builder
         * 
         */
        public Builder eventDeliveryFailureTopicArn(@Nullable Output<String> eventDeliveryFailureTopicArn) {
            $.eventDeliveryFailureTopicArn = eventDeliveryFailureTopicArn;
            return this;
        }

        /**
         * @param eventDeliveryFailureTopicArn The ARN of the SNS Topic triggered when a delivery to any of the platform endpoints associated with your platform application encounters a permanent failure.
         * 
         * @return builder
         * 
         */
        public Builder eventDeliveryFailureTopicArn(String eventDeliveryFailureTopicArn) {
            return eventDeliveryFailureTopicArn(Output.of(eventDeliveryFailureTopicArn));
        }

        /**
         * @param eventEndpointCreatedTopicArn The ARN of the SNS Topic triggered when a new platform endpoint is added to your platform application.
         * 
         * @return builder
         * 
         */
        public Builder eventEndpointCreatedTopicArn(@Nullable Output<String> eventEndpointCreatedTopicArn) {
            $.eventEndpointCreatedTopicArn = eventEndpointCreatedTopicArn;
            return this;
        }

        /**
         * @param eventEndpointCreatedTopicArn The ARN of the SNS Topic triggered when a new platform endpoint is added to your platform application.
         * 
         * @return builder
         * 
         */
        public Builder eventEndpointCreatedTopicArn(String eventEndpointCreatedTopicArn) {
            return eventEndpointCreatedTopicArn(Output.of(eventEndpointCreatedTopicArn));
        }

        /**
         * @param eventEndpointDeletedTopicArn The ARN of the SNS Topic triggered when an existing platform endpoint is deleted from your platform application.
         * 
         * @return builder
         * 
         */
        public Builder eventEndpointDeletedTopicArn(@Nullable Output<String> eventEndpointDeletedTopicArn) {
            $.eventEndpointDeletedTopicArn = eventEndpointDeletedTopicArn;
            return this;
        }

        /**
         * @param eventEndpointDeletedTopicArn The ARN of the SNS Topic triggered when an existing platform endpoint is deleted from your platform application.
         * 
         * @return builder
         * 
         */
        public Builder eventEndpointDeletedTopicArn(String eventEndpointDeletedTopicArn) {
            return eventEndpointDeletedTopicArn(Output.of(eventEndpointDeletedTopicArn));
        }

        /**
         * @param eventEndpointUpdatedTopicArn The ARN of the SNS Topic triggered when an existing platform endpoint is changed from your platform application.
         * 
         * @return builder
         * 
         */
        public Builder eventEndpointUpdatedTopicArn(@Nullable Output<String> eventEndpointUpdatedTopicArn) {
            $.eventEndpointUpdatedTopicArn = eventEndpointUpdatedTopicArn;
            return this;
        }

        /**
         * @param eventEndpointUpdatedTopicArn The ARN of the SNS Topic triggered when an existing platform endpoint is changed from your platform application.
         * 
         * @return builder
         * 
         */
        public Builder eventEndpointUpdatedTopicArn(String eventEndpointUpdatedTopicArn) {
            return eventEndpointUpdatedTopicArn(Output.of(eventEndpointUpdatedTopicArn));
        }

        /**
         * @param failureFeedbackRoleArn The IAM role ARN permitted to receive failure feedback for this application and give SNS write access to use CloudWatch logs on your behalf.
         * 
         * @return builder
         * 
         */
        public Builder failureFeedbackRoleArn(@Nullable Output<String> failureFeedbackRoleArn) {
            $.failureFeedbackRoleArn = failureFeedbackRoleArn;
            return this;
        }

        /**
         * @param failureFeedbackRoleArn The IAM role ARN permitted to receive failure feedback for this application and give SNS write access to use CloudWatch logs on your behalf.
         * 
         * @return builder
         * 
         */
        public Builder failureFeedbackRoleArn(String failureFeedbackRoleArn) {
            return failureFeedbackRoleArn(Output.of(failureFeedbackRoleArn));
        }

        /**
         * @param name The friendly name for the SNS platform application
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The friendly name for the SNS platform application
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param platform The platform that the app is registered with. See [Platform](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-register.html) for supported platforms.
         * 
         * @return builder
         * 
         */
        public Builder platform(Output<String> platform) {
            $.platform = platform;
            return this;
        }

        /**
         * @param platform The platform that the app is registered with. See [Platform](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-register.html) for supported platforms.
         * 
         * @return builder
         * 
         */
        public Builder platform(String platform) {
            return platform(Output.of(platform));
        }

        /**
         * @param platformCredential Application Platform credential. See [Credential](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-register.html) for type of credential required for platform. The value of this attribute when stored into the state is only a hash of the real value, so therefore it is not practical to use this as an attribute for other resources.
         * 
         * @return builder
         * 
         */
        public Builder platformCredential(Output<String> platformCredential) {
            $.platformCredential = platformCredential;
            return this;
        }

        /**
         * @param platformCredential Application Platform credential. See [Credential](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-register.html) for type of credential required for platform. The value of this attribute when stored into the state is only a hash of the real value, so therefore it is not practical to use this as an attribute for other resources.
         * 
         * @return builder
         * 
         */
        public Builder platformCredential(String platformCredential) {
            return platformCredential(Output.of(platformCredential));
        }

        /**
         * @param platformPrincipal Application Platform principal. See [Principal](http://docs.aws.amazon.com/sns/latest/api/API_CreatePlatformApplication.html) for type of principal required for platform. The value of this attribute when stored into the state is only a hash of the real value, so therefore it is not practical to use this as an attribute for other resources.
         * 
         * @return builder
         * 
         */
        public Builder platformPrincipal(@Nullable Output<String> platformPrincipal) {
            $.platformPrincipal = platformPrincipal;
            return this;
        }

        /**
         * @param platformPrincipal Application Platform principal. See [Principal](http://docs.aws.amazon.com/sns/latest/api/API_CreatePlatformApplication.html) for type of principal required for platform. The value of this attribute when stored into the state is only a hash of the real value, so therefore it is not practical to use this as an attribute for other resources.
         * 
         * @return builder
         * 
         */
        public Builder platformPrincipal(String platformPrincipal) {
            return platformPrincipal(Output.of(platformPrincipal));
        }

        /**
         * @param successFeedbackRoleArn The IAM role ARN permitted to receive success feedback for this application and give SNS write access to use CloudWatch logs on your behalf.
         * 
         * @return builder
         * 
         */
        public Builder successFeedbackRoleArn(@Nullable Output<String> successFeedbackRoleArn) {
            $.successFeedbackRoleArn = successFeedbackRoleArn;
            return this;
        }

        /**
         * @param successFeedbackRoleArn The IAM role ARN permitted to receive success feedback for this application and give SNS write access to use CloudWatch logs on your behalf.
         * 
         * @return builder
         * 
         */
        public Builder successFeedbackRoleArn(String successFeedbackRoleArn) {
            return successFeedbackRoleArn(Output.of(successFeedbackRoleArn));
        }

        /**
         * @param successFeedbackSampleRate The sample rate percentage (0-100) of successfully delivered messages.
         * 
         * The following attributes are needed only when using APNS token credentials:
         * 
         * @return builder
         * 
         */
        public Builder successFeedbackSampleRate(@Nullable Output<String> successFeedbackSampleRate) {
            $.successFeedbackSampleRate = successFeedbackSampleRate;
            return this;
        }

        /**
         * @param successFeedbackSampleRate The sample rate percentage (0-100) of successfully delivered messages.
         * 
         * The following attributes are needed only when using APNS token credentials:
         * 
         * @return builder
         * 
         */
        public Builder successFeedbackSampleRate(String successFeedbackSampleRate) {
            return successFeedbackSampleRate(Output.of(successFeedbackSampleRate));
        }

        public PlatformApplicationArgs build() {
            $.platform = Objects.requireNonNull($.platform, "expected parameter 'platform' to be non-null");
            $.platformCredential = Objects.requireNonNull($.platformCredential, "expected parameter 'platformCredential' to be non-null");
            return $;
        }
    }

}
