// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.signer.inputs;

import com.pulumi.aws.signer.inputs.SigningJobDestinationArgs;
import com.pulumi.aws.signer.inputs.SigningJobRevocationRecordArgs;
import com.pulumi.aws.signer.inputs.SigningJobSignedObjectArgs;
import com.pulumi.aws.signer.inputs.SigningJobSourceArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class SigningJobState extends com.pulumi.resources.ResourceArgs {

    public static final SigningJobState Empty = new SigningJobState();

    /**
     * Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the signing job was completed.
     * 
     */
    @Import(name="completedAt")
    private @Nullable Output<String> completedAt;

    /**
     * @return Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the signing job was completed.
     * 
     */
    public Optional<Output<String>> completedAt() {
        return Optional.ofNullable(this.completedAt);
    }

    /**
     * Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the signing job was created.
     * 
     */
    @Import(name="createdAt")
    private @Nullable Output<String> createdAt;

    /**
     * @return Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the signing job was created.
     * 
     */
    public Optional<Output<String>> createdAt() {
        return Optional.ofNullable(this.createdAt);
    }

    /**
     * The S3 bucket in which to save your signed object. See Destination below for details.
     * 
     */
    @Import(name="destination")
    private @Nullable Output<SigningJobDestinationArgs> destination;

    /**
     * @return The S3 bucket in which to save your signed object. See Destination below for details.
     * 
     */
    public Optional<Output<SigningJobDestinationArgs>> destination() {
        return Optional.ofNullable(this.destination);
    }

    /**
     * Set this argument to `true` to ignore signing job failures and retrieve failed status and reason. Default `false`.
     * 
     */
    @Import(name="ignoreSigningJobFailure")
    private @Nullable Output<Boolean> ignoreSigningJobFailure;

    /**
     * @return Set this argument to `true` to ignore signing job failures and retrieve failed status and reason. Default `false`.
     * 
     */
    public Optional<Output<Boolean>> ignoreSigningJobFailure() {
        return Optional.ofNullable(this.ignoreSigningJobFailure);
    }

    /**
     * The ID of the signing job on output.
     * 
     */
    @Import(name="jobId")
    private @Nullable Output<String> jobId;

    /**
     * @return The ID of the signing job on output.
     * 
     */
    public Optional<Output<String>> jobId() {
        return Optional.ofNullable(this.jobId);
    }

    /**
     * The IAM entity that initiated the signing job.
     * 
     */
    @Import(name="jobInvoker")
    private @Nullable Output<String> jobInvoker;

    /**
     * @return The IAM entity that initiated the signing job.
     * 
     */
    public Optional<Output<String>> jobInvoker() {
        return Optional.ofNullable(this.jobInvoker);
    }

    /**
     * The AWS account ID of the job owner.
     * 
     */
    @Import(name="jobOwner")
    private @Nullable Output<String> jobOwner;

    /**
     * @return The AWS account ID of the job owner.
     * 
     */
    public Optional<Output<String>> jobOwner() {
        return Optional.ofNullable(this.jobOwner);
    }

    /**
     * A human-readable name for the signing platform associated with the signing job.
     * 
     */
    @Import(name="platformDisplayName")
    private @Nullable Output<String> platformDisplayName;

    /**
     * @return A human-readable name for the signing platform associated with the signing job.
     * 
     */
    public Optional<Output<String>> platformDisplayName() {
        return Optional.ofNullable(this.platformDisplayName);
    }

    /**
     * The platform to which your signed code image will be distributed.
     * 
     */
    @Import(name="platformId")
    private @Nullable Output<String> platformId;

    /**
     * @return The platform to which your signed code image will be distributed.
     * 
     */
    public Optional<Output<String>> platformId() {
        return Optional.ofNullable(this.platformId);
    }

    /**
     * The name of the profile to initiate the signing operation.
     * 
     */
    @Import(name="profileName")
    private @Nullable Output<String> profileName;

    /**
     * @return The name of the profile to initiate the signing operation.
     * 
     */
    public Optional<Output<String>> profileName() {
        return Optional.ofNullable(this.profileName);
    }

    /**
     * The version of the signing profile used to initiate the signing job.
     * 
     */
    @Import(name="profileVersion")
    private @Nullable Output<String> profileVersion;

    /**
     * @return The version of the signing profile used to initiate the signing job.
     * 
     */
    public Optional<Output<String>> profileVersion() {
        return Optional.ofNullable(this.profileVersion);
    }

    /**
     * The IAM principal that requested the signing job.
     * 
     */
    @Import(name="requestedBy")
    private @Nullable Output<String> requestedBy;

    /**
     * @return The IAM principal that requested the signing job.
     * 
     */
    public Optional<Output<String>> requestedBy() {
        return Optional.ofNullable(this.requestedBy);
    }

    /**
     * A revocation record if the signature generated by the signing job has been revoked. Contains a timestamp and the ID of the IAM entity that revoked the signature.
     * 
     */
    @Import(name="revocationRecords")
    private @Nullable Output<List<SigningJobRevocationRecordArgs>> revocationRecords;

    /**
     * @return A revocation record if the signature generated by the signing job has been revoked. Contains a timestamp and the ID of the IAM entity that revoked the signature.
     * 
     */
    public Optional<Output<List<SigningJobRevocationRecordArgs>>> revocationRecords() {
        return Optional.ofNullable(this.revocationRecords);
    }

    /**
     * The time when the signature of a signing job expires.
     * 
     */
    @Import(name="signatureExpiresAt")
    private @Nullable Output<String> signatureExpiresAt;

    /**
     * @return The time when the signature of a signing job expires.
     * 
     */
    public Optional<Output<String>> signatureExpiresAt() {
        return Optional.ofNullable(this.signatureExpiresAt);
    }

    /**
     * Name of the S3 bucket where the signed code image is saved by code signing.
     * 
     */
    @Import(name="signedObjects")
    private @Nullable Output<List<SigningJobSignedObjectArgs>> signedObjects;

    /**
     * @return Name of the S3 bucket where the signed code image is saved by code signing.
     * 
     */
    public Optional<Output<List<SigningJobSignedObjectArgs>>> signedObjects() {
        return Optional.ofNullable(this.signedObjects);
    }

    /**
     * The S3 bucket that contains the object to sign. See Source below for details.
     * 
     */
    @Import(name="source")
    private @Nullable Output<SigningJobSourceArgs> source;

    /**
     * @return The S3 bucket that contains the object to sign. See Source below for details.
     * 
     */
    public Optional<Output<SigningJobSourceArgs>> source() {
        return Optional.ofNullable(this.source);
    }

    /**
     * Status of the signing job.
     * 
     */
    @Import(name="status")
    private @Nullable Output<String> status;

    /**
     * @return Status of the signing job.
     * 
     */
    public Optional<Output<String>> status() {
        return Optional.ofNullable(this.status);
    }

    /**
     * String value that contains the status reason.
     * 
     */
    @Import(name="statusReason")
    private @Nullable Output<String> statusReason;

    /**
     * @return String value that contains the status reason.
     * 
     */
    public Optional<Output<String>> statusReason() {
        return Optional.ofNullable(this.statusReason);
    }

    private SigningJobState() {}

    private SigningJobState(SigningJobState $) {
        this.completedAt = $.completedAt;
        this.createdAt = $.createdAt;
        this.destination = $.destination;
        this.ignoreSigningJobFailure = $.ignoreSigningJobFailure;
        this.jobId = $.jobId;
        this.jobInvoker = $.jobInvoker;
        this.jobOwner = $.jobOwner;
        this.platformDisplayName = $.platformDisplayName;
        this.platformId = $.platformId;
        this.profileName = $.profileName;
        this.profileVersion = $.profileVersion;
        this.requestedBy = $.requestedBy;
        this.revocationRecords = $.revocationRecords;
        this.signatureExpiresAt = $.signatureExpiresAt;
        this.signedObjects = $.signedObjects;
        this.source = $.source;
        this.status = $.status;
        this.statusReason = $.statusReason;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(SigningJobState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private SigningJobState $;

        public Builder() {
            $ = new SigningJobState();
        }

        public Builder(SigningJobState defaults) {
            $ = new SigningJobState(Objects.requireNonNull(defaults));
        }

        /**
         * @param completedAt Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the signing job was completed.
         * 
         * @return builder
         * 
         */
        public Builder completedAt(@Nullable Output<String> completedAt) {
            $.completedAt = completedAt;
            return this;
        }

        /**
         * @param completedAt Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the signing job was completed.
         * 
         * @return builder
         * 
         */
        public Builder completedAt(String completedAt) {
            return completedAt(Output.of(completedAt));
        }

        /**
         * @param createdAt Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the signing job was created.
         * 
         * @return builder
         * 
         */
        public Builder createdAt(@Nullable Output<String> createdAt) {
            $.createdAt = createdAt;
            return this;
        }

        /**
         * @param createdAt Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the signing job was created.
         * 
         * @return builder
         * 
         */
        public Builder createdAt(String createdAt) {
            return createdAt(Output.of(createdAt));
        }

        /**
         * @param destination The S3 bucket in which to save your signed object. See Destination below for details.
         * 
         * @return builder
         * 
         */
        public Builder destination(@Nullable Output<SigningJobDestinationArgs> destination) {
            $.destination = destination;
            return this;
        }

        /**
         * @param destination The S3 bucket in which to save your signed object. See Destination below for details.
         * 
         * @return builder
         * 
         */
        public Builder destination(SigningJobDestinationArgs destination) {
            return destination(Output.of(destination));
        }

        /**
         * @param ignoreSigningJobFailure Set this argument to `true` to ignore signing job failures and retrieve failed status and reason. Default `false`.
         * 
         * @return builder
         * 
         */
        public Builder ignoreSigningJobFailure(@Nullable Output<Boolean> ignoreSigningJobFailure) {
            $.ignoreSigningJobFailure = ignoreSigningJobFailure;
            return this;
        }

        /**
         * @param ignoreSigningJobFailure Set this argument to `true` to ignore signing job failures and retrieve failed status and reason. Default `false`.
         * 
         * @return builder
         * 
         */
        public Builder ignoreSigningJobFailure(Boolean ignoreSigningJobFailure) {
            return ignoreSigningJobFailure(Output.of(ignoreSigningJobFailure));
        }

        /**
         * @param jobId The ID of the signing job on output.
         * 
         * @return builder
         * 
         */
        public Builder jobId(@Nullable Output<String> jobId) {
            $.jobId = jobId;
            return this;
        }

        /**
         * @param jobId The ID of the signing job on output.
         * 
         * @return builder
         * 
         */
        public Builder jobId(String jobId) {
            return jobId(Output.of(jobId));
        }

        /**
         * @param jobInvoker The IAM entity that initiated the signing job.
         * 
         * @return builder
         * 
         */
        public Builder jobInvoker(@Nullable Output<String> jobInvoker) {
            $.jobInvoker = jobInvoker;
            return this;
        }

        /**
         * @param jobInvoker The IAM entity that initiated the signing job.
         * 
         * @return builder
         * 
         */
        public Builder jobInvoker(String jobInvoker) {
            return jobInvoker(Output.of(jobInvoker));
        }

        /**
         * @param jobOwner The AWS account ID of the job owner.
         * 
         * @return builder
         * 
         */
        public Builder jobOwner(@Nullable Output<String> jobOwner) {
            $.jobOwner = jobOwner;
            return this;
        }

        /**
         * @param jobOwner The AWS account ID of the job owner.
         * 
         * @return builder
         * 
         */
        public Builder jobOwner(String jobOwner) {
            return jobOwner(Output.of(jobOwner));
        }

        /**
         * @param platformDisplayName A human-readable name for the signing platform associated with the signing job.
         * 
         * @return builder
         * 
         */
        public Builder platformDisplayName(@Nullable Output<String> platformDisplayName) {
            $.platformDisplayName = platformDisplayName;
            return this;
        }

        /**
         * @param platformDisplayName A human-readable name for the signing platform associated with the signing job.
         * 
         * @return builder
         * 
         */
        public Builder platformDisplayName(String platformDisplayName) {
            return platformDisplayName(Output.of(platformDisplayName));
        }

        /**
         * @param platformId The platform to which your signed code image will be distributed.
         * 
         * @return builder
         * 
         */
        public Builder platformId(@Nullable Output<String> platformId) {
            $.platformId = platformId;
            return this;
        }

        /**
         * @param platformId The platform to which your signed code image will be distributed.
         * 
         * @return builder
         * 
         */
        public Builder platformId(String platformId) {
            return platformId(Output.of(platformId));
        }

        /**
         * @param profileName The name of the profile to initiate the signing operation.
         * 
         * @return builder
         * 
         */
        public Builder profileName(@Nullable Output<String> profileName) {
            $.profileName = profileName;
            return this;
        }

        /**
         * @param profileName The name of the profile to initiate the signing operation.
         * 
         * @return builder
         * 
         */
        public Builder profileName(String profileName) {
            return profileName(Output.of(profileName));
        }

        /**
         * @param profileVersion The version of the signing profile used to initiate the signing job.
         * 
         * @return builder
         * 
         */
        public Builder profileVersion(@Nullable Output<String> profileVersion) {
            $.profileVersion = profileVersion;
            return this;
        }

        /**
         * @param profileVersion The version of the signing profile used to initiate the signing job.
         * 
         * @return builder
         * 
         */
        public Builder profileVersion(String profileVersion) {
            return profileVersion(Output.of(profileVersion));
        }

        /**
         * @param requestedBy The IAM principal that requested the signing job.
         * 
         * @return builder
         * 
         */
        public Builder requestedBy(@Nullable Output<String> requestedBy) {
            $.requestedBy = requestedBy;
            return this;
        }

        /**
         * @param requestedBy The IAM principal that requested the signing job.
         * 
         * @return builder
         * 
         */
        public Builder requestedBy(String requestedBy) {
            return requestedBy(Output.of(requestedBy));
        }

        /**
         * @param revocationRecords A revocation record if the signature generated by the signing job has been revoked. Contains a timestamp and the ID of the IAM entity that revoked the signature.
         * 
         * @return builder
         * 
         */
        public Builder revocationRecords(@Nullable Output<List<SigningJobRevocationRecordArgs>> revocationRecords) {
            $.revocationRecords = revocationRecords;
            return this;
        }

        /**
         * @param revocationRecords A revocation record if the signature generated by the signing job has been revoked. Contains a timestamp and the ID of the IAM entity that revoked the signature.
         * 
         * @return builder
         * 
         */
        public Builder revocationRecords(List<SigningJobRevocationRecordArgs> revocationRecords) {
            return revocationRecords(Output.of(revocationRecords));
        }

        /**
         * @param revocationRecords A revocation record if the signature generated by the signing job has been revoked. Contains a timestamp and the ID of the IAM entity that revoked the signature.
         * 
         * @return builder
         * 
         */
        public Builder revocationRecords(SigningJobRevocationRecordArgs... revocationRecords) {
            return revocationRecords(List.of(revocationRecords));
        }

        /**
         * @param signatureExpiresAt The time when the signature of a signing job expires.
         * 
         * @return builder
         * 
         */
        public Builder signatureExpiresAt(@Nullable Output<String> signatureExpiresAt) {
            $.signatureExpiresAt = signatureExpiresAt;
            return this;
        }

        /**
         * @param signatureExpiresAt The time when the signature of a signing job expires.
         * 
         * @return builder
         * 
         */
        public Builder signatureExpiresAt(String signatureExpiresAt) {
            return signatureExpiresAt(Output.of(signatureExpiresAt));
        }

        /**
         * @param signedObjects Name of the S3 bucket where the signed code image is saved by code signing.
         * 
         * @return builder
         * 
         */
        public Builder signedObjects(@Nullable Output<List<SigningJobSignedObjectArgs>> signedObjects) {
            $.signedObjects = signedObjects;
            return this;
        }

        /**
         * @param signedObjects Name of the S3 bucket where the signed code image is saved by code signing.
         * 
         * @return builder
         * 
         */
        public Builder signedObjects(List<SigningJobSignedObjectArgs> signedObjects) {
            return signedObjects(Output.of(signedObjects));
        }

        /**
         * @param signedObjects Name of the S3 bucket where the signed code image is saved by code signing.
         * 
         * @return builder
         * 
         */
        public Builder signedObjects(SigningJobSignedObjectArgs... signedObjects) {
            return signedObjects(List.of(signedObjects));
        }

        /**
         * @param source The S3 bucket that contains the object to sign. See Source below for details.
         * 
         * @return builder
         * 
         */
        public Builder source(@Nullable Output<SigningJobSourceArgs> source) {
            $.source = source;
            return this;
        }

        /**
         * @param source The S3 bucket that contains the object to sign. See Source below for details.
         * 
         * @return builder
         * 
         */
        public Builder source(SigningJobSourceArgs source) {
            return source(Output.of(source));
        }

        /**
         * @param status Status of the signing job.
         * 
         * @return builder
         * 
         */
        public Builder status(@Nullable Output<String> status) {
            $.status = status;
            return this;
        }

        /**
         * @param status Status of the signing job.
         * 
         * @return builder
         * 
         */
        public Builder status(String status) {
            return status(Output.of(status));
        }

        /**
         * @param statusReason String value that contains the status reason.
         * 
         * @return builder
         * 
         */
        public Builder statusReason(@Nullable Output<String> statusReason) {
            $.statusReason = statusReason;
            return this;
        }

        /**
         * @param statusReason String value that contains the status reason.
         * 
         * @return builder
         * 
         */
        public Builder statusReason(String statusReason) {
            return statusReason(Output.of(statusReason));
        }

        public SigningJobState build() {
            return $;
        }
    }

}
