// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.signer;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class SigningProfilePermissionArgs extends com.pulumi.resources.ResourceArgs {

    public static final SigningProfilePermissionArgs Empty = new SigningProfilePermissionArgs();

    /**
     * An AWS Signer action permitted as part of cross-account permissions. Valid values: `signer:StartSigningJob`, `signer:GetSigningProfile`, or `signer:RevokeSignature`.
     * 
     */
    @Import(name="action", required=true)
    private Output<String> action;

    /**
     * @return An AWS Signer action permitted as part of cross-account permissions. Valid values: `signer:StartSigningJob`, `signer:GetSigningProfile`, or `signer:RevokeSignature`.
     * 
     */
    public Output<String> action() {
        return this.action;
    }

    /**
     * The AWS principal to be granted a cross-account permission.
     * 
     */
    @Import(name="principal", required=true)
    private Output<String> principal;

    /**
     * @return The AWS principal to be granted a cross-account permission.
     * 
     */
    public Output<String> principal() {
        return this.principal;
    }

    /**
     * Name of the signing profile to add the cross-account permissions.
     * 
     */
    @Import(name="profileName", required=true)
    private Output<String> profileName;

    /**
     * @return Name of the signing profile to add the cross-account permissions.
     * 
     */
    public Output<String> profileName() {
        return this.profileName;
    }

    /**
     * The signing profile version that a permission applies to.
     * 
     */
    @Import(name="profileVersion")
    private @Nullable Output<String> profileVersion;

    /**
     * @return The signing profile version that a permission applies to.
     * 
     */
    public Optional<Output<String>> profileVersion() {
        return Optional.ofNullable(this.profileVersion);
    }

    /**
     * A unique statement identifier. By default generated by the provider.
     * 
     */
    @Import(name="statementId")
    private @Nullable Output<String> statementId;

    /**
     * @return A unique statement identifier. By default generated by the provider.
     * 
     */
    public Optional<Output<String>> statementId() {
        return Optional.ofNullable(this.statementId);
    }

    /**
     * A statement identifier prefix. The provider will generate a unique suffix. Conflicts with `statement_id`.
     * 
     */
    @Import(name="statementIdPrefix")
    private @Nullable Output<String> statementIdPrefix;

    /**
     * @return A statement identifier prefix. The provider will generate a unique suffix. Conflicts with `statement_id`.
     * 
     */
    public Optional<Output<String>> statementIdPrefix() {
        return Optional.ofNullable(this.statementIdPrefix);
    }

    private SigningProfilePermissionArgs() {}

    private SigningProfilePermissionArgs(SigningProfilePermissionArgs $) {
        this.action = $.action;
        this.principal = $.principal;
        this.profileName = $.profileName;
        this.profileVersion = $.profileVersion;
        this.statementId = $.statementId;
        this.statementIdPrefix = $.statementIdPrefix;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(SigningProfilePermissionArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private SigningProfilePermissionArgs $;

        public Builder() {
            $ = new SigningProfilePermissionArgs();
        }

        public Builder(SigningProfilePermissionArgs defaults) {
            $ = new SigningProfilePermissionArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param action An AWS Signer action permitted as part of cross-account permissions. Valid values: `signer:StartSigningJob`, `signer:GetSigningProfile`, or `signer:RevokeSignature`.
         * 
         * @return builder
         * 
         */
        public Builder action(Output<String> action) {
            $.action = action;
            return this;
        }

        /**
         * @param action An AWS Signer action permitted as part of cross-account permissions. Valid values: `signer:StartSigningJob`, `signer:GetSigningProfile`, or `signer:RevokeSignature`.
         * 
         * @return builder
         * 
         */
        public Builder action(String action) {
            return action(Output.of(action));
        }

        /**
         * @param principal The AWS principal to be granted a cross-account permission.
         * 
         * @return builder
         * 
         */
        public Builder principal(Output<String> principal) {
            $.principal = principal;
            return this;
        }

        /**
         * @param principal The AWS principal to be granted a cross-account permission.
         * 
         * @return builder
         * 
         */
        public Builder principal(String principal) {
            return principal(Output.of(principal));
        }

        /**
         * @param profileName Name of the signing profile to add the cross-account permissions.
         * 
         * @return builder
         * 
         */
        public Builder profileName(Output<String> profileName) {
            $.profileName = profileName;
            return this;
        }

        /**
         * @param profileName Name of the signing profile to add the cross-account permissions.
         * 
         * @return builder
         * 
         */
        public Builder profileName(String profileName) {
            return profileName(Output.of(profileName));
        }

        /**
         * @param profileVersion The signing profile version that a permission applies to.
         * 
         * @return builder
         * 
         */
        public Builder profileVersion(@Nullable Output<String> profileVersion) {
            $.profileVersion = profileVersion;
            return this;
        }

        /**
         * @param profileVersion The signing profile version that a permission applies to.
         * 
         * @return builder
         * 
         */
        public Builder profileVersion(String profileVersion) {
            return profileVersion(Output.of(profileVersion));
        }

        /**
         * @param statementId A unique statement identifier. By default generated by the provider.
         * 
         * @return builder
         * 
         */
        public Builder statementId(@Nullable Output<String> statementId) {
            $.statementId = statementId;
            return this;
        }

        /**
         * @param statementId A unique statement identifier. By default generated by the provider.
         * 
         * @return builder
         * 
         */
        public Builder statementId(String statementId) {
            return statementId(Output.of(statementId));
        }

        /**
         * @param statementIdPrefix A statement identifier prefix. The provider will generate a unique suffix. Conflicts with `statement_id`.
         * 
         * @return builder
         * 
         */
        public Builder statementIdPrefix(@Nullable Output<String> statementIdPrefix) {
            $.statementIdPrefix = statementIdPrefix;
            return this;
        }

        /**
         * @param statementIdPrefix A statement identifier prefix. The provider will generate a unique suffix. Conflicts with `statement_id`.
         * 
         * @return builder
         * 
         */
        public Builder statementIdPrefix(String statementIdPrefix) {
            return statementIdPrefix(Output.of(statementIdPrefix));
        }

        public SigningProfilePermissionArgs build() {
            $.action = Objects.requireNonNull($.action, "expected parameter 'action' to be non-null");
            $.principal = Objects.requireNonNull($.principal, "expected parameter 'principal' to be non-null");
            $.profileName = Objects.requireNonNull($.profileName, "expected parameter 'profileName' to be non-null");
            return $;
        }
    }

}
