// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.signer;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.signer.SigningProfileArgs;
import com.pulumi.aws.signer.inputs.SigningProfileState;
import com.pulumi.aws.signer.outputs.SigningProfileRevocationRecord;
import com.pulumi.aws.signer.outputs.SigningProfileSignatureValidityPeriod;
import com.pulumi.aws.signer.outputs.SigningProfileSigningMaterial;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Creates a Signer Signing Profile. A signing profile contains information about the code signing configuration parameters that can be used by a given code signing user.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.signer.SigningProfile;
 * import com.pulumi.aws.signer.SigningProfileArgs;
 * import com.pulumi.aws.signer.inputs.SigningProfileSignatureValidityPeriodArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var testSp = new SigningProfile(&#34;testSp&#34;, SigningProfileArgs.builder()        
 *             .platformId(&#34;AWSLambda-SHA384-ECDSA&#34;)
 *             .build());
 * 
 *         var prodSp = new SigningProfile(&#34;prodSp&#34;, SigningProfileArgs.builder()        
 *             .namePrefix(&#34;prod_sp_&#34;)
 *             .platformId(&#34;AWSLambda-SHA384-ECDSA&#34;)
 *             .signatureValidityPeriod(SigningProfileSignatureValidityPeriodArgs.builder()
 *                 .type(&#34;YEARS&#34;)
 *                 .value(5)
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry(&#34;tag1&#34;, &#34;value1&#34;),
 *                 Map.entry(&#34;tag2&#34;, &#34;value2&#34;)
 *             ))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Signer signing profiles using the `name`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:signer/signingProfile:SigningProfile test_signer_signing_profile test_sp_DdW3Mk1foYL88fajut4mTVFGpuwfd4ACO6ANL0D1uIj7lrn8adK
 * ```
 * 
 */
@ResourceType(type="aws:signer/signingProfile:SigningProfile")
public class SigningProfile extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name (ARN) for the signing profile.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) for the signing profile.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * A unique signing profile name. By default generated by the provider. Signing profile names are immutable and cannot be reused after canceled.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return A unique signing profile name. By default generated by the provider. Signing profile names are immutable and cannot be reused after canceled.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * A signing profile name prefix. The provider will generate a unique suffix. Conflicts with `name`.
     * 
     */
    @Export(name="namePrefix", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> namePrefix;

    /**
     * @return A signing profile name prefix. The provider will generate a unique suffix. Conflicts with `name`.
     * 
     */
    public Output<Optional<String>> namePrefix() {
        return Codegen.optional(this.namePrefix);
    }
    /**
     * A human-readable name for the signing platform associated with the signing profile.
     * 
     */
    @Export(name="platformDisplayName", refs={String.class}, tree="[0]")
    private Output<String> platformDisplayName;

    /**
     * @return A human-readable name for the signing platform associated with the signing profile.
     * 
     */
    public Output<String> platformDisplayName() {
        return this.platformDisplayName;
    }
    /**
     * The ID of the platform that is used by the target signing profile.
     * 
     */
    @Export(name="platformId", refs={String.class}, tree="[0]")
    private Output<String> platformId;

    /**
     * @return The ID of the platform that is used by the target signing profile.
     * 
     */
    public Output<String> platformId() {
        return this.platformId;
    }
    /**
     * Revocation information for a signing profile.
     * 
     */
    @Export(name="revocationRecords", refs={List.class,SigningProfileRevocationRecord.class}, tree="[0,1]")
    private Output<List<SigningProfileRevocationRecord>> revocationRecords;

    /**
     * @return Revocation information for a signing profile.
     * 
     */
    public Output<List<SigningProfileRevocationRecord>> revocationRecords() {
        return this.revocationRecords;
    }
    /**
     * The validity period for a signing job.
     * 
     */
    @Export(name="signatureValidityPeriod", refs={SigningProfileSignatureValidityPeriod.class}, tree="[0]")
    private Output<SigningProfileSignatureValidityPeriod> signatureValidityPeriod;

    /**
     * @return The validity period for a signing job.
     * 
     */
    public Output<SigningProfileSignatureValidityPeriod> signatureValidityPeriod() {
        return this.signatureValidityPeriod;
    }
    @Export(name="signingMaterial", refs={SigningProfileSigningMaterial.class}, tree="[0]")
    private Output<SigningProfileSigningMaterial> signingMaterial;

    public Output<SigningProfileSigningMaterial> signingMaterial() {
        return this.signingMaterial;
    }
    /**
     * The status of the target signing profile.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output<String> status;

    /**
     * @return The status of the target signing profile.
     * 
     */
    public Output<String> status() {
        return this.status;
    }
    /**
     * A list of tags associated with the signing profile. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A list of tags associated with the signing profile. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * The current version of the signing profile.
     * 
     */
    @Export(name="version", refs={String.class}, tree="[0]")
    private Output<String> version;

    /**
     * @return The current version of the signing profile.
     * 
     */
    public Output<String> version() {
        return this.version;
    }
    /**
     * The signing profile ARN, including the profile version.
     * 
     */
    @Export(name="versionArn", refs={String.class}, tree="[0]")
    private Output<String> versionArn;

    /**
     * @return The signing profile ARN, including the profile version.
     * 
     */
    public Output<String> versionArn() {
        return this.versionArn;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public SigningProfile(String name) {
        this(name, SigningProfileArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public SigningProfile(String name, SigningProfileArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public SigningProfile(String name, SigningProfileArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:signer/signingProfile:SigningProfile", name, args == null ? SigningProfileArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private SigningProfile(String name, Output<String> id, @Nullable SigningProfileState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:signer/signingProfile:SigningProfile", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static SigningProfile get(String name, Output<String> id, @Nullable SigningProfileState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new SigningProfile(name, id, state, options);
    }
}
