// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.shield;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.shield.DrtAccessRoleArnAssociationArgs;
import com.pulumi.aws.shield.inputs.DrtAccessRoleArnAssociationState;
import com.pulumi.aws.shield.outputs.DrtAccessRoleArnAssociationTimeouts;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Authorizes the Shield Response Team (SRT) using the specified role, to access your AWS account to assist with DDoS attack mitigation during potential attacks. For more information see [Configure AWS SRT Support](https://docs.aws.amazon.com/waf/latest/developerguide/authorize-srt.html)
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.shield.DrtAccessRoleArnAssociation;
 * import com.pulumi.aws.shield.DrtAccessRoleArnAssociationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var testRole = new Role(&#34;testRole&#34;, RoleArgs.builder()        
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty(&#34;Version&#34;, &#34;2012-10-17&#34;),
 *                     jsonProperty(&#34;Statement&#34;, jsonArray(jsonObject(
 *                         jsonProperty(&#34;Sid&#34;, &#34;&#34;),
 *                         jsonProperty(&#34;Effect&#34;, &#34;Allow&#34;),
 *                         jsonProperty(&#34;Principal&#34;, jsonObject(
 *                             jsonProperty(&#34;Service&#34;, &#34;drt.shield.amazonaws.com&#34;)
 *                         )),
 *                         jsonProperty(&#34;Action&#34;, &#34;sts:AssumeRole&#34;)
 *                     )))
 *                 )))
 *             .build());
 * 
 *         var testRolePolicyAttachment = new RolePolicyAttachment(&#34;testRolePolicyAttachment&#34;, RolePolicyAttachmentArgs.builder()        
 *             .role(testRole.name())
 *             .policyArn(&#34;arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy&#34;)
 *             .build());
 * 
 *         var testDrtAccessRoleArnAssociation = new DrtAccessRoleArnAssociation(&#34;testDrtAccessRoleArnAssociation&#34;, DrtAccessRoleArnAssociationArgs.builder()        
 *             .roleArn(testRole.arn())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 */
@ResourceType(type="aws:shield/drtAccessRoleArnAssociation:DrtAccessRoleArnAssociation")
public class DrtAccessRoleArnAssociation extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name (ARN) of the role the SRT will use to access your AWS account. Prior to making the AssociateDRTRole request, you must attach the `AWSShieldDRTAccessPolicy` managed policy to this role.
     * 
     */
    @Export(name="roleArn", refs={String.class}, tree="[0]")
    private Output<String> roleArn;

    /**
     * @return The Amazon Resource Name (ARN) of the role the SRT will use to access your AWS account. Prior to making the AssociateDRTRole request, you must attach the `AWSShieldDRTAccessPolicy` managed policy to this role.
     * 
     */
    public Output<String> roleArn() {
        return this.roleArn;
    }
    @Export(name="timeouts", refs={DrtAccessRoleArnAssociationTimeouts.class}, tree="[0]")
    private Output</* @Nullable */ DrtAccessRoleArnAssociationTimeouts> timeouts;

    public Output<Optional<DrtAccessRoleArnAssociationTimeouts>> timeouts() {
        return Codegen.optional(this.timeouts);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public DrtAccessRoleArnAssociation(String name) {
        this(name, DrtAccessRoleArnAssociationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public DrtAccessRoleArnAssociation(String name, DrtAccessRoleArnAssociationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public DrtAccessRoleArnAssociation(String name, DrtAccessRoleArnAssociationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:shield/drtAccessRoleArnAssociation:DrtAccessRoleArnAssociation", name, args == null ? DrtAccessRoleArnAssociationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private DrtAccessRoleArnAssociation(String name, Output<String> id, @Nullable DrtAccessRoleArnAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:shield/drtAccessRoleArnAssociation:DrtAccessRoleArnAssociation", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static DrtAccessRoleArnAssociation get(String name, Output<String> id, @Nullable DrtAccessRoleArnAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new DrtAccessRoleArnAssociation(name, id, state, options);
    }
}
