// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.sfn;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.sfn.AliasArgs;
import com.pulumi.aws.sfn.inputs.AliasState;
import com.pulumi.aws.sfn.outputs.AliasRoutingConfiguration;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a Step Function State Machine Alias.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sfn.Alias;
 * import com.pulumi.aws.sfn.AliasArgs;
 * import com.pulumi.aws.sfn.inputs.AliasRoutingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var sfnAlias = new Alias(&#34;sfnAlias&#34;, AliasArgs.builder()        
 *             .routingConfigurations(AliasRoutingConfigurationArgs.builder()
 *                 .stateMachineVersionArn(aws_sfn_state_machine.sfn_test().state_machine_version_arn())
 *                 .weight(100)
 *                 .build())
 *             .build());
 * 
 *         var mySfnAlias = new Alias(&#34;mySfnAlias&#34;, AliasArgs.builder()        
 *             .routingConfigurations(            
 *                 AliasRoutingConfigurationArgs.builder()
 *                     .stateMachineVersionArn(&#34;arn:aws:states:us-east-1:12345:stateMachine:demo:3&#34;)
 *                     .weight(50)
 *                     .build(),
 *                 AliasRoutingConfigurationArgs.builder()
 *                     .stateMachineVersionArn(&#34;arn:aws:states:us-east-1:12345:stateMachine:demo:2&#34;)
 *                     .weight(50)
 *                     .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import SFN (Step Functions) Alias using the `arn`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:sfn/alias:Alias foo arn:aws:states:us-east-1:123456789098:stateMachine:myStateMachine:foo
 * ```
 * 
 */
@ResourceType(type="aws:sfn/alias:Alias")
public class Alias extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name (ARN) identifying your state machine alias.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) identifying your state machine alias.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The date the state machine alias was created.
     * 
     */
    @Export(name="creationDate", refs={String.class}, tree="[0]")
    private Output<String> creationDate;

    /**
     * @return The date the state machine alias was created.
     * 
     */
    public Output<String> creationDate() {
        return this.creationDate;
    }
    /**
     * Description of the alias.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return Description of the alias.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * Name for the alias you are creating.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Name for the alias you are creating.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * The StateMachine alias&#39; route configuration settings. Fields documented below
     * 
     */
    @Export(name="routingConfigurations", refs={List.class,AliasRoutingConfiguration.class}, tree="[0,1]")
    private Output<List<AliasRoutingConfiguration>> routingConfigurations;

    /**
     * @return The StateMachine alias&#39; route configuration settings. Fields documented below
     * 
     */
    public Output<List<AliasRoutingConfiguration>> routingConfigurations() {
        return this.routingConfigurations;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Alias(String name) {
        this(name, AliasArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Alias(String name, AliasArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Alias(String name, AliasArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sfn/alias:Alias", name, args == null ? AliasArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Alias(String name, Output<String> id, @Nullable AliasState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sfn/alias:Alias", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Alias get(String name, Output<String> id, @Nullable AliasState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Alias(name, id, state, options);
    }
}
