// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.sesv2.outputs;

import com.pulumi.core.annotations.CustomType;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class EmailIdentityDkimSigningAttributes {
    /**
     * @return [Easy DKIM] The key length of the DKIM key pair in use.
     * 
     */
    private @Nullable String currentSigningKeyLength;
    /**
     * @return [Bring Your Own DKIM] A private key that&#39;s used to generate a DKIM signature. The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using base64 encoding.
     * 
     * &gt; **NOTE:** You have to delete the first and last lines (&#39;-----BEGIN PRIVATE KEY-----&#39; and &#39;-----END PRIVATE KEY-----&#39;, respectively) of the generated private key. Additionally, you have to remove the line breaks in the generated private key. The resulting value is a string of characters with no spaces or line breaks.
     * 
     */
    private @Nullable String domainSigningPrivateKey;
    /**
     * @return [Bring Your Own DKIM] A string that&#39;s used to identify a public key in the DNS configuration for a domain.
     * 
     */
    private @Nullable String domainSigningSelector;
    /**
     * @return [Easy DKIM] The last time a key pair was generated for this identity.
     * 
     */
    private @Nullable String lastKeyGenerationTimestamp;
    /**
     * @return [Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day. Valid values: `RSA_1024_BIT`, `RSA_2048_BIT`.
     * 
     */
    private @Nullable String nextSigningKeyLength;
    /**
     * @return A string that indicates how DKIM was configured for the identity. `AWS_SES` indicates that DKIM was configured for the identity by using Easy DKIM. `EXTERNAL` indicates that DKIM was configured for the identity by using Bring Your Own DKIM (BYODKIM).
     * 
     */
    private @Nullable String signingAttributesOrigin;
    /**
     * @return Describes whether or not Amazon SES has successfully located the DKIM records in the DNS records for the domain. See the [AWS SES API v2 Reference](https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_DkimAttributes.html#SES-Type-DkimAttributes-Status) for supported statuses.
     * 
     */
    private @Nullable String status;
    /**
     * @return If you used Easy DKIM to configure DKIM authentication for the domain, then this object contains a set of unique strings that you use to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon SES detects these records in the DNS configuration for your domain, the DKIM authentication process is complete. If you configured DKIM authentication for the domain by providing your own public-private key pair, then this object contains the selector for the public key.
     * 
     */
    private @Nullable List<String> tokens;

    private EmailIdentityDkimSigningAttributes() {}
    /**
     * @return [Easy DKIM] The key length of the DKIM key pair in use.
     * 
     */
    public Optional<String> currentSigningKeyLength() {
        return Optional.ofNullable(this.currentSigningKeyLength);
    }
    /**
     * @return [Bring Your Own DKIM] A private key that&#39;s used to generate a DKIM signature. The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using base64 encoding.
     * 
     * &gt; **NOTE:** You have to delete the first and last lines (&#39;-----BEGIN PRIVATE KEY-----&#39; and &#39;-----END PRIVATE KEY-----&#39;, respectively) of the generated private key. Additionally, you have to remove the line breaks in the generated private key. The resulting value is a string of characters with no spaces or line breaks.
     * 
     */
    public Optional<String> domainSigningPrivateKey() {
        return Optional.ofNullable(this.domainSigningPrivateKey);
    }
    /**
     * @return [Bring Your Own DKIM] A string that&#39;s used to identify a public key in the DNS configuration for a domain.
     * 
     */
    public Optional<String> domainSigningSelector() {
        return Optional.ofNullable(this.domainSigningSelector);
    }
    /**
     * @return [Easy DKIM] The last time a key pair was generated for this identity.
     * 
     */
    public Optional<String> lastKeyGenerationTimestamp() {
        return Optional.ofNullable(this.lastKeyGenerationTimestamp);
    }
    /**
     * @return [Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day. Valid values: `RSA_1024_BIT`, `RSA_2048_BIT`.
     * 
     */
    public Optional<String> nextSigningKeyLength() {
        return Optional.ofNullable(this.nextSigningKeyLength);
    }
    /**
     * @return A string that indicates how DKIM was configured for the identity. `AWS_SES` indicates that DKIM was configured for the identity by using Easy DKIM. `EXTERNAL` indicates that DKIM was configured for the identity by using Bring Your Own DKIM (BYODKIM).
     * 
     */
    public Optional<String> signingAttributesOrigin() {
        return Optional.ofNullable(this.signingAttributesOrigin);
    }
    /**
     * @return Describes whether or not Amazon SES has successfully located the DKIM records in the DNS records for the domain. See the [AWS SES API v2 Reference](https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_DkimAttributes.html#SES-Type-DkimAttributes-Status) for supported statuses.
     * 
     */
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }
    /**
     * @return If you used Easy DKIM to configure DKIM authentication for the domain, then this object contains a set of unique strings that you use to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon SES detects these records in the DNS configuration for your domain, the DKIM authentication process is complete. If you configured DKIM authentication for the domain by providing your own public-private key pair, then this object contains the selector for the public key.
     * 
     */
    public List<String> tokens() {
        return this.tokens == null ? List.of() : this.tokens;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EmailIdentityDkimSigningAttributes defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable String currentSigningKeyLength;
        private @Nullable String domainSigningPrivateKey;
        private @Nullable String domainSigningSelector;
        private @Nullable String lastKeyGenerationTimestamp;
        private @Nullable String nextSigningKeyLength;
        private @Nullable String signingAttributesOrigin;
        private @Nullable String status;
        private @Nullable List<String> tokens;
        public Builder() {}
        public Builder(EmailIdentityDkimSigningAttributes defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.currentSigningKeyLength = defaults.currentSigningKeyLength;
    	      this.domainSigningPrivateKey = defaults.domainSigningPrivateKey;
    	      this.domainSigningSelector = defaults.domainSigningSelector;
    	      this.lastKeyGenerationTimestamp = defaults.lastKeyGenerationTimestamp;
    	      this.nextSigningKeyLength = defaults.nextSigningKeyLength;
    	      this.signingAttributesOrigin = defaults.signingAttributesOrigin;
    	      this.status = defaults.status;
    	      this.tokens = defaults.tokens;
        }

        @CustomType.Setter
        public Builder currentSigningKeyLength(@Nullable String currentSigningKeyLength) {
            this.currentSigningKeyLength = currentSigningKeyLength;
            return this;
        }
        @CustomType.Setter
        public Builder domainSigningPrivateKey(@Nullable String domainSigningPrivateKey) {
            this.domainSigningPrivateKey = domainSigningPrivateKey;
            return this;
        }
        @CustomType.Setter
        public Builder domainSigningSelector(@Nullable String domainSigningSelector) {
            this.domainSigningSelector = domainSigningSelector;
            return this;
        }
        @CustomType.Setter
        public Builder lastKeyGenerationTimestamp(@Nullable String lastKeyGenerationTimestamp) {
            this.lastKeyGenerationTimestamp = lastKeyGenerationTimestamp;
            return this;
        }
        @CustomType.Setter
        public Builder nextSigningKeyLength(@Nullable String nextSigningKeyLength) {
            this.nextSigningKeyLength = nextSigningKeyLength;
            return this;
        }
        @CustomType.Setter
        public Builder signingAttributesOrigin(@Nullable String signingAttributesOrigin) {
            this.signingAttributesOrigin = signingAttributesOrigin;
            return this;
        }
        @CustomType.Setter
        public Builder status(@Nullable String status) {
            this.status = status;
            return this;
        }
        @CustomType.Setter
        public Builder tokens(@Nullable List<String> tokens) {
            this.tokens = tokens;
            return this;
        }
        public Builder tokens(String... tokens) {
            return tokens(List.of(tokens));
        }
        public EmailIdentityDkimSigningAttributes build() {
            final var o = new EmailIdentityDkimSigningAttributes();
            o.currentSigningKeyLength = currentSigningKeyLength;
            o.domainSigningPrivateKey = domainSigningPrivateKey;
            o.domainSigningSelector = domainSigningSelector;
            o.lastKeyGenerationTimestamp = lastKeyGenerationTimestamp;
            o.nextSigningKeyLength = nextSigningKeyLength;
            o.signingAttributesOrigin = signingAttributesOrigin;
            o.status = status;
            o.tokens = tokens;
            return o;
        }
    }
}
