// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.sesv2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.sesv2.EmailIdentityMailFromAttributesArgs;
import com.pulumi.aws.sesv2.inputs.EmailIdentityMailFromAttributesState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Email Identity Mail From Attributes.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.EmailIdentity;
 * import com.pulumi.aws.sesv2.EmailIdentityArgs;
 * import com.pulumi.aws.sesv2.EmailIdentityMailFromAttributes;
 * import com.pulumi.aws.sesv2.EmailIdentityMailFromAttributesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleEmailIdentity = new EmailIdentity(&#34;exampleEmailIdentity&#34;, EmailIdentityArgs.builder()        
 *             .emailIdentity(&#34;example.com&#34;)
 *             .build());
 * 
 *         var exampleEmailIdentityMailFromAttributes = new EmailIdentityMailFromAttributes(&#34;exampleEmailIdentityMailFromAttributes&#34;, EmailIdentityMailFromAttributesArgs.builder()        
 *             .emailIdentity(exampleEmailIdentity.emailIdentity())
 *             .behaviorOnMxFailure(&#34;REJECT_MESSAGE&#34;)
 *             .mailFromDomain(exampleEmailIdentity.emailIdentity().applyValue(emailIdentity -&gt; String.format(&#34;subdomain.%s&#34;, emailIdentity)))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import SESv2 (Simple Email V2) Email Identity Mail From Attributes using the `email_identity`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:sesv2/emailIdentityMailFromAttributes:EmailIdentityMailFromAttributes example example.com
 * ```
 * 
 */
@ResourceType(type="aws:sesv2/emailIdentityMailFromAttributes:EmailIdentityMailFromAttributes")
public class EmailIdentityMailFromAttributes extends com.pulumi.resources.CustomResource {
    /**
     * The action to take if the required MX record isn&#39;t found when you send an email. Valid values: `USE_DEFAULT_VALUE`, `REJECT_MESSAGE`.
     * 
     */
    @Export(name="behaviorOnMxFailure", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> behaviorOnMxFailure;

    /**
     * @return The action to take if the required MX record isn&#39;t found when you send an email. Valid values: `USE_DEFAULT_VALUE`, `REJECT_MESSAGE`.
     * 
     */
    public Output<Optional<String>> behaviorOnMxFailure() {
        return Codegen.optional(this.behaviorOnMxFailure);
    }
    /**
     * The verified email identity.
     * 
     */
    @Export(name="emailIdentity", refs={String.class}, tree="[0]")
    private Output<String> emailIdentity;

    /**
     * @return The verified email identity.
     * 
     */
    public Output<String> emailIdentity() {
        return this.emailIdentity;
    }
    /**
     * The custom MAIL FROM domain that you want the verified identity to use. Required if `behavior_on_mx_failure` is `REJECT_MESSAGE`.
     * 
     */
    @Export(name="mailFromDomain", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> mailFromDomain;

    /**
     * @return The custom MAIL FROM domain that you want the verified identity to use. Required if `behavior_on_mx_failure` is `REJECT_MESSAGE`.
     * 
     */
    public Output<Optional<String>> mailFromDomain() {
        return Codegen.optional(this.mailFromDomain);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public EmailIdentityMailFromAttributes(String name) {
        this(name, EmailIdentityMailFromAttributesArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public EmailIdentityMailFromAttributes(String name, EmailIdentityMailFromAttributesArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public EmailIdentityMailFromAttributes(String name, EmailIdentityMailFromAttributesArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sesv2/emailIdentityMailFromAttributes:EmailIdentityMailFromAttributes", name, args == null ? EmailIdentityMailFromAttributesArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private EmailIdentityMailFromAttributes(String name, Output<String> id, @Nullable EmailIdentityMailFromAttributesState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sesv2/emailIdentityMailFromAttributes:EmailIdentityMailFromAttributes", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static EmailIdentityMailFromAttributes get(String name, Output<String> id, @Nullable EmailIdentityMailFromAttributesState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new EmailIdentityMailFromAttributes(name, id, state, options);
    }
}
