// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.sesv2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.sesv2.EmailIdentityArgs;
import com.pulumi.aws.sesv2.inputs.EmailIdentityState;
import com.pulumi.aws.sesv2.outputs.EmailIdentityDkimSigningAttributes;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Email Identity.
 * 
 * ## Example Usage
 * 
 * ### Basic Usage
 * ### Email Address Identity
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.EmailIdentity;
 * import com.pulumi.aws.sesv2.EmailIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new EmailIdentity(&#34;example&#34;, EmailIdentityArgs.builder()        
 *             .emailIdentity(&#34;testing@example.com&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Domain Identity
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.EmailIdentity;
 * import com.pulumi.aws.sesv2.EmailIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new EmailIdentity(&#34;example&#34;, EmailIdentityArgs.builder()        
 *             .emailIdentity(&#34;example.com&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Configuration Set
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ConfigurationSet;
 * import com.pulumi.aws.sesv2.ConfigurationSetArgs;
 * import com.pulumi.aws.sesv2.EmailIdentity;
 * import com.pulumi.aws.sesv2.EmailIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleConfigurationSet = new ConfigurationSet(&#34;exampleConfigurationSet&#34;, ConfigurationSetArgs.builder()        
 *             .configurationSetName(&#34;example&#34;)
 *             .build());
 * 
 *         var exampleEmailIdentity = new EmailIdentity(&#34;exampleEmailIdentity&#34;, EmailIdentityArgs.builder()        
 *             .emailIdentity(&#34;example.com&#34;)
 *             .configurationSetName(exampleConfigurationSet.configurationSetName())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### DKIM Signing Attributes (BYODKIM)
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.EmailIdentity;
 * import com.pulumi.aws.sesv2.EmailIdentityArgs;
 * import com.pulumi.aws.sesv2.inputs.EmailIdentityDkimSigningAttributesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new EmailIdentity(&#34;example&#34;, EmailIdentityArgs.builder()        
 *             .dkimSigningAttributes(EmailIdentityDkimSigningAttributesArgs.builder()
 *                 .domainSigningPrivateKey(&#34;MIIJKAIBAAKCAgEA2Se7p8zvnI4yh+Gh9j2rG5e2aRXjg03Y8saiupLnadPH9xvM...&#34;)
 *                 .domainSigningSelector(&#34;example&#34;)
 *                 .build())
 *             .emailIdentity(&#34;example.com&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import SESv2 (Simple Email V2) Email Identity using the `email_identity`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:sesv2/emailIdentity:EmailIdentity example example.com
 * ```
 * 
 */
@ResourceType(type="aws:sesv2/emailIdentity:EmailIdentity")
public class EmailIdentity extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the Email Identity.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the Email Identity.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The configuration set to use by default when sending from this identity. Note that any configuration set defined in the email sending request takes precedence.
     * 
     */
    @Export(name="configurationSetName", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> configurationSetName;

    /**
     * @return The configuration set to use by default when sending from this identity. Note that any configuration set defined in the email sending request takes precedence.
     * 
     */
    public Output<Optional<String>> configurationSetName() {
        return Codegen.optional(this.configurationSetName);
    }
    /**
     * The configuration of the DKIM authentication settings for an email domain identity.
     * 
     */
    @Export(name="dkimSigningAttributes", refs={EmailIdentityDkimSigningAttributes.class}, tree="[0]")
    private Output<EmailIdentityDkimSigningAttributes> dkimSigningAttributes;

    /**
     * @return The configuration of the DKIM authentication settings for an email domain identity.
     * 
     */
    public Output<EmailIdentityDkimSigningAttributes> dkimSigningAttributes() {
        return this.dkimSigningAttributes;
    }
    /**
     * The email address or domain to verify.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="emailIdentity", refs={String.class}, tree="[0]")
    private Output<String> emailIdentity;

    /**
     * @return The email address or domain to verify.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> emailIdentity() {
        return this.emailIdentity;
    }
    /**
     * The email identity type. Valid values: `EMAIL_ADDRESS`, `DOMAIN`.
     * 
     */
    @Export(name="identityType", refs={String.class}, tree="[0]")
    private Output<String> identityType;

    /**
     * @return The email identity type. Valid values: `EMAIL_ADDRESS`, `DOMAIN`.
     * 
     */
    public Output<String> identityType() {
        return this.identityType;
    }
    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * Specifies whether or not the identity is verified.
     * 
     */
    @Export(name="verifiedForSendingStatus", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> verifiedForSendingStatus;

    /**
     * @return Specifies whether or not the identity is verified.
     * 
     */
    public Output<Boolean> verifiedForSendingStatus() {
        return this.verifiedForSendingStatus;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public EmailIdentity(String name) {
        this(name, EmailIdentityArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public EmailIdentity(String name, EmailIdentityArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public EmailIdentity(String name, EmailIdentityArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sesv2/emailIdentity:EmailIdentity", name, args == null ? EmailIdentityArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private EmailIdentity(String name, Output<String> id, @Nullable EmailIdentityState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sesv2/emailIdentity:EmailIdentity", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static EmailIdentity get(String name, Output<String> id, @Nullable EmailIdentityState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new EmailIdentity(name, id, state, options);
    }
}
