// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.sesv2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.sesv2.ContactListArgs;
import com.pulumi.aws.sesv2.inputs.ContactListState;
import com.pulumi.aws.sesv2.outputs.ContactListTopic;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Contact List.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ContactList;
 * import com.pulumi.aws.sesv2.ContactListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new ContactList(&#34;example&#34;, ContactListArgs.builder()        
 *             .contactListName(&#34;example&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Extended Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ContactList;
 * import com.pulumi.aws.sesv2.ContactListArgs;
 * import com.pulumi.aws.sesv2.inputs.ContactListTopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new ContactList(&#34;example&#34;, ContactListArgs.builder()        
 *             .contactListName(&#34;example&#34;)
 *             .description(&#34;description&#34;)
 *             .topics(ContactListTopicArgs.builder()
 *                 .defaultSubscriptionStatus(&#34;OPT_IN&#34;)
 *                 .description(&#34;topic description&#34;)
 *                 .displayName(&#34;Example Topic&#34;)
 *                 .topicName(&#34;example-topic&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import SESv2 (Simple Email V2) Contact List using the `example_id_arg`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:sesv2/contactList:ContactList example example
 * ```
 * 
 */
@ResourceType(type="aws:sesv2/contactList:ContactList")
public class ContactList extends com.pulumi.resources.CustomResource {
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The name of the contact list.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="contactListName", refs={String.class}, tree="[0]")
    private Output<String> contactListName;

    /**
     * @return The name of the contact list.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> contactListName() {
        return this.contactListName;
    }
    /**
     * A timestamp noting when the contact list was created in ISO 8601 format.
     * 
     */
    @Export(name="createdTimestamp", refs={String.class}, tree="[0]")
    private Output<String> createdTimestamp;

    /**
     * @return A timestamp noting when the contact list was created in ISO 8601 format.
     * 
     */
    public Output<String> createdTimestamp() {
        return this.createdTimestamp;
    }
    /**
     * A description of what the contact list is about.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return A description of what the contact list is about.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * A timestamp noting the last time the contact list was updated in ISO 8601 format.
     * 
     */
    @Export(name="lastUpdatedTimestamp", refs={String.class}, tree="[0]")
    private Output<String> lastUpdatedTimestamp;

    /**
     * @return A timestamp noting the last time the contact list was updated in ISO 8601 format.
     * 
     */
    public Output<String> lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }
    /**
     * Key-value map of resource tags for the contact list. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags for the contact list. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * Configuration block(s) with topic for the contact list. Detailed below.
     * 
     */
    @Export(name="topics", refs={List.class,ContactListTopic.class}, tree="[0,1]")
    private Output</* @Nullable */ List<ContactListTopic>> topics;

    /**
     * @return Configuration block(s) with topic for the contact list. Detailed below.
     * 
     */
    public Output<Optional<List<ContactListTopic>>> topics() {
        return Codegen.optional(this.topics);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ContactList(String name) {
        this(name, ContactListArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ContactList(String name, ContactListArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ContactList(String name, ContactListArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sesv2/contactList:ContactList", name, args == null ? ContactListArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ContactList(String name, Output<String> id, @Nullable ContactListState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sesv2/contactList:ContactList", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ContactList get(String name, Output<String> id, @Nullable ContactListState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ContactList(name, id, state, options);
    }
}
