// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ses;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ses.TemplateArgs;
import com.pulumi.aws.ses.inputs.TemplateState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a resource to create a SES template.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.Template;
 * import com.pulumi.aws.ses.TemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var myTemplate = new Template(&#34;myTemplate&#34;, TemplateArgs.builder()        
 *             .html(&#34;&lt;h1&gt;Hello {{name}},&lt;/h1&gt;&lt;p&gt;Your favorite animal is {{favoriteanimal}}.&lt;/p&gt;&#34;)
 *             .subject(&#34;Greetings, {{name}}!&#34;)
 *             .text(&#34;&#34;&#34;
 * Hello {{name}},
 * Your favorite animal is {{favoriteanimal}}.
 *             &#34;&#34;&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import SES templates using the template name. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ses/template:Template MyTemplate MyTemplate
 * ```
 * 
 */
@ResourceType(type="aws:ses/template:Template")
public class Template extends com.pulumi.resources.CustomResource {
    /**
     * The ARN of the SES template
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The ARN of the SES template
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The HTML body of the email. Must be less than 500KB in size, including both the text and HTML parts.
     * 
     */
    @Export(name="html", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> html;

    /**
     * @return The HTML body of the email. Must be less than 500KB in size, including both the text and HTML parts.
     * 
     */
    public Output<Optional<String>> html() {
        return Codegen.optional(this.html);
    }
    /**
     * The name of the template. Cannot exceed 64 characters. You will refer to this name when you send email.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name of the template. Cannot exceed 64 characters. You will refer to this name when you send email.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * The subject line of the email.
     * 
     */
    @Export(name="subject", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> subject;

    /**
     * @return The subject line of the email.
     * 
     */
    public Output<Optional<String>> subject() {
        return Codegen.optional(this.subject);
    }
    /**
     * The email body that will be visible to recipients whose email clients do not display HTML. Must be less than 500KB in size, including both the text and HTML parts.
     * 
     */
    @Export(name="text", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> text;

    /**
     * @return The email body that will be visible to recipients whose email clients do not display HTML. Must be less than 500KB in size, including both the text and HTML parts.
     * 
     */
    public Output<Optional<String>> text() {
        return Codegen.optional(this.text);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Template(String name) {
        this(name, TemplateArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Template(String name, @Nullable TemplateArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Template(String name, @Nullable TemplateArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ses/template:Template", name, args == null ? TemplateArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Template(String name, Output<String> id, @Nullable TemplateState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ses/template:Template", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Template get(String name, Output<String> id, @Nullable TemplateState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Template(name, id, state, options);
    }
}
