// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ses;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class IdentityNotificationTopicArgs extends com.pulumi.resources.ResourceArgs {

    public static final IdentityNotificationTopicArgs Empty = new IdentityNotificationTopicArgs();

    /**
     * The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
     * 
     */
    @Import(name="identity", required=true)
    private Output<String> identity;

    /**
     * @return The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
     * 
     */
    public Output<String> identity() {
        return this.identity;
    }

    /**
     * Whether SES should include original email headers in SNS notifications of this type. `false` by default.
     * 
     */
    @Import(name="includeOriginalHeaders")
    private @Nullable Output<Boolean> includeOriginalHeaders;

    /**
     * @return Whether SES should include original email headers in SNS notifications of this type. `false` by default.
     * 
     */
    public Optional<Output<Boolean>> includeOriginalHeaders() {
        return Optional.ofNullable(this.includeOriginalHeaders);
    }

    /**
     * The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: `Bounce`, `Complaint` or `Delivery`.
     * 
     */
    @Import(name="notificationType", required=true)
    private Output<String> notificationType;

    /**
     * @return The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: `Bounce`, `Complaint` or `Delivery`.
     * 
     */
    public Output<String> notificationType() {
        return this.notificationType;
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to `&#34;&#34;` (an empty string) to disable publishing.
     * 
     */
    @Import(name="topicArn")
    private @Nullable Output<String> topicArn;

    /**
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to `&#34;&#34;` (an empty string) to disable publishing.
     * 
     */
    public Optional<Output<String>> topicArn() {
        return Optional.ofNullable(this.topicArn);
    }

    private IdentityNotificationTopicArgs() {}

    private IdentityNotificationTopicArgs(IdentityNotificationTopicArgs $) {
        this.identity = $.identity;
        this.includeOriginalHeaders = $.includeOriginalHeaders;
        this.notificationType = $.notificationType;
        this.topicArn = $.topicArn;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(IdentityNotificationTopicArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private IdentityNotificationTopicArgs $;

        public Builder() {
            $ = new IdentityNotificationTopicArgs();
        }

        public Builder(IdentityNotificationTopicArgs defaults) {
            $ = new IdentityNotificationTopicArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param identity The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
         * 
         * @return builder
         * 
         */
        public Builder identity(Output<String> identity) {
            $.identity = identity;
            return this;
        }

        /**
         * @param identity The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
         * 
         * @return builder
         * 
         */
        public Builder identity(String identity) {
            return identity(Output.of(identity));
        }

        /**
         * @param includeOriginalHeaders Whether SES should include original email headers in SNS notifications of this type. `false` by default.
         * 
         * @return builder
         * 
         */
        public Builder includeOriginalHeaders(@Nullable Output<Boolean> includeOriginalHeaders) {
            $.includeOriginalHeaders = includeOriginalHeaders;
            return this;
        }

        /**
         * @param includeOriginalHeaders Whether SES should include original email headers in SNS notifications of this type. `false` by default.
         * 
         * @return builder
         * 
         */
        public Builder includeOriginalHeaders(Boolean includeOriginalHeaders) {
            return includeOriginalHeaders(Output.of(includeOriginalHeaders));
        }

        /**
         * @param notificationType The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: `Bounce`, `Complaint` or `Delivery`.
         * 
         * @return builder
         * 
         */
        public Builder notificationType(Output<String> notificationType) {
            $.notificationType = notificationType;
            return this;
        }

        /**
         * @param notificationType The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: `Bounce`, `Complaint` or `Delivery`.
         * 
         * @return builder
         * 
         */
        public Builder notificationType(String notificationType) {
            return notificationType(Output.of(notificationType));
        }

        /**
         * @param topicArn The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to `&#34;&#34;` (an empty string) to disable publishing.
         * 
         * @return builder
         * 
         */
        public Builder topicArn(@Nullable Output<String> topicArn) {
            $.topicArn = topicArn;
            return this;
        }

        /**
         * @param topicArn The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to `&#34;&#34;` (an empty string) to disable publishing.
         * 
         * @return builder
         * 
         */
        public Builder topicArn(String topicArn) {
            return topicArn(Output.of(topicArn));
        }

        public IdentityNotificationTopicArgs build() {
            $.identity = Objects.requireNonNull($.identity, "expected parameter 'identity' to be non-null");
            $.notificationType = Objects.requireNonNull($.notificationType, "expected parameter 'notificationType' to be non-null");
            return $;
        }
    }

}
