// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ses;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ses.IdentityNotificationTopicArgs;
import com.pulumi.aws.ses.inputs.IdentityNotificationTopicState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing SES Identity Notification Topics
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.IdentityNotificationTopic;
 * import com.pulumi.aws.ses.IdentityNotificationTopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new IdentityNotificationTopic(&#34;test&#34;, IdentityNotificationTopicArgs.builder()        
 *             .topicArn(aws_sns_topic.example().arn())
 *             .notificationType(&#34;Bounce&#34;)
 *             .identity(aws_ses_domain_identity.example().domain())
 *             .includeOriginalHeaders(true)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * In TODO v1.5.0 and later, use an `import` block to import Identity Notification Topics using the ID of the record. The ID is made up as `IDENTITY|TYPE` where `IDENTITY` is the SES Identity and `TYPE` is the Notification Type. For exampleterraform import {
 * 
 *  to = aws_ses_identity_notification_topic.test
 * 
 *  id = &#34;example.com|Bounce&#34; } Using `TODO import`, import Identity Notification Topics using the ID of the record. The ID is made up as `IDENTITY|TYPE` where `IDENTITY` is the SES Identity and `TYPE` is the Notification Type. For exampleconsole % TODO import aws_ses_identity_notification_topic.test &#39;example.com|Bounce&#39;
 * 
 */
@ResourceType(type="aws:ses/identityNotificationTopic:IdentityNotificationTopic")
public class IdentityNotificationTopic extends com.pulumi.resources.CustomResource {
    /**
     * The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
     * 
     */
    @Export(name="identity", refs={String.class}, tree="[0]")
    private Output<String> identity;

    /**
     * @return The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
     * 
     */
    public Output<String> identity() {
        return this.identity;
    }
    /**
     * Whether SES should include original email headers in SNS notifications of this type. `false` by default.
     * 
     */
    @Export(name="includeOriginalHeaders", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> includeOriginalHeaders;

    /**
     * @return Whether SES should include original email headers in SNS notifications of this type. `false` by default.
     * 
     */
    public Output<Optional<Boolean>> includeOriginalHeaders() {
        return Codegen.optional(this.includeOriginalHeaders);
    }
    /**
     * The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: `Bounce`, `Complaint` or `Delivery`.
     * 
     */
    @Export(name="notificationType", refs={String.class}, tree="[0]")
    private Output<String> notificationType;

    /**
     * @return The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: `Bounce`, `Complaint` or `Delivery`.
     * 
     */
    public Output<String> notificationType() {
        return this.notificationType;
    }
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to `&#34;&#34;` (an empty string) to disable publishing.
     * 
     */
    @Export(name="topicArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> topicArn;

    /**
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to `&#34;&#34;` (an empty string) to disable publishing.
     * 
     */
    public Output<Optional<String>> topicArn() {
        return Codegen.optional(this.topicArn);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public IdentityNotificationTopic(String name) {
        this(name, IdentityNotificationTopicArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public IdentityNotificationTopic(String name, IdentityNotificationTopicArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public IdentityNotificationTopic(String name, IdentityNotificationTopicArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ses/identityNotificationTopic:IdentityNotificationTopic", name, args == null ? IdentityNotificationTopicArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private IdentityNotificationTopic(String name, Output<String> id, @Nullable IdentityNotificationTopicState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ses/identityNotificationTopic:IdentityNotificationTopic", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static IdentityNotificationTopic get(String name, Output<String> id, @Nullable IdentityNotificationTopicState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new IdentityNotificationTopic(name, id, state, options);
    }
}
