// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ses;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ses.EmailIdentityArgs;
import com.pulumi.aws.ses.inputs.EmailIdentityState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Provides an SES email identity resource
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.EmailIdentity;
 * import com.pulumi.aws.ses.EmailIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new EmailIdentity(&#34;example&#34;, EmailIdentityArgs.builder()        
 *             .email(&#34;email@example.com&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import SES email identities using the email address. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ses/emailIdentity:EmailIdentity example email@example.com
 * ```
 * 
 */
@ResourceType(type="aws:ses/emailIdentity:EmailIdentity")
public class EmailIdentity extends com.pulumi.resources.CustomResource {
    /**
     * The ARN of the email identity.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The ARN of the email identity.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The email address to assign to SES.
     * 
     */
    @Export(name="email", refs={String.class}, tree="[0]")
    private Output<String> email;

    /**
     * @return The email address to assign to SES.
     * 
     */
    public Output<String> email() {
        return this.email;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public EmailIdentity(String name) {
        this(name, EmailIdentityArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public EmailIdentity(String name, EmailIdentityArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public EmailIdentity(String name, EmailIdentityArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ses/emailIdentity:EmailIdentity", name, args == null ? EmailIdentityArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private EmailIdentity(String name, Output<String> id, @Nullable EmailIdentityState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ses/emailIdentity:EmailIdentity", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static EmailIdentity get(String name, Output<String> id, @Nullable EmailIdentityState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new EmailIdentity(name, id, state, options);
    }
}
