// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.servicecatalog;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ProvisioningArtifactArgs extends com.pulumi.resources.ResourceArgs {

    public static final ProvisioningArtifactArgs Empty = new ProvisioningArtifactArgs();

    /**
     * Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). The default value is `en`.
     * 
     */
    @Import(name="acceptLanguage")
    private @Nullable Output<String> acceptLanguage;

    /**
     * @return Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). The default value is `en`.
     * 
     */
    public Optional<Output<String>> acceptLanguage() {
        return Optional.ofNullable(this.acceptLanguage);
    }

    /**
     * Whether the product version is active. Inactive provisioning artifacts are invisible to end users. End users cannot launch or update a provisioned product from an inactive provisioning artifact. Default is `true`.
     * 
     */
    @Import(name="active")
    private @Nullable Output<Boolean> active;

    /**
     * @return Whether the product version is active. Inactive provisioning artifacts are invisible to end users. End users cannot launch or update a provisioned product from an inactive provisioning artifact. Default is `true`.
     * 
     */
    public Optional<Output<Boolean>> active() {
        return Optional.ofNullable(this.active);
    }

    /**
     * Description of the provisioning artifact (i.e., version), including how it differs from the previous provisioning artifact.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return Description of the provisioning artifact (i.e., version), including how it differs from the previous provisioning artifact.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * Whether AWS Service Catalog stops validating the specified provisioning artifact template even if it is invalid.
     * 
     */
    @Import(name="disableTemplateValidation")
    private @Nullable Output<Boolean> disableTemplateValidation;

    /**
     * @return Whether AWS Service Catalog stops validating the specified provisioning artifact template even if it is invalid.
     * 
     */
    public Optional<Output<Boolean>> disableTemplateValidation() {
        return Optional.ofNullable(this.disableTemplateValidation);
    }

    /**
     * Information set by the administrator to provide guidance to end users about which provisioning artifacts to use. Valid values are `DEFAULT` and `DEPRECATED`. The default is `DEFAULT`. Users are able to make updates to a provisioned product of a deprecated version but cannot launch new provisioned products using a deprecated version.
     * 
     */
    @Import(name="guidance")
    private @Nullable Output<String> guidance;

    /**
     * @return Information set by the administrator to provide guidance to end users about which provisioning artifacts to use. Valid values are `DEFAULT` and `DEPRECATED`. The default is `DEFAULT`. Users are able to make updates to a provisioned product of a deprecated version but cannot launch new provisioned products using a deprecated version.
     * 
     */
    public Optional<Output<String>> guidance() {
        return Optional.ofNullable(this.guidance);
    }

    /**
     * Name of the provisioning artifact (for example, `v1`, `v2beta`). No spaces are allowed.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Name of the provisioning artifact (for example, `v1`, `v2beta`). No spaces are allowed.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * Identifier of the product.
     * 
     */
    @Import(name="productId", required=true)
    private Output<String> productId;

    /**
     * @return Identifier of the product.
     * 
     */
    public Output<String> productId() {
        return this.productId;
    }

    /**
     * Template source as the physical ID of the resource that contains the template. Currently only supports CloudFormation stack ARN. Specify the physical ID as `arn:[partition]:cloudformation:[region]:[account ID]:stack/[stack name]/[resource ID]`.
     * 
     */
    @Import(name="templatePhysicalId")
    private @Nullable Output<String> templatePhysicalId;

    /**
     * @return Template source as the physical ID of the resource that contains the template. Currently only supports CloudFormation stack ARN. Specify the physical ID as `arn:[partition]:cloudformation:[region]:[account ID]:stack/[stack name]/[resource ID]`.
     * 
     */
    public Optional<Output<String>> templatePhysicalId() {
        return Optional.ofNullable(this.templatePhysicalId);
    }

    /**
     * Template source as URL of the CloudFormation template in Amazon S3.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="templateUrl")
    private @Nullable Output<String> templateUrl;

    /**
     * @return Template source as URL of the CloudFormation template in Amazon S3.
     * 
     * The following arguments are optional:
     * 
     */
    public Optional<Output<String>> templateUrl() {
        return Optional.ofNullable(this.templateUrl);
    }

    /**
     * Type of provisioning artifact. See [AWS Docs](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProvisioningArtifactProperties.html) for valid list of values.
     * 
     */
    @Import(name="type")
    private @Nullable Output<String> type;

    /**
     * @return Type of provisioning artifact. See [AWS Docs](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProvisioningArtifactProperties.html) for valid list of values.
     * 
     */
    public Optional<Output<String>> type() {
        return Optional.ofNullable(this.type);
    }

    private ProvisioningArtifactArgs() {}

    private ProvisioningArtifactArgs(ProvisioningArtifactArgs $) {
        this.acceptLanguage = $.acceptLanguage;
        this.active = $.active;
        this.description = $.description;
        this.disableTemplateValidation = $.disableTemplateValidation;
        this.guidance = $.guidance;
        this.name = $.name;
        this.productId = $.productId;
        this.templatePhysicalId = $.templatePhysicalId;
        this.templateUrl = $.templateUrl;
        this.type = $.type;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ProvisioningArtifactArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ProvisioningArtifactArgs $;

        public Builder() {
            $ = new ProvisioningArtifactArgs();
        }

        public Builder(ProvisioningArtifactArgs defaults) {
            $ = new ProvisioningArtifactArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param acceptLanguage Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). The default value is `en`.
         * 
         * @return builder
         * 
         */
        public Builder acceptLanguage(@Nullable Output<String> acceptLanguage) {
            $.acceptLanguage = acceptLanguage;
            return this;
        }

        /**
         * @param acceptLanguage Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). The default value is `en`.
         * 
         * @return builder
         * 
         */
        public Builder acceptLanguage(String acceptLanguage) {
            return acceptLanguage(Output.of(acceptLanguage));
        }

        /**
         * @param active Whether the product version is active. Inactive provisioning artifacts are invisible to end users. End users cannot launch or update a provisioned product from an inactive provisioning artifact. Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder active(@Nullable Output<Boolean> active) {
            $.active = active;
            return this;
        }

        /**
         * @param active Whether the product version is active. Inactive provisioning artifacts are invisible to end users. End users cannot launch or update a provisioned product from an inactive provisioning artifact. Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder active(Boolean active) {
            return active(Output.of(active));
        }

        /**
         * @param description Description of the provisioning artifact (i.e., version), including how it differs from the previous provisioning artifact.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description Description of the provisioning artifact (i.e., version), including how it differs from the previous provisioning artifact.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param disableTemplateValidation Whether AWS Service Catalog stops validating the specified provisioning artifact template even if it is invalid.
         * 
         * @return builder
         * 
         */
        public Builder disableTemplateValidation(@Nullable Output<Boolean> disableTemplateValidation) {
            $.disableTemplateValidation = disableTemplateValidation;
            return this;
        }

        /**
         * @param disableTemplateValidation Whether AWS Service Catalog stops validating the specified provisioning artifact template even if it is invalid.
         * 
         * @return builder
         * 
         */
        public Builder disableTemplateValidation(Boolean disableTemplateValidation) {
            return disableTemplateValidation(Output.of(disableTemplateValidation));
        }

        /**
         * @param guidance Information set by the administrator to provide guidance to end users about which provisioning artifacts to use. Valid values are `DEFAULT` and `DEPRECATED`. The default is `DEFAULT`. Users are able to make updates to a provisioned product of a deprecated version but cannot launch new provisioned products using a deprecated version.
         * 
         * @return builder
         * 
         */
        public Builder guidance(@Nullable Output<String> guidance) {
            $.guidance = guidance;
            return this;
        }

        /**
         * @param guidance Information set by the administrator to provide guidance to end users about which provisioning artifacts to use. Valid values are `DEFAULT` and `DEPRECATED`. The default is `DEFAULT`. Users are able to make updates to a provisioned product of a deprecated version but cannot launch new provisioned products using a deprecated version.
         * 
         * @return builder
         * 
         */
        public Builder guidance(String guidance) {
            return guidance(Output.of(guidance));
        }

        /**
         * @param name Name of the provisioning artifact (for example, `v1`, `v2beta`). No spaces are allowed.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Name of the provisioning artifact (for example, `v1`, `v2beta`). No spaces are allowed.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param productId Identifier of the product.
         * 
         * @return builder
         * 
         */
        public Builder productId(Output<String> productId) {
            $.productId = productId;
            return this;
        }

        /**
         * @param productId Identifier of the product.
         * 
         * @return builder
         * 
         */
        public Builder productId(String productId) {
            return productId(Output.of(productId));
        }

        /**
         * @param templatePhysicalId Template source as the physical ID of the resource that contains the template. Currently only supports CloudFormation stack ARN. Specify the physical ID as `arn:[partition]:cloudformation:[region]:[account ID]:stack/[stack name]/[resource ID]`.
         * 
         * @return builder
         * 
         */
        public Builder templatePhysicalId(@Nullable Output<String> templatePhysicalId) {
            $.templatePhysicalId = templatePhysicalId;
            return this;
        }

        /**
         * @param templatePhysicalId Template source as the physical ID of the resource that contains the template. Currently only supports CloudFormation stack ARN. Specify the physical ID as `arn:[partition]:cloudformation:[region]:[account ID]:stack/[stack name]/[resource ID]`.
         * 
         * @return builder
         * 
         */
        public Builder templatePhysicalId(String templatePhysicalId) {
            return templatePhysicalId(Output.of(templatePhysicalId));
        }

        /**
         * @param templateUrl Template source as URL of the CloudFormation template in Amazon S3.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder templateUrl(@Nullable Output<String> templateUrl) {
            $.templateUrl = templateUrl;
            return this;
        }

        /**
         * @param templateUrl Template source as URL of the CloudFormation template in Amazon S3.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder templateUrl(String templateUrl) {
            return templateUrl(Output.of(templateUrl));
        }

        /**
         * @param type Type of provisioning artifact. See [AWS Docs](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProvisioningArtifactProperties.html) for valid list of values.
         * 
         * @return builder
         * 
         */
        public Builder type(@Nullable Output<String> type) {
            $.type = type;
            return this;
        }

        /**
         * @param type Type of provisioning artifact. See [AWS Docs](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProvisioningArtifactProperties.html) for valid list of values.
         * 
         * @return builder
         * 
         */
        public Builder type(String type) {
            return type(Output.of(type));
        }

        public ProvisioningArtifactArgs build() {
            $.productId = Objects.requireNonNull($.productId, "expected parameter 'productId' to be non-null");
            return $;
        }
    }

}
