// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.securityhub;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.securityhub.StandardsSubscriptionArgs;
import com.pulumi.aws.securityhub.inputs.StandardsSubscriptionState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Subscribes to a Security Hub standard.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.securityhub.StandardsSubscription;
 * import com.pulumi.aws.securityhub.StandardsSubscriptionArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Account(&#34;example&#34;);
 * 
 *         final var current = AwsFunctions.getRegion();
 * 
 *         var cis = new StandardsSubscription(&#34;cis&#34;, StandardsSubscriptionArgs.builder()        
 *             .standardsArn(&#34;arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0&#34;)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 * 
 *         var pci321 = new StandardsSubscription(&#34;pci321&#34;, StandardsSubscriptionArgs.builder()        
 *             .standardsArn(String.format(&#34;arn:aws:securityhub:%s::standards/pci-dss/v/3.2.1&#34;, current.applyValue(getRegionResult -&gt; getRegionResult.name())))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * In TODO v1.5.0 and later, use an `import` block to import Security Hub standards subscriptions using the standards subscription ARN. For exampleterraform import {
 * 
 *  to = aws_securityhub_standards_subscription.cis
 * 
 *  id = &#34;arn:aws:securityhub:eu-west-1:123456789012:subscription/cis-aws-foundations-benchmark/v/1.2.0&#34; } terraform import {
 * 
 *  to = aws_securityhub_standards_subscription.pci_321
 * 
 *  id = &#34;arn:aws:securityhub:eu-west-1:123456789012:subscription/pci-dss/v/3.2.1&#34; } terraform import {
 * 
 *  to = aws_securityhub_standards_subscription.nist_800_53_rev_5
 * 
 *  id = &#34;arn:aws:securityhub:eu-west-1:123456789012:subscription/nist-800-53/v/5.0.0&#34; } Using `TODO import`, import Security Hub standards subscriptions using the standards subscription ARN. For exampleconsole % TODO import aws_securityhub_standards_subscription.cis arn:aws:securityhub:eu-west-1:123456789012:subscription/cis-aws-foundations-benchmark/v/1.2.0 console % TODO import aws_securityhub_standards_subscription.pci_321 arn:aws:securityhub:eu-west-1:123456789012:subscription/pci-dss/v/3.2.1 console % TODO import aws_securityhub_standards_subscription.nist_800_53_rev_5 arn:aws:securityhub:eu-west-1:123456789012:subscription/nist-800-53/v/5.0.0
 * 
 */
@ResourceType(type="aws:securityhub/standardsSubscription:StandardsSubscription")
public class StandardsSubscription extends com.pulumi.resources.CustomResource {
    /**
     * The ARN of a standard - see below.
     * 
     * Currently available standards (remember to replace `${var.region}` as appropriate):
     * 
     * | Name                                     | ARN                                                                                             |
     * |------------------------------------------|-------------------------------------------------------------------------------------------------|
     * | AWS Foundational Security Best Practices | `arn:aws:securityhub:${var.region}::standards/aws-foundational-security-best-practices/v/1.0.0` |
     * | CIS AWS Foundations Benchmark v1.2.0     | `arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0`                           |
     * | CIS AWS Foundations Benchmark v1.4.0     | `arn:aws:securityhub:${var.region}::standards/cis-aws-foundations-benchmark/v/1.4.0`            |
     * | NIST SP 800-53 Rev. 5                    | `arn:aws:securityhub:${var.region}::standards/nist-800-53/v/5.0.0`                              |
     * | PCI DSS                                  | `arn:aws:securityhub:${var.region}::standards/pci-dss/v/3.2.1`                                  |
     * 
     */
    @Export(name="standardsArn", refs={String.class}, tree="[0]")
    private Output<String> standardsArn;

    /**
     * @return The ARN of a standard - see below.
     * 
     * Currently available standards (remember to replace `${var.region}` as appropriate):
     * 
     * | Name                                     | ARN                                                                                             |
     * |------------------------------------------|-------------------------------------------------------------------------------------------------|
     * | AWS Foundational Security Best Practices | `arn:aws:securityhub:${var.region}::standards/aws-foundational-security-best-practices/v/1.0.0` |
     * | CIS AWS Foundations Benchmark v1.2.0     | `arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0`                           |
     * | CIS AWS Foundations Benchmark v1.4.0     | `arn:aws:securityhub:${var.region}::standards/cis-aws-foundations-benchmark/v/1.4.0`            |
     * | NIST SP 800-53 Rev. 5                    | `arn:aws:securityhub:${var.region}::standards/nist-800-53/v/5.0.0`                              |
     * | PCI DSS                                  | `arn:aws:securityhub:${var.region}::standards/pci-dss/v/3.2.1`                                  |
     * 
     */
    public Output<String> standardsArn() {
        return this.standardsArn;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public StandardsSubscription(String name) {
        this(name, StandardsSubscriptionArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public StandardsSubscription(String name, StandardsSubscriptionArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public StandardsSubscription(String name, StandardsSubscriptionArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:securityhub/standardsSubscription:StandardsSubscription", name, args == null ? StandardsSubscriptionArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private StandardsSubscription(String name, Output<String> id, @Nullable StandardsSubscriptionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:securityhub/standardsSubscription:StandardsSubscription", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static StandardsSubscription get(String name, Output<String> id, @Nullable StandardsSubscriptionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new StandardsSubscription(name, id, state, options);
    }
}
