// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.securityhub;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.securityhub.ProductSubscriptionArgs;
import com.pulumi.aws.securityhub.inputs.ProductSubscriptionState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Subscribes to a Security Hub product.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.securityhub.ProductSubscription;
 * import com.pulumi.aws.securityhub.ProductSubscriptionArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account(&#34;exampleAccount&#34;);
 * 
 *         final var current = AwsFunctions.getRegion();
 * 
 *         var exampleProductSubscription = new ProductSubscription(&#34;exampleProductSubscription&#34;, ProductSubscriptionArgs.builder()        
 *             .productArn(String.format(&#34;arn:aws:securityhub:%s:733251395267:product/alertlogic/althreatmanagement&#34;, current.applyValue(getRegionResult -&gt; getRegionResult.name())))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * In TODO v1.5.0 and later, use an `import` block to import Security Hub product subscriptions using `product_arn,arn`. For exampleterraform import {
 * 
 *  to = aws_securityhub_product_subscription.example
 * 
 *  id = &#34;arn:aws:securityhub:eu-west-1:733251395267:product/alertlogic/althreatmanagement,arn:aws:securityhub:eu-west-1:123456789012:product-subscription/alertlogic/althreatmanagement&#34; } Using `TODO import`, import Security Hub product subscriptions using `product_arn,arn`. For exampleconsole % TODO import aws_securityhub_product_subscription.example arn:aws:securityhub:eu-west-1:733251395267:product/alertlogic/althreatmanagement,arn:aws:securityhub:eu-west-1:123456789012:product-subscription/alertlogic/althreatmanagement
 * 
 */
@ResourceType(type="aws:securityhub/productSubscription:ProductSubscription")
public class ProductSubscription extends com.pulumi.resources.CustomResource {
    /**
     * The ARN of a resource that represents your subscription to the product that generates the findings that you want to import into Security Hub.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The ARN of a resource that represents your subscription to the product that generates the findings that you want to import into Security Hub.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The ARN of the product that generates findings that you want to import into Security Hub - see below.
     * 
     * Amazon maintains a list of [Product integrations in AWS Security Hub](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-providers.html) that changes over time. Any of the products on the linked [Available AWS service integrations](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-internal-providers.html) or [Available third-party partner product integrations](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-partner-providers.html) can be configured using `aws.securityhub.ProductSubscription`.
     * 
     * Available products can also be listed by running the AWS CLI command `aws securityhub describe-products`.
     * 
     * A subset of currently available products (remember to replace `${var.region}` as appropriate) includes:
     * 
     * * `arn:aws:securityhub:${var.region}::product/aws/guardduty`
     * * `arn:aws:securityhub:${var.region}::product/aws/inspector`
     * * `arn:aws:securityhub:${var.region}::product/aws/macie`
     * * `arn:aws:securityhub:${var.region}::product/alertlogic/althreatmanagement`
     * * `arn:aws:securityhub:${var.region}::product/armordefense/armoranywhere`
     * * `arn:aws:securityhub:${var.region}::product/barracuda/cloudsecurityguardian`
     * * `arn:aws:securityhub:${var.region}::product/checkpoint/cloudguard-iaas`
     * * `arn:aws:securityhub:${var.region}::product/checkpoint/dome9-arc`
     * * `arn:aws:securityhub:${var.region}::product/crowdstrike/crowdstrike-falcon`
     * * `arn:aws:securityhub:${var.region}::product/cyberark/cyberark-pta`
     * * `arn:aws:securityhub:${var.region}::product/f5networks/f5-advanced-waf`
     * * `arn:aws:securityhub:${var.region}::product/fortinet/fortigate`
     * * `arn:aws:securityhub:${var.region}::product/guardicore/aws-infection-monkey`
     * * `arn:aws:securityhub:${var.region}::product/guardicore/guardicore`
     * * `arn:aws:securityhub:${var.region}::product/ibm/qradar-siem`
     * * `arn:aws:securityhub:${var.region}::product/imperva/imperva-attack-analytics`
     * * `arn:aws:securityhub:${var.region}::product/mcafee-skyhigh/mcafee-mvision-cloud-aws`
     * * `arn:aws:securityhub:${var.region}::product/paloaltonetworks/redlock`
     * * `arn:aws:securityhub:${var.region}::product/paloaltonetworks/vm-series`
     * * `arn:aws:securityhub:${var.region}::product/qualys/qualys-pc`
     * * `arn:aws:securityhub:${var.region}::product/qualys/qualys-vm`
     * * `arn:aws:securityhub:${var.region}::product/rapid7/insightvm`
     * * `arn:aws:securityhub:${var.region}::product/sophos/sophos-server-protection`
     * * `arn:aws:securityhub:${var.region}::product/splunk/splunk-enterprise`
     * * `arn:aws:securityhub:${var.region}::product/splunk/splunk-phantom`
     * * `arn:aws:securityhub:${var.region}::product/sumologicinc/sumologic-mda`
     * * `arn:aws:securityhub:${var.region}::product/symantec-corp/symantec-cwp`
     * * `arn:aws:securityhub:${var.region}::product/tenable/tenable-io`
     * * `arn:aws:securityhub:${var.region}::product/trend-micro/deep-security`
     * * `arn:aws:securityhub:${var.region}::product/turbot/turbot`
     * * `arn:aws:securityhub:${var.region}::product/twistlock/twistlock-enterprise`
     * 
     */
    @Export(name="productArn", refs={String.class}, tree="[0]")
    private Output<String> productArn;

    /**
     * @return The ARN of the product that generates findings that you want to import into Security Hub - see below.
     * 
     * Amazon maintains a list of [Product integrations in AWS Security Hub](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-providers.html) that changes over time. Any of the products on the linked [Available AWS service integrations](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-internal-providers.html) or [Available third-party partner product integrations](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-partner-providers.html) can be configured using `aws.securityhub.ProductSubscription`.
     * 
     * Available products can also be listed by running the AWS CLI command `aws securityhub describe-products`.
     * 
     * A subset of currently available products (remember to replace `${var.region}` as appropriate) includes:
     * 
     * * `arn:aws:securityhub:${var.region}::product/aws/guardduty`
     * * `arn:aws:securityhub:${var.region}::product/aws/inspector`
     * * `arn:aws:securityhub:${var.region}::product/aws/macie`
     * * `arn:aws:securityhub:${var.region}::product/alertlogic/althreatmanagement`
     * * `arn:aws:securityhub:${var.region}::product/armordefense/armoranywhere`
     * * `arn:aws:securityhub:${var.region}::product/barracuda/cloudsecurityguardian`
     * * `arn:aws:securityhub:${var.region}::product/checkpoint/cloudguard-iaas`
     * * `arn:aws:securityhub:${var.region}::product/checkpoint/dome9-arc`
     * * `arn:aws:securityhub:${var.region}::product/crowdstrike/crowdstrike-falcon`
     * * `arn:aws:securityhub:${var.region}::product/cyberark/cyberark-pta`
     * * `arn:aws:securityhub:${var.region}::product/f5networks/f5-advanced-waf`
     * * `arn:aws:securityhub:${var.region}::product/fortinet/fortigate`
     * * `arn:aws:securityhub:${var.region}::product/guardicore/aws-infection-monkey`
     * * `arn:aws:securityhub:${var.region}::product/guardicore/guardicore`
     * * `arn:aws:securityhub:${var.region}::product/ibm/qradar-siem`
     * * `arn:aws:securityhub:${var.region}::product/imperva/imperva-attack-analytics`
     * * `arn:aws:securityhub:${var.region}::product/mcafee-skyhigh/mcafee-mvision-cloud-aws`
     * * `arn:aws:securityhub:${var.region}::product/paloaltonetworks/redlock`
     * * `arn:aws:securityhub:${var.region}::product/paloaltonetworks/vm-series`
     * * `arn:aws:securityhub:${var.region}::product/qualys/qualys-pc`
     * * `arn:aws:securityhub:${var.region}::product/qualys/qualys-vm`
     * * `arn:aws:securityhub:${var.region}::product/rapid7/insightvm`
     * * `arn:aws:securityhub:${var.region}::product/sophos/sophos-server-protection`
     * * `arn:aws:securityhub:${var.region}::product/splunk/splunk-enterprise`
     * * `arn:aws:securityhub:${var.region}::product/splunk/splunk-phantom`
     * * `arn:aws:securityhub:${var.region}::product/sumologicinc/sumologic-mda`
     * * `arn:aws:securityhub:${var.region}::product/symantec-corp/symantec-cwp`
     * * `arn:aws:securityhub:${var.region}::product/tenable/tenable-io`
     * * `arn:aws:securityhub:${var.region}::product/trend-micro/deep-security`
     * * `arn:aws:securityhub:${var.region}::product/turbot/turbot`
     * * `arn:aws:securityhub:${var.region}::product/twistlock/twistlock-enterprise`
     * 
     */
    public Output<String> productArn() {
        return this.productArn;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ProductSubscription(String name) {
        this(name, ProductSubscriptionArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ProductSubscription(String name, ProductSubscriptionArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ProductSubscription(String name, ProductSubscriptionArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:securityhub/productSubscription:ProductSubscription", name, args == null ? ProductSubscriptionArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ProductSubscription(String name, Output<String> id, @Nullable ProductSubscriptionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:securityhub/productSubscription:ProductSubscription", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ProductSubscription get(String name, Output<String> id, @Nullable ProductSubscriptionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ProductSubscription(name, id, state, options);
    }
}
