// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.securityhub;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.securityhub.ActionTargetArgs;
import com.pulumi.aws.securityhub.inputs.ActionTargetState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Creates Security Hub custom action.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.ActionTarget;
 * import com.pulumi.aws.securityhub.ActionTargetArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account(&#34;exampleAccount&#34;);
 * 
 *         var exampleActionTarget = new ActionTarget(&#34;exampleActionTarget&#34;, ActionTargetArgs.builder()        
 *             .identifier(&#34;SendToChat&#34;)
 *             .description(&#34;This is custom action sends selected findings to chat&#34;)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Security Hub custom action using the action target ARN. For example:
 * 
 * ```sh
 *  $ pulumi import aws:securityhub/actionTarget:ActionTarget example arn:aws:securityhub:eu-west-1:312940875350:action/custom/a
 * ```
 * 
 */
@ResourceType(type="aws:securityhub/actionTarget:ActionTarget")
public class ActionTarget extends com.pulumi.resources.CustomResource {
    /**
     * Amazon Resource Name (ARN) of the Security Hub custom action target.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the Security Hub custom action target.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The name of the custom action target.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output<String> description;

    /**
     * @return The name of the custom action target.
     * 
     */
    public Output<String> description() {
        return this.description;
    }
    /**
     * The ID for the custom action target.
     * 
     */
    @Export(name="identifier", refs={String.class}, tree="[0]")
    private Output<String> identifier;

    /**
     * @return The ID for the custom action target.
     * 
     */
    public Output<String> identifier() {
        return this.identifier;
    }
    /**
     * The description for the custom action target.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The description for the custom action target.
     * 
     */
    public Output<String> name() {
        return this.name;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ActionTarget(String name) {
        this(name, ActionTargetArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ActionTarget(String name, ActionTargetArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ActionTarget(String name, ActionTargetArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:securityhub/actionTarget:ActionTarget", name, args == null ? ActionTargetArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ActionTarget(String name, Output<String> id, @Nullable ActionTargetState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:securityhub/actionTarget:ActionTarget", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ActionTarget get(String name, Output<String> id, @Nullable ActionTargetState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ActionTarget(name, id, state, options);
    }
}
