// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.secretsmanager.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class SecretReplicaArgs extends com.pulumi.resources.ResourceArgs {

    public static final SecretReplicaArgs Empty = new SecretReplicaArgs();

    /**
     * ARN, Key ID, or Alias of the AWS KMS key within the region secret is replicated to. If one is not specified, then Secrets Manager defaults to using the AWS account&#39;s default KMS key (`aws/secretsmanager`) in the region or creates one for use if non-existent.
     * 
     */
    @Import(name="kmsKeyId")
    private @Nullable Output<String> kmsKeyId;

    /**
     * @return ARN, Key ID, or Alias of the AWS KMS key within the region secret is replicated to. If one is not specified, then Secrets Manager defaults to using the AWS account&#39;s default KMS key (`aws/secretsmanager`) in the region or creates one for use if non-existent.
     * 
     */
    public Optional<Output<String>> kmsKeyId() {
        return Optional.ofNullable(this.kmsKeyId);
    }

    /**
     * Date that you last accessed the secret in the Region.
     * 
     */
    @Import(name="lastAccessedDate")
    private @Nullable Output<String> lastAccessedDate;

    /**
     * @return Date that you last accessed the secret in the Region.
     * 
     */
    public Optional<Output<String>> lastAccessedDate() {
        return Optional.ofNullable(this.lastAccessedDate);
    }

    /**
     * Region for replicating the secret.
     * 
     */
    @Import(name="region", required=true)
    private Output<String> region;

    /**
     * @return Region for replicating the secret.
     * 
     */
    public Output<String> region() {
        return this.region;
    }

    /**
     * Status can be `InProgress`, `Failed`, or `InSync`.
     * 
     */
    @Import(name="status")
    private @Nullable Output<String> status;

    /**
     * @return Status can be `InProgress`, `Failed`, or `InSync`.
     * 
     */
    public Optional<Output<String>> status() {
        return Optional.ofNullable(this.status);
    }

    /**
     * Message such as `Replication succeeded` or `Secret with this name already exists in this region`.
     * 
     */
    @Import(name="statusMessage")
    private @Nullable Output<String> statusMessage;

    /**
     * @return Message such as `Replication succeeded` or `Secret with this name already exists in this region`.
     * 
     */
    public Optional<Output<String>> statusMessage() {
        return Optional.ofNullable(this.statusMessage);
    }

    private SecretReplicaArgs() {}

    private SecretReplicaArgs(SecretReplicaArgs $) {
        this.kmsKeyId = $.kmsKeyId;
        this.lastAccessedDate = $.lastAccessedDate;
        this.region = $.region;
        this.status = $.status;
        this.statusMessage = $.statusMessage;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(SecretReplicaArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private SecretReplicaArgs $;

        public Builder() {
            $ = new SecretReplicaArgs();
        }

        public Builder(SecretReplicaArgs defaults) {
            $ = new SecretReplicaArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param kmsKeyId ARN, Key ID, or Alias of the AWS KMS key within the region secret is replicated to. If one is not specified, then Secrets Manager defaults to using the AWS account&#39;s default KMS key (`aws/secretsmanager`) in the region or creates one for use if non-existent.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(@Nullable Output<String> kmsKeyId) {
            $.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * @param kmsKeyId ARN, Key ID, or Alias of the AWS KMS key within the region secret is replicated to. If one is not specified, then Secrets Manager defaults to using the AWS account&#39;s default KMS key (`aws/secretsmanager`) in the region or creates one for use if non-existent.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(String kmsKeyId) {
            return kmsKeyId(Output.of(kmsKeyId));
        }

        /**
         * @param lastAccessedDate Date that you last accessed the secret in the Region.
         * 
         * @return builder
         * 
         */
        public Builder lastAccessedDate(@Nullable Output<String> lastAccessedDate) {
            $.lastAccessedDate = lastAccessedDate;
            return this;
        }

        /**
         * @param lastAccessedDate Date that you last accessed the secret in the Region.
         * 
         * @return builder
         * 
         */
        public Builder lastAccessedDate(String lastAccessedDate) {
            return lastAccessedDate(Output.of(lastAccessedDate));
        }

        /**
         * @param region Region for replicating the secret.
         * 
         * @return builder
         * 
         */
        public Builder region(Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region Region for replicating the secret.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param status Status can be `InProgress`, `Failed`, or `InSync`.
         * 
         * @return builder
         * 
         */
        public Builder status(@Nullable Output<String> status) {
            $.status = status;
            return this;
        }

        /**
         * @param status Status can be `InProgress`, `Failed`, or `InSync`.
         * 
         * @return builder
         * 
         */
        public Builder status(String status) {
            return status(Output.of(status));
        }

        /**
         * @param statusMessage Message such as `Replication succeeded` or `Secret with this name already exists in this region`.
         * 
         * @return builder
         * 
         */
        public Builder statusMessage(@Nullable Output<String> statusMessage) {
            $.statusMessage = statusMessage;
            return this;
        }

        /**
         * @param statusMessage Message such as `Replication succeeded` or `Secret with this name already exists in this region`.
         * 
         * @return builder
         * 
         */
        public Builder statusMessage(String statusMessage) {
            return statusMessage(Output.of(statusMessage));
        }

        public SecretReplicaArgs build() {
            $.region = Objects.requireNonNull($.region, "expected parameter 'region' to be non-null");
            return $;
        }
    }

}
