// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.secretsmanager.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class GetSecretVersionArgs extends com.pulumi.resources.InvokeArgs {

    public static final GetSecretVersionArgs Empty = new GetSecretVersionArgs();

    /**
     * Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
     * 
     */
    @Import(name="secretId", required=true)
    private Output<String> secretId;

    /**
     * @return Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
     * 
     */
    public Output<String> secretId() {
        return this.secretId;
    }

    /**
     * Specifies the unique identifier of the version of the secret that you want to retrieve. Overrides `version_stage`.
     * 
     */
    @Import(name="versionId")
    private @Nullable Output<String> versionId;

    /**
     * @return Specifies the unique identifier of the version of the secret that you want to retrieve. Overrides `version_stage`.
     * 
     */
    public Optional<Output<String>> versionId() {
        return Optional.ofNullable(this.versionId);
    }

    /**
     * Specifies the secret version that you want to retrieve by the staging label attached to the version. Defaults to `AWSCURRENT`.
     * 
     */
    @Import(name="versionStage")
    private @Nullable Output<String> versionStage;

    /**
     * @return Specifies the secret version that you want to retrieve by the staging label attached to the version. Defaults to `AWSCURRENT`.
     * 
     */
    public Optional<Output<String>> versionStage() {
        return Optional.ofNullable(this.versionStage);
    }

    private GetSecretVersionArgs() {}

    private GetSecretVersionArgs(GetSecretVersionArgs $) {
        this.secretId = $.secretId;
        this.versionId = $.versionId;
        this.versionStage = $.versionStage;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(GetSecretVersionArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private GetSecretVersionArgs $;

        public Builder() {
            $ = new GetSecretVersionArgs();
        }

        public Builder(GetSecretVersionArgs defaults) {
            $ = new GetSecretVersionArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param secretId Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
         * 
         * @return builder
         * 
         */
        public Builder secretId(Output<String> secretId) {
            $.secretId = secretId;
            return this;
        }

        /**
         * @param secretId Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
         * 
         * @return builder
         * 
         */
        public Builder secretId(String secretId) {
            return secretId(Output.of(secretId));
        }

        /**
         * @param versionId Specifies the unique identifier of the version of the secret that you want to retrieve. Overrides `version_stage`.
         * 
         * @return builder
         * 
         */
        public Builder versionId(@Nullable Output<String> versionId) {
            $.versionId = versionId;
            return this;
        }

        /**
         * @param versionId Specifies the unique identifier of the version of the secret that you want to retrieve. Overrides `version_stage`.
         * 
         * @return builder
         * 
         */
        public Builder versionId(String versionId) {
            return versionId(Output.of(versionId));
        }

        /**
         * @param versionStage Specifies the secret version that you want to retrieve by the staging label attached to the version. Defaults to `AWSCURRENT`.
         * 
         * @return builder
         * 
         */
        public Builder versionStage(@Nullable Output<String> versionStage) {
            $.versionStage = versionStage;
            return this;
        }

        /**
         * @param versionStage Specifies the secret version that you want to retrieve by the staging label attached to the version. Defaults to `AWSCURRENT`.
         * 
         * @return builder
         * 
         */
        public Builder versionStage(String versionStage) {
            return versionStage(Output.of(versionStage));
        }

        public GetSecretVersionArgs build() {
            $.secretId = Objects.requireNonNull($.secretId, "expected parameter 'secretId' to be non-null");
            return $;
        }
    }

}
