// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.schemas;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.schemas.DiscovererArgs;
import com.pulumi.aws.schemas.inputs.DiscovererState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an EventBridge Schema Discoverer resource.
 * 
 * &gt; **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventBus;
 * import com.pulumi.aws.schemas.Discoverer;
 * import com.pulumi.aws.schemas.DiscovererArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var messenger = new EventBus(&#34;messenger&#34;);
 * 
 *         var test = new Discoverer(&#34;test&#34;, DiscovererArgs.builder()        
 *             .sourceArn(messenger.arn())
 *             .description(&#34;Auto discover event schemas&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import EventBridge discoverers using the `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:schemas/discoverer:Discoverer test 123
 * ```
 * 
 */
@ResourceType(type="aws:schemas/discoverer:Discoverer")
public class Discoverer extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name (ARN) of the discoverer.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) of the discoverer.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The description of the discoverer. Maximum of 256 characters.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return The description of the discoverer. Maximum of 256 characters.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * The ARN of the event bus to discover event schemas on.
     * 
     */
    @Export(name="sourceArn", refs={String.class}, tree="[0]")
    private Output<String> sourceArn;

    /**
     * @return The ARN of the event bus to discover event schemas on.
     * 
     */
    public Output<String> sourceArn() {
        return this.sourceArn;
    }
    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Discoverer(String name) {
        this(name, DiscovererArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Discoverer(String name, DiscovererArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Discoverer(String name, DiscovererArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:schemas/discoverer:Discoverer", name, args == null ? DiscovererArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Discoverer(String name, Output<String> id, @Nullable DiscovererState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:schemas/discoverer:Discoverer", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Discoverer get(String name, Output<String> id, @Nullable DiscovererState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Discoverer(name, id, state, options);
    }
}
