// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.scheduler.inputs;

import com.pulumi.aws.scheduler.inputs.ScheduleTargetDeadLetterConfigArgs;
import com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersArgs;
import com.pulumi.aws.scheduler.inputs.ScheduleTargetEventbridgeParametersArgs;
import com.pulumi.aws.scheduler.inputs.ScheduleTargetKinesisParametersArgs;
import com.pulumi.aws.scheduler.inputs.ScheduleTargetRetryPolicyArgs;
import com.pulumi.aws.scheduler.inputs.ScheduleTargetSagemakerPipelineParametersArgs;
import com.pulumi.aws.scheduler.inputs.ScheduleTargetSqsParametersArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ScheduleTargetArgs extends com.pulumi.resources.ResourceArgs {

    public static final ScheduleTargetArgs Empty = new ScheduleTargetArgs();

    /**
     * ARN of the target of this schedule, such as a SQS queue or ECS cluster. For universal targets, this is a [Service ARN specific to the target service](https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html#supported-universal-targets).
     * 
     */
    @Import(name="arn", required=true)
    private Output<String> arn;

    /**
     * @return ARN of the target of this schedule, such as a SQS queue or ECS cluster. For universal targets, this is a [Service ARN specific to the target service](https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html#supported-universal-targets).
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }

    /**
     * Information about an Amazon SQS queue that EventBridge Scheduler uses as a dead-letter queue for your schedule. If specified, EventBridge Scheduler delivers failed events that could not be successfully delivered to a target to the queue. Detailed below.
     * 
     */
    @Import(name="deadLetterConfig")
    private @Nullable Output<ScheduleTargetDeadLetterConfigArgs> deadLetterConfig;

    /**
     * @return Information about an Amazon SQS queue that EventBridge Scheduler uses as a dead-letter queue for your schedule. If specified, EventBridge Scheduler delivers failed events that could not be successfully delivered to a target to the queue. Detailed below.
     * 
     */
    public Optional<Output<ScheduleTargetDeadLetterConfigArgs>> deadLetterConfig() {
        return Optional.ofNullable(this.deadLetterConfig);
    }

    /**
     * Templated target type for the Amazon ECS [`RunTask`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API operation. Detailed below.
     * 
     */
    @Import(name="ecsParameters")
    private @Nullable Output<ScheduleTargetEcsParametersArgs> ecsParameters;

    /**
     * @return Templated target type for the Amazon ECS [`RunTask`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API operation. Detailed below.
     * 
     */
    public Optional<Output<ScheduleTargetEcsParametersArgs>> ecsParameters() {
        return Optional.ofNullable(this.ecsParameters);
    }

    /**
     * Templated target type for the EventBridge [`PutEvents`](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html) API operation. Detailed below.
     * 
     */
    @Import(name="eventbridgeParameters")
    private @Nullable Output<ScheduleTargetEventbridgeParametersArgs> eventbridgeParameters;

    /**
     * @return Templated target type for the EventBridge [`PutEvents`](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html) API operation. Detailed below.
     * 
     */
    public Optional<Output<ScheduleTargetEventbridgeParametersArgs>> eventbridgeParameters() {
        return Optional.ofNullable(this.eventbridgeParameters);
    }

    /**
     * Text, or well-formed JSON, passed to the target. Read more in [Universal target](https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html).
     * 
     */
    @Import(name="input")
    private @Nullable Output<String> input;

    /**
     * @return Text, or well-formed JSON, passed to the target. Read more in [Universal target](https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html).
     * 
     */
    public Optional<Output<String>> input() {
        return Optional.ofNullable(this.input);
    }

    /**
     * Templated target type for the Amazon Kinesis [`PutRecord`](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_PutRecord.html) API operation. Detailed below.
     * 
     */
    @Import(name="kinesisParameters")
    private @Nullable Output<ScheduleTargetKinesisParametersArgs> kinesisParameters;

    /**
     * @return Templated target type for the Amazon Kinesis [`PutRecord`](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_PutRecord.html) API operation. Detailed below.
     * 
     */
    public Optional<Output<ScheduleTargetKinesisParametersArgs>> kinesisParameters() {
        return Optional.ofNullable(this.kinesisParameters);
    }

    /**
     * Information about the retry policy settings. Detailed below.
     * 
     */
    @Import(name="retryPolicy")
    private @Nullable Output<ScheduleTargetRetryPolicyArgs> retryPolicy;

    /**
     * @return Information about the retry policy settings. Detailed below.
     * 
     */
    public Optional<Output<ScheduleTargetRetryPolicyArgs>> retryPolicy() {
        return Optional.ofNullable(this.retryPolicy);
    }

    /**
     * ARN of the IAM role that EventBridge Scheduler will use for this target when the schedule is invoked. Read more in [Set up the execution role](https://docs.aws.amazon.com/scheduler/latest/UserGuide/setting-up.html#setting-up-execution-role).
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="roleArn", required=true)
    private Output<String> roleArn;

    /**
     * @return ARN of the IAM role that EventBridge Scheduler will use for this target when the schedule is invoked. Read more in [Set up the execution role](https://docs.aws.amazon.com/scheduler/latest/UserGuide/setting-up.html#setting-up-execution-role).
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> roleArn() {
        return this.roleArn;
    }

    /**
     * Templated target type for the Amazon SageMaker [`StartPipelineExecution`](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html) API operation. Detailed below.
     * 
     */
    @Import(name="sagemakerPipelineParameters")
    private @Nullable Output<ScheduleTargetSagemakerPipelineParametersArgs> sagemakerPipelineParameters;

    /**
     * @return Templated target type for the Amazon SageMaker [`StartPipelineExecution`](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html) API operation. Detailed below.
     * 
     */
    public Optional<Output<ScheduleTargetSagemakerPipelineParametersArgs>> sagemakerPipelineParameters() {
        return Optional.ofNullable(this.sagemakerPipelineParameters);
    }

    /**
     * The templated target type for the Amazon SQS [`SendMessage`](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html) API operation. Detailed below.
     * 
     */
    @Import(name="sqsParameters")
    private @Nullable Output<ScheduleTargetSqsParametersArgs> sqsParameters;

    /**
     * @return The templated target type for the Amazon SQS [`SendMessage`](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html) API operation. Detailed below.
     * 
     */
    public Optional<Output<ScheduleTargetSqsParametersArgs>> sqsParameters() {
        return Optional.ofNullable(this.sqsParameters);
    }

    private ScheduleTargetArgs() {}

    private ScheduleTargetArgs(ScheduleTargetArgs $) {
        this.arn = $.arn;
        this.deadLetterConfig = $.deadLetterConfig;
        this.ecsParameters = $.ecsParameters;
        this.eventbridgeParameters = $.eventbridgeParameters;
        this.input = $.input;
        this.kinesisParameters = $.kinesisParameters;
        this.retryPolicy = $.retryPolicy;
        this.roleArn = $.roleArn;
        this.sagemakerPipelineParameters = $.sagemakerPipelineParameters;
        this.sqsParameters = $.sqsParameters;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ScheduleTargetArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ScheduleTargetArgs $;

        public Builder() {
            $ = new ScheduleTargetArgs();
        }

        public Builder(ScheduleTargetArgs defaults) {
            $ = new ScheduleTargetArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param arn ARN of the target of this schedule, such as a SQS queue or ECS cluster. For universal targets, this is a [Service ARN specific to the target service](https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html#supported-universal-targets).
         * 
         * @return builder
         * 
         */
        public Builder arn(Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn ARN of the target of this schedule, such as a SQS queue or ECS cluster. For universal targets, this is a [Service ARN specific to the target service](https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html#supported-universal-targets).
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param deadLetterConfig Information about an Amazon SQS queue that EventBridge Scheduler uses as a dead-letter queue for your schedule. If specified, EventBridge Scheduler delivers failed events that could not be successfully delivered to a target to the queue. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder deadLetterConfig(@Nullable Output<ScheduleTargetDeadLetterConfigArgs> deadLetterConfig) {
            $.deadLetterConfig = deadLetterConfig;
            return this;
        }

        /**
         * @param deadLetterConfig Information about an Amazon SQS queue that EventBridge Scheduler uses as a dead-letter queue for your schedule. If specified, EventBridge Scheduler delivers failed events that could not be successfully delivered to a target to the queue. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder deadLetterConfig(ScheduleTargetDeadLetterConfigArgs deadLetterConfig) {
            return deadLetterConfig(Output.of(deadLetterConfig));
        }

        /**
         * @param ecsParameters Templated target type for the Amazon ECS [`RunTask`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API operation. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder ecsParameters(@Nullable Output<ScheduleTargetEcsParametersArgs> ecsParameters) {
            $.ecsParameters = ecsParameters;
            return this;
        }

        /**
         * @param ecsParameters Templated target type for the Amazon ECS [`RunTask`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API operation. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder ecsParameters(ScheduleTargetEcsParametersArgs ecsParameters) {
            return ecsParameters(Output.of(ecsParameters));
        }

        /**
         * @param eventbridgeParameters Templated target type for the EventBridge [`PutEvents`](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html) API operation. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder eventbridgeParameters(@Nullable Output<ScheduleTargetEventbridgeParametersArgs> eventbridgeParameters) {
            $.eventbridgeParameters = eventbridgeParameters;
            return this;
        }

        /**
         * @param eventbridgeParameters Templated target type for the EventBridge [`PutEvents`](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html) API operation. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder eventbridgeParameters(ScheduleTargetEventbridgeParametersArgs eventbridgeParameters) {
            return eventbridgeParameters(Output.of(eventbridgeParameters));
        }

        /**
         * @param input Text, or well-formed JSON, passed to the target. Read more in [Universal target](https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html).
         * 
         * @return builder
         * 
         */
        public Builder input(@Nullable Output<String> input) {
            $.input = input;
            return this;
        }

        /**
         * @param input Text, or well-formed JSON, passed to the target. Read more in [Universal target](https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html).
         * 
         * @return builder
         * 
         */
        public Builder input(String input) {
            return input(Output.of(input));
        }

        /**
         * @param kinesisParameters Templated target type for the Amazon Kinesis [`PutRecord`](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_PutRecord.html) API operation. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder kinesisParameters(@Nullable Output<ScheduleTargetKinesisParametersArgs> kinesisParameters) {
            $.kinesisParameters = kinesisParameters;
            return this;
        }

        /**
         * @param kinesisParameters Templated target type for the Amazon Kinesis [`PutRecord`](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_PutRecord.html) API operation. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder kinesisParameters(ScheduleTargetKinesisParametersArgs kinesisParameters) {
            return kinesisParameters(Output.of(kinesisParameters));
        }

        /**
         * @param retryPolicy Information about the retry policy settings. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder retryPolicy(@Nullable Output<ScheduleTargetRetryPolicyArgs> retryPolicy) {
            $.retryPolicy = retryPolicy;
            return this;
        }

        /**
         * @param retryPolicy Information about the retry policy settings. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder retryPolicy(ScheduleTargetRetryPolicyArgs retryPolicy) {
            return retryPolicy(Output.of(retryPolicy));
        }

        /**
         * @param roleArn ARN of the IAM role that EventBridge Scheduler will use for this target when the schedule is invoked. Read more in [Set up the execution role](https://docs.aws.amazon.com/scheduler/latest/UserGuide/setting-up.html#setting-up-execution-role).
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder roleArn(Output<String> roleArn) {
            $.roleArn = roleArn;
            return this;
        }

        /**
         * @param roleArn ARN of the IAM role that EventBridge Scheduler will use for this target when the schedule is invoked. Read more in [Set up the execution role](https://docs.aws.amazon.com/scheduler/latest/UserGuide/setting-up.html#setting-up-execution-role).
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder roleArn(String roleArn) {
            return roleArn(Output.of(roleArn));
        }

        /**
         * @param sagemakerPipelineParameters Templated target type for the Amazon SageMaker [`StartPipelineExecution`](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html) API operation. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder sagemakerPipelineParameters(@Nullable Output<ScheduleTargetSagemakerPipelineParametersArgs> sagemakerPipelineParameters) {
            $.sagemakerPipelineParameters = sagemakerPipelineParameters;
            return this;
        }

        /**
         * @param sagemakerPipelineParameters Templated target type for the Amazon SageMaker [`StartPipelineExecution`](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html) API operation. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder sagemakerPipelineParameters(ScheduleTargetSagemakerPipelineParametersArgs sagemakerPipelineParameters) {
            return sagemakerPipelineParameters(Output.of(sagemakerPipelineParameters));
        }

        /**
         * @param sqsParameters The templated target type for the Amazon SQS [`SendMessage`](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html) API operation. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder sqsParameters(@Nullable Output<ScheduleTargetSqsParametersArgs> sqsParameters) {
            $.sqsParameters = sqsParameters;
            return this;
        }

        /**
         * @param sqsParameters The templated target type for the Amazon SQS [`SendMessage`](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html) API operation. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder sqsParameters(ScheduleTargetSqsParametersArgs sqsParameters) {
            return sqsParameters(Output.of(sqsParameters));
        }

        public ScheduleTargetArgs build() {
            $.arn = Objects.requireNonNull($.arn, "expected parameter 'arn' to be non-null");
            $.roleArn = Objects.requireNonNull($.roleArn, "expected parameter 'roleArn' to be non-null");
            return $;
        }
    }

}
