// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.sagemaker.outputs;

import com.pulumi.aws.sagemaker.outputs.ModelContainerImageConfig;
import com.pulumi.core.annotations.CustomType;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ModelContainer {
    /**
     * @return The DNS host name for the container.
     * 
     */
    private @Nullable String containerHostname;
    /**
     * @return Environment variables for the Docker container.
     * A list of key value pairs.
     * 
     */
    private @Nullable Map<String,String> environment;
    /**
     * @return The registry path where the inference code image is stored in Amazon ECR.
     * 
     */
    private @Nullable String image;
    /**
     * @return Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). For more information see [Using a Private Docker Registry for Real-Time Inference Containers](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html). see Image Config.
     * 
     */
    private @Nullable ModelContainerImageConfig imageConfig;
    /**
     * @return The container hosts value `SingleModel/MultiModel`. The default value is `SingleModel`.
     * 
     */
    private @Nullable String mode;
    /**
     * @return The URL for the S3 location where model artifacts are stored.
     * 
     */
    private @Nullable String modelDataUrl;
    /**
     * @return The Amazon Resource Name (ARN) of the model package to use to create the model.
     * 
     */
    private @Nullable String modelPackageName;

    private ModelContainer() {}
    /**
     * @return The DNS host name for the container.
     * 
     */
    public Optional<String> containerHostname() {
        return Optional.ofNullable(this.containerHostname);
    }
    /**
     * @return Environment variables for the Docker container.
     * A list of key value pairs.
     * 
     */
    public Map<String,String> environment() {
        return this.environment == null ? Map.of() : this.environment;
    }
    /**
     * @return The registry path where the inference code image is stored in Amazon ECR.
     * 
     */
    public Optional<String> image() {
        return Optional.ofNullable(this.image);
    }
    /**
     * @return Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). For more information see [Using a Private Docker Registry for Real-Time Inference Containers](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html). see Image Config.
     * 
     */
    public Optional<ModelContainerImageConfig> imageConfig() {
        return Optional.ofNullable(this.imageConfig);
    }
    /**
     * @return The container hosts value `SingleModel/MultiModel`. The default value is `SingleModel`.
     * 
     */
    public Optional<String> mode() {
        return Optional.ofNullable(this.mode);
    }
    /**
     * @return The URL for the S3 location where model artifacts are stored.
     * 
     */
    public Optional<String> modelDataUrl() {
        return Optional.ofNullable(this.modelDataUrl);
    }
    /**
     * @return The Amazon Resource Name (ARN) of the model package to use to create the model.
     * 
     */
    public Optional<String> modelPackageName() {
        return Optional.ofNullable(this.modelPackageName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ModelContainer defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable String containerHostname;
        private @Nullable Map<String,String> environment;
        private @Nullable String image;
        private @Nullable ModelContainerImageConfig imageConfig;
        private @Nullable String mode;
        private @Nullable String modelDataUrl;
        private @Nullable String modelPackageName;
        public Builder() {}
        public Builder(ModelContainer defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.containerHostname = defaults.containerHostname;
    	      this.environment = defaults.environment;
    	      this.image = defaults.image;
    	      this.imageConfig = defaults.imageConfig;
    	      this.mode = defaults.mode;
    	      this.modelDataUrl = defaults.modelDataUrl;
    	      this.modelPackageName = defaults.modelPackageName;
        }

        @CustomType.Setter
        public Builder containerHostname(@Nullable String containerHostname) {
            this.containerHostname = containerHostname;
            return this;
        }
        @CustomType.Setter
        public Builder environment(@Nullable Map<String,String> environment) {
            this.environment = environment;
            return this;
        }
        @CustomType.Setter
        public Builder image(@Nullable String image) {
            this.image = image;
            return this;
        }
        @CustomType.Setter
        public Builder imageConfig(@Nullable ModelContainerImageConfig imageConfig) {
            this.imageConfig = imageConfig;
            return this;
        }
        @CustomType.Setter
        public Builder mode(@Nullable String mode) {
            this.mode = mode;
            return this;
        }
        @CustomType.Setter
        public Builder modelDataUrl(@Nullable String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
            return this;
        }
        @CustomType.Setter
        public Builder modelPackageName(@Nullable String modelPackageName) {
            this.modelPackageName = modelPackageName;
            return this;
        }
        public ModelContainer build() {
            final var o = new ModelContainer();
            o.containerHostname = containerHostname;
            o.environment = environment;
            o.image = image;
            o.imageConfig = imageConfig;
            o.mode = mode;
            o.modelDataUrl = modelDataUrl;
            o.modelPackageName = modelPackageName;
            return o;
        }
    }
}
