// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.sagemaker.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class DeviceFleetOutputConfigArgs extends com.pulumi.resources.ResourceArgs {

    public static final DeviceFleetOutputConfigArgs Empty = new DeviceFleetOutputConfigArgs();

    /**
     * The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job. If you don&#39;t provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role&#39;s account.
     * 
     */
    @Import(name="kmsKeyId")
    private @Nullable Output<String> kmsKeyId;

    /**
     * @return The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job. If you don&#39;t provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role&#39;s account.
     * 
     */
    public Optional<Output<String>> kmsKeyId() {
        return Optional.ofNullable(this.kmsKeyId);
    }

    /**
     * The Amazon Simple Storage (S3) bucker URI.
     * 
     */
    @Import(name="s3OutputLocation", required=true)
    private Output<String> s3OutputLocation;

    /**
     * @return The Amazon Simple Storage (S3) bucker URI.
     * 
     */
    public Output<String> s3OutputLocation() {
        return this.s3OutputLocation;
    }

    private DeviceFleetOutputConfigArgs() {}

    private DeviceFleetOutputConfigArgs(DeviceFleetOutputConfigArgs $) {
        this.kmsKeyId = $.kmsKeyId;
        this.s3OutputLocation = $.s3OutputLocation;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(DeviceFleetOutputConfigArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private DeviceFleetOutputConfigArgs $;

        public Builder() {
            $ = new DeviceFleetOutputConfigArgs();
        }

        public Builder(DeviceFleetOutputConfigArgs defaults) {
            $ = new DeviceFleetOutputConfigArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param kmsKeyId The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job. If you don&#39;t provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role&#39;s account.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(@Nullable Output<String> kmsKeyId) {
            $.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * @param kmsKeyId The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job. If you don&#39;t provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role&#39;s account.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(String kmsKeyId) {
            return kmsKeyId(Output.of(kmsKeyId));
        }

        /**
         * @param s3OutputLocation The Amazon Simple Storage (S3) bucker URI.
         * 
         * @return builder
         * 
         */
        public Builder s3OutputLocation(Output<String> s3OutputLocation) {
            $.s3OutputLocation = s3OutputLocation;
            return this;
        }

        /**
         * @param s3OutputLocation The Amazon Simple Storage (S3) bucker URI.
         * 
         * @return builder
         * 
         */
        public Builder s3OutputLocation(String s3OutputLocation) {
            return s3OutputLocation(Output.of(s3OutputLocation));
        }

        public DeviceFleetOutputConfigArgs build() {
            $.s3OutputLocation = Objects.requireNonNull($.s3OutputLocation, "expected parameter 's3OutputLocation' to be non-null");
            return $;
        }
    }

}
