// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.sagemaker.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class DataQualityJobDefinitionJobResourcesClusterConfigArgs extends com.pulumi.resources.ResourceArgs {

    public static final DataQualityJobDefinitionJobResourcesClusterConfigArgs Empty = new DataQualityJobDefinitionJobResourcesClusterConfigArgs();

    /**
     * The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1.
     * 
     */
    @Import(name="instanceCount", required=true)
    private Output<Integer> instanceCount;

    /**
     * @return The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1.
     * 
     */
    public Output<Integer> instanceCount() {
        return this.instanceCount;
    }

    /**
     * The ML compute instance type for the processing job.
     * 
     */
    @Import(name="instanceType", required=true)
    private Output<String> instanceType;

    /**
     * @return The ML compute instance type for the processing job.
     * 
     */
    public Output<String> instanceType() {
        return this.instanceType;
    }

    /**
     * The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
     * 
     */
    @Import(name="volumeKmsKeyId")
    private @Nullable Output<String> volumeKmsKeyId;

    /**
     * @return The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
     * 
     */
    public Optional<Output<String>> volumeKmsKeyId() {
        return Optional.ofNullable(this.volumeKmsKeyId);
    }

    /**
     * The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
     * 
     */
    @Import(name="volumeSizeInGb", required=true)
    private Output<Integer> volumeSizeInGb;

    /**
     * @return The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
     * 
     */
    public Output<Integer> volumeSizeInGb() {
        return this.volumeSizeInGb;
    }

    private DataQualityJobDefinitionJobResourcesClusterConfigArgs() {}

    private DataQualityJobDefinitionJobResourcesClusterConfigArgs(DataQualityJobDefinitionJobResourcesClusterConfigArgs $) {
        this.instanceCount = $.instanceCount;
        this.instanceType = $.instanceType;
        this.volumeKmsKeyId = $.volumeKmsKeyId;
        this.volumeSizeInGb = $.volumeSizeInGb;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(DataQualityJobDefinitionJobResourcesClusterConfigArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private DataQualityJobDefinitionJobResourcesClusterConfigArgs $;

        public Builder() {
            $ = new DataQualityJobDefinitionJobResourcesClusterConfigArgs();
        }

        public Builder(DataQualityJobDefinitionJobResourcesClusterConfigArgs defaults) {
            $ = new DataQualityJobDefinitionJobResourcesClusterConfigArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param instanceCount The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1.
         * 
         * @return builder
         * 
         */
        public Builder instanceCount(Output<Integer> instanceCount) {
            $.instanceCount = instanceCount;
            return this;
        }

        /**
         * @param instanceCount The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1.
         * 
         * @return builder
         * 
         */
        public Builder instanceCount(Integer instanceCount) {
            return instanceCount(Output.of(instanceCount));
        }

        /**
         * @param instanceType The ML compute instance type for the processing job.
         * 
         * @return builder
         * 
         */
        public Builder instanceType(Output<String> instanceType) {
            $.instanceType = instanceType;
            return this;
        }

        /**
         * @param instanceType The ML compute instance type for the processing job.
         * 
         * @return builder
         * 
         */
        public Builder instanceType(String instanceType) {
            return instanceType(Output.of(instanceType));
        }

        /**
         * @param volumeKmsKeyId The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
         * 
         * @return builder
         * 
         */
        public Builder volumeKmsKeyId(@Nullable Output<String> volumeKmsKeyId) {
            $.volumeKmsKeyId = volumeKmsKeyId;
            return this;
        }

        /**
         * @param volumeKmsKeyId The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
         * 
         * @return builder
         * 
         */
        public Builder volumeKmsKeyId(String volumeKmsKeyId) {
            return volumeKmsKeyId(Output.of(volumeKmsKeyId));
        }

        /**
         * @param volumeSizeInGb The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
         * 
         * @return builder
         * 
         */
        public Builder volumeSizeInGb(Output<Integer> volumeSizeInGb) {
            $.volumeSizeInGb = volumeSizeInGb;
            return this;
        }

        /**
         * @param volumeSizeInGb The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
         * 
         * @return builder
         * 
         */
        public Builder volumeSizeInGb(Integer volumeSizeInGb) {
            return volumeSizeInGb(Output.of(volumeSizeInGb));
        }

        public DataQualityJobDefinitionJobResourcesClusterConfigArgs build() {
            $.instanceCount = Objects.requireNonNull($.instanceCount, "expected parameter 'instanceCount' to be non-null");
            $.instanceType = Objects.requireNonNull($.instanceType, "expected parameter 'instanceType' to be non-null");
            $.volumeSizeInGb = Objects.requireNonNull($.volumeSizeInGb, "expected parameter 'volumeSizeInGb' to be non-null");
            return $;
        }
    }

}
