// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.sagemaker.inputs;

import com.pulumi.aws.sagemaker.inputs.AppResourceSpecArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class AppState extends com.pulumi.resources.ResourceArgs {

    public static final AppState Empty = new AppState();

    /**
     * The name of the app.
     * 
     */
    @Import(name="appName")
    private @Nullable Output<String> appName;

    /**
     * @return The name of the app.
     * 
     */
    public Optional<Output<String>> appName() {
        return Optional.ofNullable(this.appName);
    }

    /**
     * The type of app. Valid values are `JupyterServer`, `KernelGateway`, `RStudioServerPro`, `RSessionGateway` and `TensorBoard`.
     * 
     */
    @Import(name="appType")
    private @Nullable Output<String> appType;

    /**
     * @return The type of app. Valid values are `JupyterServer`, `KernelGateway`, `RStudioServerPro`, `RSessionGateway` and `TensorBoard`.
     * 
     */
    public Optional<Output<String>> appType() {
        return Optional.ofNullable(this.appType);
    }

    /**
     * The Amazon Resource Name (ARN) of the app.
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) of the app.
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * The domain ID.
     * 
     */
    @Import(name="domainId")
    private @Nullable Output<String> domainId;

    /**
     * @return The domain ID.
     * 
     */
    public Optional<Output<String>> domainId() {
        return Optional.ofNullable(this.domainId);
    }

    /**
     * The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.See Resource Spec below.
     * 
     */
    @Import(name="resourceSpec")
    private @Nullable Output<AppResourceSpecArgs> resourceSpec;

    /**
     * @return The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.See Resource Spec below.
     * 
     */
    public Optional<Output<AppResourceSpecArgs>> resourceSpec() {
        return Optional.ofNullable(this.resourceSpec);
    }

    /**
     * The name of the space. At least one of `user_profile_name` or `space_name` required.
     * 
     */
    @Import(name="spaceName")
    private @Nullable Output<String> spaceName;

    /**
     * @return The name of the space. At least one of `user_profile_name` or `space_name` required.
     * 
     */
    public Optional<Output<String>> spaceName() {
        return Optional.ofNullable(this.spaceName);
    }

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * The user profile name. At least one of `user_profile_name` or `space_name` required.
     * 
     */
    @Import(name="userProfileName")
    private @Nullable Output<String> userProfileName;

    /**
     * @return The user profile name. At least one of `user_profile_name` or `space_name` required.
     * 
     */
    public Optional<Output<String>> userProfileName() {
        return Optional.ofNullable(this.userProfileName);
    }

    private AppState() {}

    private AppState(AppState $) {
        this.appName = $.appName;
        this.appType = $.appType;
        this.arn = $.arn;
        this.domainId = $.domainId;
        this.resourceSpec = $.resourceSpec;
        this.spaceName = $.spaceName;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.userProfileName = $.userProfileName;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(AppState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private AppState $;

        public Builder() {
            $ = new AppState();
        }

        public Builder(AppState defaults) {
            $ = new AppState(Objects.requireNonNull(defaults));
        }

        /**
         * @param appName The name of the app.
         * 
         * @return builder
         * 
         */
        public Builder appName(@Nullable Output<String> appName) {
            $.appName = appName;
            return this;
        }

        /**
         * @param appName The name of the app.
         * 
         * @return builder
         * 
         */
        public Builder appName(String appName) {
            return appName(Output.of(appName));
        }

        /**
         * @param appType The type of app. Valid values are `JupyterServer`, `KernelGateway`, `RStudioServerPro`, `RSessionGateway` and `TensorBoard`.
         * 
         * @return builder
         * 
         */
        public Builder appType(@Nullable Output<String> appType) {
            $.appType = appType;
            return this;
        }

        /**
         * @param appType The type of app. Valid values are `JupyterServer`, `KernelGateway`, `RStudioServerPro`, `RSessionGateway` and `TensorBoard`.
         * 
         * @return builder
         * 
         */
        public Builder appType(String appType) {
            return appType(Output.of(appType));
        }

        /**
         * @param arn The Amazon Resource Name (ARN) of the app.
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn The Amazon Resource Name (ARN) of the app.
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param domainId The domain ID.
         * 
         * @return builder
         * 
         */
        public Builder domainId(@Nullable Output<String> domainId) {
            $.domainId = domainId;
            return this;
        }

        /**
         * @param domainId The domain ID.
         * 
         * @return builder
         * 
         */
        public Builder domainId(String domainId) {
            return domainId(Output.of(domainId));
        }

        /**
         * @param resourceSpec The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.See Resource Spec below.
         * 
         * @return builder
         * 
         */
        public Builder resourceSpec(@Nullable Output<AppResourceSpecArgs> resourceSpec) {
            $.resourceSpec = resourceSpec;
            return this;
        }

        /**
         * @param resourceSpec The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.See Resource Spec below.
         * 
         * @return builder
         * 
         */
        public Builder resourceSpec(AppResourceSpecArgs resourceSpec) {
            return resourceSpec(Output.of(resourceSpec));
        }

        /**
         * @param spaceName The name of the space. At least one of `user_profile_name` or `space_name` required.
         * 
         * @return builder
         * 
         */
        public Builder spaceName(@Nullable Output<String> spaceName) {
            $.spaceName = spaceName;
            return this;
        }

        /**
         * @param spaceName The name of the space. At least one of `user_profile_name` or `space_name` required.
         * 
         * @return builder
         * 
         */
        public Builder spaceName(String spaceName) {
            return spaceName(Output.of(spaceName));
        }

        /**
         * @param tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param userProfileName The user profile name. At least one of `user_profile_name` or `space_name` required.
         * 
         * @return builder
         * 
         */
        public Builder userProfileName(@Nullable Output<String> userProfileName) {
            $.userProfileName = userProfileName;
            return this;
        }

        /**
         * @param userProfileName The user profile name. At least one of `user_profile_name` or `space_name` required.
         * 
         * @return builder
         * 
         */
        public Builder userProfileName(String userProfileName) {
            return userProfileName(Output.of(userProfileName));
        }

        public AppState build() {
            return $;
        }
    }

}
