// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.sagemaker;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.sagemaker.StudioLifecycleConfigArgs;
import com.pulumi.aws.sagemaker.inputs.StudioLifecycleConfigState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a SageMaker Studio Lifecycle Config resource.
 * 
 * ## Example Usage
 * 
 * ## Import
 * 
 * Using `pulumi import`, import SageMaker Studio Lifecycle Configs using the `studio_lifecycle_config_name`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:sagemaker/studioLifecycleConfig:StudioLifecycleConfig example example
 * ```
 * 
 */
@ResourceType(type="aws:sagemaker/studioLifecycleConfig:StudioLifecycleConfig")
public class StudioLifecycleConfig extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Studio Lifecycle Config.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) assigned by AWS to this Studio Lifecycle Config.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The App type that the Lifecycle Configuration is attached to. Valid values are `JupyterServer` and `KernelGateway`.
     * 
     */
    @Export(name="studioLifecycleConfigAppType", refs={String.class}, tree="[0]")
    private Output<String> studioLifecycleConfigAppType;

    /**
     * @return The App type that the Lifecycle Configuration is attached to. Valid values are `JupyterServer` and `KernelGateway`.
     * 
     */
    public Output<String> studioLifecycleConfigAppType() {
        return this.studioLifecycleConfigAppType;
    }
    /**
     * The content of your Studio Lifecycle Configuration script. This content must be base64 encoded.
     * 
     */
    @Export(name="studioLifecycleConfigContent", refs={String.class}, tree="[0]")
    private Output<String> studioLifecycleConfigContent;

    /**
     * @return The content of your Studio Lifecycle Configuration script. This content must be base64 encoded.
     * 
     */
    public Output<String> studioLifecycleConfigContent() {
        return this.studioLifecycleConfigContent;
    }
    /**
     * The name of the Studio Lifecycle Configuration to create.
     * 
     */
    @Export(name="studioLifecycleConfigName", refs={String.class}, tree="[0]")
    private Output<String> studioLifecycleConfigName;

    /**
     * @return The name of the Studio Lifecycle Configuration to create.
     * 
     */
    public Output<String> studioLifecycleConfigName() {
        return this.studioLifecycleConfigName;
    }
    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public StudioLifecycleConfig(String name) {
        this(name, StudioLifecycleConfigArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public StudioLifecycleConfig(String name, StudioLifecycleConfigArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public StudioLifecycleConfig(String name, StudioLifecycleConfigArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sagemaker/studioLifecycleConfig:StudioLifecycleConfig", name, args == null ? StudioLifecycleConfigArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private StudioLifecycleConfig(String name, Output<String> id, @Nullable StudioLifecycleConfigState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sagemaker/studioLifecycleConfig:StudioLifecycleConfig", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static StudioLifecycleConfig get(String name, Output<String> id, @Nullable StudioLifecycleConfigState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new StudioLifecycleConfig(name, id, state, options);
    }
}
