// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.sagemaker;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.sagemaker.SpaceArgs;
import com.pulumi.aws.sagemaker.inputs.SpaceState;
import com.pulumi.aws.sagemaker.outputs.SpaceSpaceSettings;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a SageMaker Space resource.
 * 
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Space;
 * import com.pulumi.aws.sagemaker.SpaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Space(&#34;example&#34;, SpaceArgs.builder()        
 *             .domainId(aws_sagemaker_domain.test().id())
 *             .spaceName(&#34;example&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import SageMaker Spaces using the `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:sagemaker/space:Space test_space arn:aws:sagemaker:us-west-2:123456789012:space/domain-id/space-name
 * ```
 * 
 */
@ResourceType(type="aws:sagemaker/space:Space")
public class Space extends com.pulumi.resources.CustomResource {
    /**
     * The space&#39;s Amazon Resource Name (ARN).
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The space&#39;s Amazon Resource Name (ARN).
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The ID of the associated Domain.
     * 
     */
    @Export(name="domainId", refs={String.class}, tree="[0]")
    private Output<String> domainId;

    /**
     * @return The ID of the associated Domain.
     * 
     */
    public Output<String> domainId() {
        return this.domainId;
    }
    /**
     * The ID of the space&#39;s profile in the Amazon Elastic File System volume.
     * 
     */
    @Export(name="homeEfsFileSystemUid", refs={String.class}, tree="[0]")
    private Output<String> homeEfsFileSystemUid;

    /**
     * @return The ID of the space&#39;s profile in the Amazon Elastic File System volume.
     * 
     */
    public Output<String> homeEfsFileSystemUid() {
        return this.homeEfsFileSystemUid;
    }
    /**
     * The name of the space.
     * 
     */
    @Export(name="spaceName", refs={String.class}, tree="[0]")
    private Output<String> spaceName;

    /**
     * @return The name of the space.
     * 
     */
    public Output<String> spaceName() {
        return this.spaceName;
    }
    /**
     * A collection of space settings. See Space Settings below.
     * 
     */
    @Export(name="spaceSettings", refs={SpaceSpaceSettings.class}, tree="[0]")
    private Output</* @Nullable */ SpaceSpaceSettings> spaceSettings;

    /**
     * @return A collection of space settings. See Space Settings below.
     * 
     */
    public Output<Optional<SpaceSpaceSettings>> spaceSettings() {
        return Codegen.optional(this.spaceSettings);
    }
    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Space(String name) {
        this(name, SpaceArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Space(String name, SpaceArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Space(String name, SpaceArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sagemaker/space:Space", name, args == null ? SpaceArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Space(String name, Output<String> id, @Nullable SpaceState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sagemaker/space:Space", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Space get(String name, Output<String> id, @Nullable SpaceState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Space(name, id, state, options);
    }
}
