// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.sagemaker;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.sagemaker.MonitoringScheduleArgs;
import com.pulumi.aws.sagemaker.inputs.MonitoringScheduleState;
import com.pulumi.aws.sagemaker.outputs.MonitoringScheduleMonitoringScheduleConfig;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a SageMaker monitoring schedule resource.
 * 
 * ## Example Usage
 * 
 * Basic usage:
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.MonitoringSchedule;
 * import com.pulumi.aws.sagemaker.MonitoringScheduleArgs;
 * import com.pulumi.aws.sagemaker.inputs.MonitoringScheduleMonitoringScheduleConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new MonitoringSchedule(&#34;test&#34;, MonitoringScheduleArgs.builder()        
 *             .monitoringScheduleConfig(MonitoringScheduleMonitoringScheduleConfigArgs.builder()
 *                 .monitoringJobDefinitionName(aws_sagemaker_data_quality_job_definition.test().name())
 *                 .monitoringType(&#34;DataQuality&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import monitoring schedules using the `name`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:sagemaker/monitoringSchedule:MonitoringSchedule test_monitoring_schedule monitoring-schedule-foo
 * ```
 * 
 */
@ResourceType(type="aws:sagemaker/monitoringSchedule:MonitoringSchedule")
public class MonitoringSchedule extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this monitoring schedule.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) assigned by AWS to this monitoring schedule.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The configuration object that specifies the monitoring schedule and defines the monitoring job. Fields are documented below.
     * 
     */
    @Export(name="monitoringScheduleConfig", refs={MonitoringScheduleMonitoringScheduleConfig.class}, tree="[0]")
    private Output<MonitoringScheduleMonitoringScheduleConfig> monitoringScheduleConfig;

    /**
     * @return The configuration object that specifies the monitoring schedule and defines the monitoring job. Fields are documented below.
     * 
     */
    public Output<MonitoringScheduleMonitoringScheduleConfig> monitoringScheduleConfig() {
        return this.monitoringScheduleConfig;
    }
    /**
     * The name of the monitoring schedule. The name must be unique within an AWS Region within an AWS account. If omitted, the provider will assign a random, unique name.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name of the monitoring schedule. The name must be unique within an AWS Region within an AWS account. If omitted, the provider will assign a random, unique name.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public MonitoringSchedule(String name) {
        this(name, MonitoringScheduleArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public MonitoringSchedule(String name, MonitoringScheduleArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public MonitoringSchedule(String name, MonitoringScheduleArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sagemaker/monitoringSchedule:MonitoringSchedule", name, args == null ? MonitoringScheduleArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private MonitoringSchedule(String name, Output<String> id, @Nullable MonitoringScheduleState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sagemaker/monitoringSchedule:MonitoringSchedule", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static MonitoringSchedule get(String name, Output<String> id, @Nullable MonitoringScheduleState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new MonitoringSchedule(name, id, state, options);
    }
}
