// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.sagemaker;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.sagemaker.HumanTaskUIArgs;
import com.pulumi.aws.sagemaker.inputs.HumanTaskUIState;
import com.pulumi.aws.sagemaker.outputs.HumanTaskUIUiTemplate;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a SageMaker Human Task UI resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.HumanTaskUI;
 * import com.pulumi.aws.sagemaker.HumanTaskUIArgs;
 * import com.pulumi.aws.sagemaker.inputs.HumanTaskUIUiTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new HumanTaskUI(&#34;example&#34;, HumanTaskUIArgs.builder()        
 *             .humanTaskUiName(&#34;example&#34;)
 *             .uiTemplate(HumanTaskUIUiTemplateArgs.builder()
 *                 .content(Files.readString(Paths.get(&#34;sagemaker-human-task-ui-template.html&#34;)))
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import SageMaker Human Task UIs using the `human_task_ui_name`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:sagemaker/humanTaskUI:HumanTaskUI example example
 * ```
 * 
 */
@ResourceType(type="aws:sagemaker/humanTaskUI:HumanTaskUI")
public class HumanTaskUI extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Human Task UI.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) assigned by AWS to this Human Task UI.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The name of the Human Task UI.
     * 
     */
    @Export(name="humanTaskUiName", refs={String.class}, tree="[0]")
    private Output<String> humanTaskUiName;

    /**
     * @return The name of the Human Task UI.
     * 
     */
    public Output<String> humanTaskUiName() {
        return this.humanTaskUiName;
    }
    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * The Liquid template for the worker user interface. See UI Template below.
     * 
     */
    @Export(name="uiTemplate", refs={HumanTaskUIUiTemplate.class}, tree="[0]")
    private Output<HumanTaskUIUiTemplate> uiTemplate;

    /**
     * @return The Liquid template for the worker user interface. See UI Template below.
     * 
     */
    public Output<HumanTaskUIUiTemplate> uiTemplate() {
        return this.uiTemplate;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public HumanTaskUI(String name) {
        this(name, HumanTaskUIArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public HumanTaskUI(String name, HumanTaskUIArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public HumanTaskUI(String name, HumanTaskUIArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sagemaker/humanTaskUI:HumanTaskUI", name, args == null ? HumanTaskUIArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private HumanTaskUI(String name, Output<String> id, @Nullable HumanTaskUIState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sagemaker/humanTaskUI:HumanTaskUI", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static HumanTaskUI get(String name, Output<String> id, @Nullable HumanTaskUIState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new HumanTaskUI(name, id, state, options);
    }
}
