// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.sagemaker;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.sagemaker.CodeRepositoryArgs;
import com.pulumi.aws.sagemaker.inputs.CodeRepositoryState;
import com.pulumi.aws.sagemaker.outputs.CodeRepositoryGitConfig;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a SageMaker Code Repository resource.
 * 
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.CodeRepository;
 * import com.pulumi.aws.sagemaker.CodeRepositoryArgs;
 * import com.pulumi.aws.sagemaker.inputs.CodeRepositoryGitConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new CodeRepository(&#34;example&#34;, CodeRepositoryArgs.builder()        
 *             .codeRepositoryName(&#34;example&#34;)
 *             .gitConfig(CodeRepositoryGitConfigArgs.builder()
 *                 .repositoryUrl(&#34;https://github.com/github/docs.git&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Example with Secret
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.secretsmanager.Secret;
 * import com.pulumi.aws.secretsmanager.SecretVersion;
 * import com.pulumi.aws.secretsmanager.SecretVersionArgs;
 * import com.pulumi.aws.sagemaker.CodeRepository;
 * import com.pulumi.aws.sagemaker.CodeRepositoryArgs;
 * import com.pulumi.aws.sagemaker.inputs.CodeRepositoryGitConfigArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleSecret = new Secret(&#34;exampleSecret&#34;);
 * 
 *         var exampleSecretVersion = new SecretVersion(&#34;exampleSecretVersion&#34;, SecretVersionArgs.builder()        
 *             .secretId(exampleSecret.id())
 *             .secretString(serializeJson(
 *                 jsonObject(
 *                     jsonProperty(&#34;username&#34;, &#34;example&#34;),
 *                     jsonProperty(&#34;password&#34;, &#34;example&#34;)
 *                 )))
 *             .build());
 * 
 *         var exampleCodeRepository = new CodeRepository(&#34;exampleCodeRepository&#34;, CodeRepositoryArgs.builder()        
 *             .codeRepositoryName(&#34;example&#34;)
 *             .gitConfig(CodeRepositoryGitConfigArgs.builder()
 *                 .repositoryUrl(&#34;https://github.com/github/docs.git&#34;)
 *                 .secretArn(exampleSecret.arn())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleSecretVersion)
 *                 .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import SageMaker Code Repositories using the `name`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:sagemaker/codeRepository:CodeRepository test_code_repository my-code-repo
 * ```
 * 
 */
@ResourceType(type="aws:sagemaker/codeRepository:CodeRepository")
public class CodeRepository extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Code Repository.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) assigned by AWS to this Code Repository.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The name of the Code Repository (must be unique).
     * 
     */
    @Export(name="codeRepositoryName", refs={String.class}, tree="[0]")
    private Output<String> codeRepositoryName;

    /**
     * @return The name of the Code Repository (must be unique).
     * 
     */
    public Output<String> codeRepositoryName() {
        return this.codeRepositoryName;
    }
    /**
     * Specifies details about the repository. see Git Config details below.
     * 
     */
    @Export(name="gitConfig", refs={CodeRepositoryGitConfig.class}, tree="[0]")
    private Output<CodeRepositoryGitConfig> gitConfig;

    /**
     * @return Specifies details about the repository. see Git Config details below.
     * 
     */
    public Output<CodeRepositoryGitConfig> gitConfig() {
        return this.gitConfig;
    }
    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public CodeRepository(String name) {
        this(name, CodeRepositoryArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public CodeRepository(String name, CodeRepositoryArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public CodeRepository(String name, CodeRepositoryArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sagemaker/codeRepository:CodeRepository", name, args == null ? CodeRepositoryArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private CodeRepository(String name, Output<String> id, @Nullable CodeRepositoryState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sagemaker/codeRepository:CodeRepository", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static CodeRepository get(String name, Output<String> id, @Nullable CodeRepositoryState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new CodeRepository(name, id, state, options);
    }
}
