// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.sagemaker;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.sagemaker.AppImageConfigArgs;
import com.pulumi.aws.sagemaker.inputs.AppImageConfigState;
import com.pulumi.aws.sagemaker.outputs.AppImageConfigKernelGatewayImageConfig;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a SageMaker App Image Config resource.
 * 
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.AppImageConfig;
 * import com.pulumi.aws.sagemaker.AppImageConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigKernelSpecArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new AppImageConfig(&#34;test&#34;, AppImageConfigArgs.builder()        
 *             .appImageConfigName(&#34;example&#34;)
 *             .kernelGatewayImageConfig(AppImageConfigKernelGatewayImageConfigArgs.builder()
 *                 .kernelSpec(AppImageConfigKernelGatewayImageConfigKernelSpecArgs.builder()
 *                     .name(&#34;example&#34;)
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Default File System Config
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.AppImageConfig;
 * import com.pulumi.aws.sagemaker.AppImageConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigFileSystemConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigKernelSpecArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new AppImageConfig(&#34;test&#34;, AppImageConfigArgs.builder()        
 *             .appImageConfigName(&#34;example&#34;)
 *             .kernelGatewayImageConfig(AppImageConfigKernelGatewayImageConfigArgs.builder()
 *                 .fileSystemConfig()
 *                 .kernelSpec(AppImageConfigKernelGatewayImageConfigKernelSpecArgs.builder()
 *                     .name(&#34;example&#34;)
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import SageMaker App Image Configs using the `name`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:sagemaker/appImageConfig:AppImageConfig example example
 * ```
 * 
 */
@ResourceType(type="aws:sagemaker/appImageConfig:AppImageConfig")
public class AppImageConfig extends com.pulumi.resources.CustomResource {
    /**
     * The name of the App Image Config.
     * 
     */
    @Export(name="appImageConfigName", refs={String.class}, tree="[0]")
    private Output<String> appImageConfigName;

    /**
     * @return The name of the App Image Config.
     * 
     */
    public Output<String> appImageConfigName() {
        return this.appImageConfigName;
    }
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this App Image Config.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) assigned by AWS to this App Image Config.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app. See Kernel Gateway Image Config details below.
     * 
     */
    @Export(name="kernelGatewayImageConfig", refs={AppImageConfigKernelGatewayImageConfig.class}, tree="[0]")
    private Output</* @Nullable */ AppImageConfigKernelGatewayImageConfig> kernelGatewayImageConfig;

    /**
     * @return The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app. See Kernel Gateway Image Config details below.
     * 
     */
    public Output<Optional<AppImageConfigKernelGatewayImageConfig>> kernelGatewayImageConfig() {
        return Codegen.optional(this.kernelGatewayImageConfig);
    }
    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public AppImageConfig(String name) {
        this(name, AppImageConfigArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public AppImageConfig(String name, AppImageConfigArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public AppImageConfig(String name, AppImageConfigArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sagemaker/appImageConfig:AppImageConfig", name, args == null ? AppImageConfigArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private AppImageConfig(String name, Output<String> id, @Nullable AppImageConfigState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:sagemaker/appImageConfig:AppImageConfig", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static AppImageConfig get(String name, Output<String> id, @Nullable AppImageConfigState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new AppImageConfig(name, id, state, options);
    }
}
