// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.s3outposts.inputs;

import com.pulumi.aws.s3outposts.inputs.EndpointNetworkInterfaceArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class EndpointState extends com.pulumi.resources.ResourceArgs {

    public static final EndpointState Empty = new EndpointState();

    /**
     * Type of access for the network connectivity. Valid values are `Private` or `CustomerOwnedIp`.
     * 
     */
    @Import(name="accessType")
    private @Nullable Output<String> accessType;

    /**
     * @return Type of access for the network connectivity. Valid values are `Private` or `CustomerOwnedIp`.
     * 
     */
    public Optional<Output<String>> accessType() {
        return Optional.ofNullable(this.accessType);
    }

    /**
     * Amazon Resource Name (ARN) of the endpoint.
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the endpoint.
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * VPC CIDR block of the endpoint.
     * 
     */
    @Import(name="cidrBlock")
    private @Nullable Output<String> cidrBlock;

    /**
     * @return VPC CIDR block of the endpoint.
     * 
     */
    public Optional<Output<String>> cidrBlock() {
        return Optional.ofNullable(this.cidrBlock);
    }

    /**
     * UTC creation time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     * 
     */
    @Import(name="creationTime")
    private @Nullable Output<String> creationTime;

    /**
     * @return UTC creation time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     * 
     */
    public Optional<Output<String>> creationTime() {
        return Optional.ofNullable(this.creationTime);
    }

    /**
     * The ID of a Customer Owned IP Pool. For more on customer owned IP addresses see the [User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/local-rack.html#local-gateway-subnet).
     * 
     */
    @Import(name="customerOwnedIpv4Pool")
    private @Nullable Output<String> customerOwnedIpv4Pool;

    /**
     * @return The ID of a Customer Owned IP Pool. For more on customer owned IP addresses see the [User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/local-rack.html#local-gateway-subnet).
     * 
     */
    public Optional<Output<String>> customerOwnedIpv4Pool() {
        return Optional.ofNullable(this.customerOwnedIpv4Pool);
    }

    /**
     * Set of nested attributes for associated Elastic Network Interfaces (ENIs).
     * 
     */
    @Import(name="networkInterfaces")
    private @Nullable Output<List<EndpointNetworkInterfaceArgs>> networkInterfaces;

    /**
     * @return Set of nested attributes for associated Elastic Network Interfaces (ENIs).
     * 
     */
    public Optional<Output<List<EndpointNetworkInterfaceArgs>>> networkInterfaces() {
        return Optional.ofNullable(this.networkInterfaces);
    }

    /**
     * Identifier of the Outpost to contain this endpoint.
     * 
     */
    @Import(name="outpostId")
    private @Nullable Output<String> outpostId;

    /**
     * @return Identifier of the Outpost to contain this endpoint.
     * 
     */
    public Optional<Output<String>> outpostId() {
        return Optional.ofNullable(this.outpostId);
    }

    /**
     * Identifier of the EC2 Security Group.
     * 
     */
    @Import(name="securityGroupId")
    private @Nullable Output<String> securityGroupId;

    /**
     * @return Identifier of the EC2 Security Group.
     * 
     */
    public Optional<Output<String>> securityGroupId() {
        return Optional.ofNullable(this.securityGroupId);
    }

    /**
     * Identifier of the EC2 Subnet.
     * 
     */
    @Import(name="subnetId")
    private @Nullable Output<String> subnetId;

    /**
     * @return Identifier of the EC2 Subnet.
     * 
     */
    public Optional<Output<String>> subnetId() {
        return Optional.ofNullable(this.subnetId);
    }

    private EndpointState() {}

    private EndpointState(EndpointState $) {
        this.accessType = $.accessType;
        this.arn = $.arn;
        this.cidrBlock = $.cidrBlock;
        this.creationTime = $.creationTime;
        this.customerOwnedIpv4Pool = $.customerOwnedIpv4Pool;
        this.networkInterfaces = $.networkInterfaces;
        this.outpostId = $.outpostId;
        this.securityGroupId = $.securityGroupId;
        this.subnetId = $.subnetId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(EndpointState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private EndpointState $;

        public Builder() {
            $ = new EndpointState();
        }

        public Builder(EndpointState defaults) {
            $ = new EndpointState(Objects.requireNonNull(defaults));
        }

        /**
         * @param accessType Type of access for the network connectivity. Valid values are `Private` or `CustomerOwnedIp`.
         * 
         * @return builder
         * 
         */
        public Builder accessType(@Nullable Output<String> accessType) {
            $.accessType = accessType;
            return this;
        }

        /**
         * @param accessType Type of access for the network connectivity. Valid values are `Private` or `CustomerOwnedIp`.
         * 
         * @return builder
         * 
         */
        public Builder accessType(String accessType) {
            return accessType(Output.of(accessType));
        }

        /**
         * @param arn Amazon Resource Name (ARN) of the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn Amazon Resource Name (ARN) of the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param cidrBlock VPC CIDR block of the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder cidrBlock(@Nullable Output<String> cidrBlock) {
            $.cidrBlock = cidrBlock;
            return this;
        }

        /**
         * @param cidrBlock VPC CIDR block of the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder cidrBlock(String cidrBlock) {
            return cidrBlock(Output.of(cidrBlock));
        }

        /**
         * @param creationTime UTC creation time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
         * 
         * @return builder
         * 
         */
        public Builder creationTime(@Nullable Output<String> creationTime) {
            $.creationTime = creationTime;
            return this;
        }

        /**
         * @param creationTime UTC creation time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
         * 
         * @return builder
         * 
         */
        public Builder creationTime(String creationTime) {
            return creationTime(Output.of(creationTime));
        }

        /**
         * @param customerOwnedIpv4Pool The ID of a Customer Owned IP Pool. For more on customer owned IP addresses see the [User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/local-rack.html#local-gateway-subnet).
         * 
         * @return builder
         * 
         */
        public Builder customerOwnedIpv4Pool(@Nullable Output<String> customerOwnedIpv4Pool) {
            $.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
            return this;
        }

        /**
         * @param customerOwnedIpv4Pool The ID of a Customer Owned IP Pool. For more on customer owned IP addresses see the [User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/local-rack.html#local-gateway-subnet).
         * 
         * @return builder
         * 
         */
        public Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            return customerOwnedIpv4Pool(Output.of(customerOwnedIpv4Pool));
        }

        /**
         * @param networkInterfaces Set of nested attributes for associated Elastic Network Interfaces (ENIs).
         * 
         * @return builder
         * 
         */
        public Builder networkInterfaces(@Nullable Output<List<EndpointNetworkInterfaceArgs>> networkInterfaces) {
            $.networkInterfaces = networkInterfaces;
            return this;
        }

        /**
         * @param networkInterfaces Set of nested attributes for associated Elastic Network Interfaces (ENIs).
         * 
         * @return builder
         * 
         */
        public Builder networkInterfaces(List<EndpointNetworkInterfaceArgs> networkInterfaces) {
            return networkInterfaces(Output.of(networkInterfaces));
        }

        /**
         * @param networkInterfaces Set of nested attributes for associated Elastic Network Interfaces (ENIs).
         * 
         * @return builder
         * 
         */
        public Builder networkInterfaces(EndpointNetworkInterfaceArgs... networkInterfaces) {
            return networkInterfaces(List.of(networkInterfaces));
        }

        /**
         * @param outpostId Identifier of the Outpost to contain this endpoint.
         * 
         * @return builder
         * 
         */
        public Builder outpostId(@Nullable Output<String> outpostId) {
            $.outpostId = outpostId;
            return this;
        }

        /**
         * @param outpostId Identifier of the Outpost to contain this endpoint.
         * 
         * @return builder
         * 
         */
        public Builder outpostId(String outpostId) {
            return outpostId(Output.of(outpostId));
        }

        /**
         * @param securityGroupId Identifier of the EC2 Security Group.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupId(@Nullable Output<String> securityGroupId) {
            $.securityGroupId = securityGroupId;
            return this;
        }

        /**
         * @param securityGroupId Identifier of the EC2 Security Group.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupId(String securityGroupId) {
            return securityGroupId(Output.of(securityGroupId));
        }

        /**
         * @param subnetId Identifier of the EC2 Subnet.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(@Nullable Output<String> subnetId) {
            $.subnetId = subnetId;
            return this;
        }

        /**
         * @param subnetId Identifier of the EC2 Subnet.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(String subnetId) {
            return subnetId(Output.of(subnetId));
        }

        public EndpointState build() {
            return $;
        }
    }

}
