// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.s3control;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.s3control.MultiRegionAccessPointArgs;
import com.pulumi.aws.s3control.inputs.MultiRegionAccessPointState;
import com.pulumi.aws.s3control.outputs.MultiRegionAccessPointDetails;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Provides a resource to manage an S3 Multi-Region Access Point associated with specified buckets.
 * 
 * ## Example Usage
 * ### Multiple AWS Buckets in Different Regions
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3control.MultiRegionAccessPoint;
 * import com.pulumi.aws.s3control.MultiRegionAccessPointArgs;
 * import com.pulumi.aws.s3control.inputs.MultiRegionAccessPointDetailsArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var primaryRegion = new Provider(&#34;primaryRegion&#34;, ProviderArgs.builder()        
 *             .region(&#34;us-east-1&#34;)
 *             .build());
 * 
 *         var secondaryRegion = new Provider(&#34;secondaryRegion&#34;, ProviderArgs.builder()        
 *             .region(&#34;us-west-2&#34;)
 *             .build());
 * 
 *         var fooBucket = new BucketV2(&#34;fooBucket&#34;, BucketV2Args.Empty, CustomResourceOptions.builder()
 *             .provider(aws.primary_region())
 *             .build());
 * 
 *         var barBucket = new BucketV2(&#34;barBucket&#34;, BucketV2Args.Empty, CustomResourceOptions.builder()
 *             .provider(aws.secondary_region())
 *             .build());
 * 
 *         var example = new MultiRegionAccessPoint(&#34;example&#34;, MultiRegionAccessPointArgs.builder()        
 *             .details(MultiRegionAccessPointDetailsArgs.builder()
 *                 .name(&#34;example&#34;)
 *                 .regions(                
 *                     MultiRegionAccessPointDetailsRegionArgs.builder()
 *                         .bucket(fooBucket.id())
 *                         .build(),
 *                     MultiRegionAccessPointDetailsRegionArgs.builder()
 *                         .bucket(barBucket.id())
 *                         .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Multi-Region Access Points using the `account_id` and `name` of the Multi-Region Access Point separated by a colon (`:`). For example:
 * 
 * ```sh
 *  $ pulumi import aws:s3control/multiRegionAccessPoint:MultiRegionAccessPoint example 123456789012:example
 * ```
 * 
 */
@ResourceType(type="aws:s3control/multiRegionAccessPoint:MultiRegionAccessPoint")
public class MultiRegionAccessPoint extends com.pulumi.resources.CustomResource {
    /**
     * The AWS account ID for the owner of the buckets for which you want to create a Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
     * 
     */
    @Export(name="accountId", refs={String.class}, tree="[0]")
    private Output<String> accountId;

    /**
     * @return The AWS account ID for the owner of the buckets for which you want to create a Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
     * 
     */
    public Output<String> accountId() {
        return this.accountId;
    }
    /**
     * The alias for the Multi-Region Access Point.
     * 
     */
    @Export(name="alias", refs={String.class}, tree="[0]")
    private Output<String> alias;

    /**
     * @return The alias for the Multi-Region Access Point.
     * 
     */
    public Output<String> alias() {
        return this.alias;
    }
    /**
     * Amazon Resource Name (ARN) of the Multi-Region Access Point.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the Multi-Region Access Point.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * A configuration block containing details about the Multi-Region Access Point. See Details Configuration Block below for more details
     * 
     */
    @Export(name="details", refs={MultiRegionAccessPointDetails.class}, tree="[0]")
    private Output<MultiRegionAccessPointDetails> details;

    /**
     * @return A configuration block containing details about the Multi-Region Access Point. See Details Configuration Block below for more details
     * 
     */
    public Output<MultiRegionAccessPointDetails> details() {
        return this.details;
    }
    /**
     * The DNS domain name of the S3 Multi-Region Access Point in the format _`alias`_.accesspoint.s3-global.amazonaws.com. For more information, see the documentation on [Multi-Region Access Point Requests](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRequests.html).
     * 
     */
    @Export(name="domainName", refs={String.class}, tree="[0]")
    private Output<String> domainName;

    /**
     * @return The DNS domain name of the S3 Multi-Region Access Point in the format _`alias`_.accesspoint.s3-global.amazonaws.com. For more information, see the documentation on [Multi-Region Access Point Requests](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRequests.html).
     * 
     */
    public Output<String> domainName() {
        return this.domainName;
    }
    /**
     * The current status of the Multi-Region Access Point. One of: `READY`, `INCONSISTENT_ACROSS_REGIONS`, `CREATING`, `PARTIALLY_CREATED`, `PARTIALLY_DELETED`, `DELETING`.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output<String> status;

    /**
     * @return The current status of the Multi-Region Access Point. One of: `READY`, `INCONSISTENT_ACROSS_REGIONS`, `CREATING`, `PARTIALLY_CREATED`, `PARTIALLY_DELETED`, `DELETING`.
     * 
     */
    public Output<String> status() {
        return this.status;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public MultiRegionAccessPoint(String name) {
        this(name, MultiRegionAccessPointArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public MultiRegionAccessPoint(String name, MultiRegionAccessPointArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public MultiRegionAccessPoint(String name, MultiRegionAccessPointArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:s3control/multiRegionAccessPoint:MultiRegionAccessPoint", name, args == null ? MultiRegionAccessPointArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private MultiRegionAccessPoint(String name, Output<String> id, @Nullable MultiRegionAccessPointState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:s3control/multiRegionAccessPoint:MultiRegionAccessPoint", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static MultiRegionAccessPoint get(String name, Output<String> id, @Nullable MultiRegionAccessPointState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new MultiRegionAccessPoint(name, id, state, options);
    }
}
