// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.s3control;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.s3control.BucketLifecycleConfigurationArgs;
import com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationState;
import com.pulumi.aws.s3control.outputs.BucketLifecycleConfigurationRule;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import javax.annotation.Nullable;

/**
 * Provides a resource to manage an S3 Control Bucket Lifecycle Configuration.
 * 
 * &gt; **NOTE:** Each S3 Control Bucket can only have one Lifecycle Configuration. Using multiple of this resource against the same S3 Control Bucket will result in perpetual differences each provider run.
 * 
 * &gt; This functionality is for managing [S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html). To manage S3 Bucket Lifecycle Configurations in an AWS Partition, see the `aws.s3.BucketV2` resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3control.BucketLifecycleConfiguration;
 * import com.pulumi.aws.s3control.BucketLifecycleConfigurationArgs;
 * import com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleArgs;
 * import com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleExpirationArgs;
 * import com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new BucketLifecycleConfiguration(&#34;example&#34;, BucketLifecycleConfigurationArgs.builder()        
 *             .bucket(aws_s3control_bucket.example().arn())
 *             .rules(            
 *                 BucketLifecycleConfigurationRuleArgs.builder()
 *                     .expiration(BucketLifecycleConfigurationRuleExpirationArgs.builder()
 *                         .days(365)
 *                         .build())
 *                     .filter(BucketLifecycleConfigurationRuleFilterArgs.builder()
 *                         .prefix(&#34;logs/&#34;)
 *                         .build())
 *                     .id(&#34;logs&#34;)
 *                     .build(),
 *                 BucketLifecycleConfigurationRuleArgs.builder()
 *                     .expiration(BucketLifecycleConfigurationRuleExpirationArgs.builder()
 *                         .days(7)
 *                         .build())
 *                     .filter(BucketLifecycleConfigurationRuleFilterArgs.builder()
 *                         .prefix(&#34;temp/&#34;)
 *                         .build())
 *                     .id(&#34;temp&#34;)
 *                     .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import S3 Control Bucket Lifecycle Configurations using the Amazon Resource Name (ARN). For example:
 * 
 * ```sh
 *  $ pulumi import aws:s3control/bucketLifecycleConfiguration:BucketLifecycleConfiguration example arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-12345678/bucket/example
 * ```
 * 
 */
@ResourceType(type="aws:s3control/bucketLifecycleConfiguration:BucketLifecycleConfiguration")
public class BucketLifecycleConfiguration extends com.pulumi.resources.CustomResource {
    /**
     * Amazon Resource Name (ARN) of the bucket.
     * 
     */
    @Export(name="bucket", refs={String.class}, tree="[0]")
    private Output<String> bucket;

    /**
     * @return Amazon Resource Name (ARN) of the bucket.
     * 
     */
    public Output<String> bucket() {
        return this.bucket;
    }
    /**
     * Configuration block(s) containing lifecycle rules for the bucket.
     * 
     */
    @Export(name="rules", refs={List.class,BucketLifecycleConfigurationRule.class}, tree="[0,1]")
    private Output<List<BucketLifecycleConfigurationRule>> rules;

    /**
     * @return Configuration block(s) containing lifecycle rules for the bucket.
     * 
     */
    public Output<List<BucketLifecycleConfigurationRule>> rules() {
        return this.rules;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public BucketLifecycleConfiguration(String name) {
        this(name, BucketLifecycleConfigurationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public BucketLifecycleConfiguration(String name, BucketLifecycleConfigurationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public BucketLifecycleConfiguration(String name, BucketLifecycleConfigurationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:s3control/bucketLifecycleConfiguration:BucketLifecycleConfiguration", name, args == null ? BucketLifecycleConfigurationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private BucketLifecycleConfiguration(String name, Output<String> id, @Nullable BucketLifecycleConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:s3control/bucketLifecycleConfiguration:BucketLifecycleConfiguration", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static BucketLifecycleConfiguration get(String name, Output<String> id, @Nullable BucketLifecycleConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new BucketLifecycleConfiguration(name, id, state, options);
    }
}
